/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.OEdgeToVertexIterator;
import java.util.Collection;
import java.util.Iterator;

public class OEdgeToVertexIterable
implements Iterable<OVertex>,
OSizeable {
    private final Iterable<OEdge> edges;
    private final ODirection direction;

    public OEdgeToVertexIterable(Iterable<OEdge> edges, ODirection direction) {
        this.edges = edges;
        this.direction = direction;
    }

    @Override
    public Iterator<OVertex> iterator() {
        return new OEdgeToVertexIterator(this.edges.iterator(), this.direction);
    }

    @Override
    public int size() {
        if (this.edges == null) {
            return 0;
        }
        if (this.edges instanceof OSizeable) {
            return ((OSizeable)((Object)this.edges)).size();
        }
        if (this.edges instanceof Collection) {
            return ((Collection)this.edges).size();
        }
        Iterator<OEdge> iterator = this.edges.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
        }
        return count;
    }
}

