/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class ORecordBytes
extends ORecordAbstract
implements OBlob {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_SOURCE = new byte[0];

    public ORecordBytes() {
        this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
    }

    public ORecordBytes(ODatabaseDocumentInternal iDatabase) {
        this.setup(iDatabase);
        ODatabaseRecordThreadLocal.instance().set(iDatabase);
    }

    public ORecordBytes(ODatabaseDocumentInternal iDatabase, byte[] iSource) {
        this(iSource);
        ODatabaseRecordThreadLocal.instance().set(iDatabase);
    }

    public ORecordBytes(byte[] iSource) {
        super(iSource);
        this.dirty = true;
        this.contentChanged = true;
        this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
    }

    public ORecordBytes(ORID iRecordId) {
        this.recordId = (ORecordId)iRecordId;
        this.setup(ODatabaseRecordThreadLocal.instance().getIfDefined());
    }

    public ORecordBytes reset(byte[] iSource) {
        this.reset();
        this.source = iSource;
        return this;
    }

    public ORecordBytes copy() {
        return (ORecordBytes)this.copyTo(new ORecordBytes());
    }

    @Override
    public ORecordBytes fromStream(byte[] iRecordBuffer) {
        this.source = iRecordBuffer;
        this.status = ORecordElement.STATUS.LOADED;
        return this;
    }

    @Override
    public ORecordAbstract clear() {
        this.clearSource();
        return super.clear();
    }

    @Override
    public byte[] toStream() {
        return this.source;
    }

    @Override
    public byte getRecordType() {
        return 98;
    }

    @Override
    protected void setup(ODatabaseDocumentInternal db) {
        super.setup(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fromInputStream(InputStream in) throws IOException {
        try (OMemoryStream out = new OMemoryStream();){
            int readBytesCount;
            byte[] buffer = new byte[1024];
            while ((readBytesCount = in.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, readBytesCount);
            }
            out.flush();
            this.source = out.toByteArray();
        }
        this.size = this.source.length;
        return this.size;
    }

    @Override
    public int fromInputStream(InputStream in, int maxSize) throws IOException {
        int totalBytesCount;
        int readBytesCount;
        byte[] buffer = new byte[maxSize];
        for (totalBytesCount = 0; totalBytesCount < maxSize && (readBytesCount = in.read(buffer, totalBytesCount, buffer.length - totalBytesCount)) != -1; totalBytesCount += readBytesCount) {
        }
        if (totalBytesCount == 0) {
            this.source = EMPTY_SOURCE;
            this.size = 0;
        } else if (totalBytesCount == maxSize) {
            this.source = buffer;
            this.size = maxSize;
        } else {
            this.source = Arrays.copyOf(buffer, totalBytesCount);
            this.size = totalBytesCount;
        }
        return this.size;
    }

    @Override
    public void toOutputStream(OutputStream out) throws IOException {
        this.checkForLoading();
        if (this.source.length > 0) {
            out.write(this.source);
        }
    }
}

