/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import java.lang.ref.WeakReference;

public final class OSimpleMultiValueTracker<K, V> {
    private final WeakReference<ORecordElement> element;
    private OMultiValueChangeTimeLine<Object, Object> timeLine;
    private boolean enabled;
    private OMultiValueChangeTimeLine<K, V> transactionTimeLine;

    public OSimpleMultiValueTracker(ORecordElement element) {
        this.element = new WeakReference<ORecordElement>(element);
    }

    public void addNoDirty(K key, V value) {
        this.onAfterRecordChanged(new OMultiValueChangeEvent<K, Object>(OMultiValueChangeEvent.OChangeType.ADD, key, value, null), false);
    }

    public void removeNoDirty(K key, V value) {
        this.onAfterRecordChanged(new OMultiValueChangeEvent<K, Object>(OMultiValueChangeEvent.OChangeType.REMOVE, key, null, value), false);
    }

    public void add(K key, V value) {
        this.onAfterRecordChanged(new OMultiValueChangeEvent<K, V>(OMultiValueChangeEvent.OChangeType.ADD, key, value), true);
    }

    public void updated(K key, V newValue, V oldValue) {
        this.onAfterRecordChanged(new OMultiValueChangeEvent<K, V>(OMultiValueChangeEvent.OChangeType.UPDATE, key, newValue, oldValue), true);
    }

    public void remove(K key, V value) {
        this.onAfterRecordChanged(new OMultiValueChangeEvent<K, Object>(OMultiValueChangeEvent.OChangeType.REMOVE, key, null, value), true);
    }

    public void onAfterRecordChanged(OMultiValueChangeEvent<K, V> event, boolean changeOwner) {
        if (!this.enabled) {
            return;
        }
        ORecordElement document = (ORecordElement)this.element.get();
        if (document == null) {
            return;
        }
        if (changeOwner) {
            document.setDirty();
        } else {
            document.setDirtyNoChanged();
        }
        if (this.timeLine == null) {
            this.timeLine = new OMultiValueChangeTimeLine();
        }
        this.timeLine.addCollectionChangeEvent(event);
        if (this.transactionTimeLine == null) {
            this.transactionTimeLine = new OMultiValueChangeTimeLine();
        }
        this.transactionTimeLine.addCollectionChangeEvent(event);
    }

    public void enable() {
        if (!this.enabled) {
            this.enabled = true;
        }
    }

    public void disable() {
        if (this.enabled) {
            this.timeLine = null;
            this.enabled = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void sourceFrom(OSimpleMultiValueTracker<K, V> tracker) {
        this.timeLine = tracker.timeLine;
        this.transactionTimeLine = tracker.transactionTimeLine;
        this.enabled = tracker.enabled;
    }

    public OMultiValueChangeTimeLine<Object, Object> getTimeLine() {
        return this.timeLine;
    }

    public OMultiValueChangeTimeLine<K, V> getTransactionTimeLine() {
        return this.transactionTimeLine;
    }

    public void transactionClear() {
        this.transactionTimeLine = null;
    }
}

