/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.schedule;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.schedule.OScheduler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OSchedulerImpl {
    private ConcurrentHashMap<String, OScheduledEvent> events = new ConcurrentHashMap();
    private final OrientDBInternal orientDB;

    public OSchedulerImpl(OrientDBInternal orientDB) {
        this.orientDB = orientDB;
    }

    public void scheduleEvent(OScheduledEvent event) {
        if (event.getDocument().getIdentity().isNew()) {
            event.save();
        }
        if (this.events.putIfAbsent(event.getName(), event) == null) {
            String database = event.getDocument().getDatabase().getName();
            event.schedule(database, "admin", this.orientDB);
        }
    }

    public OScheduledEvent removeEventInternal(String eventName) {
        OScheduledEvent event = (OScheduledEvent)this.events.remove(eventName);
        if (event != null) {
            event.interrupt();
        }
        return event;
    }

    public void removeEvent(String eventName) {
        OLogManager.instance().debug((Object)this, "Removing scheduled event '%s'...", eventName);
        final OScheduledEvent event = this.removeEventInternal(eventName);
        if (event != null) {
            try {
                event.getDocument().reload();
            }
            catch (ORecordNotFoundException ignore) {
                return;
            }
            ODatabaseDocumentAbstract.executeWithRetries(new OCallable<Object, Integer>(){

                @Override
                public Object call(Integer iArgument) {
                    OLogManager.instance().debug((Object)this, "Deleting scheduled event '%s' rid=%s...", event, event.getDocument().getIdentity());
                    event.getDocument().delete();
                    return null;
                }
            }, 10, 0, new ORecord[]{event.getDocument()});
        }
    }

    public void updateEvent(OScheduledEvent event) {
        OScheduledEvent oldEvent = (OScheduledEvent)this.events.remove(event.getName());
        if (oldEvent != null) {
            oldEvent.interrupt();
        }
        this.scheduleEvent(event);
        OLogManager.instance().debug((Object)this, "Updated scheduled event '%s' rid=%s...", event, event.getDocument().getIdentity());
    }

    public Map<String, OScheduledEvent> getEvents() {
        return this.events;
    }

    public OScheduledEvent getEvent(String name) {
        return (OScheduledEvent)this.events.get(name);
    }

    public void load() {
        throw new UnsupportedOperationException();
    }

    public void load(ODatabaseDocumentInternal database) {
        if (database.getMetadata().getSchema().existsClass("OSchedule")) {
            ORecordIteratorClass<ODocument> result = database.browseClass("OSchedule");
            for (ODocument d : result) {
                OScheduledEvent event = new OScheduledEvent(d);
                if (this.events.putIfAbsent(event.getName(), event) != null) continue;
                this.scheduleEvent(event);
            }
        }
    }

    public void close() {
        for (OScheduledEvent event : this.events.values()) {
            event.interrupt();
        }
        this.events.clear();
    }

    public void create(ODatabaseDocumentInternal database) {
        if (database.getMetadata().getSchema().existsClass("OSchedule")) {
            return;
        }
        OClass f = database.getMetadata().getSchema().createClass("OSchedule");
        f.createProperty("name", OType.STRING, (OType)null, true).setMandatory(true).setNotNull(true);
        f.createProperty("rule", OType.STRING, (OType)null, true).setMandatory(true).setNotNull(true);
        f.createProperty("arguments", OType.EMBEDDEDMAP, (OType)null, true);
        f.createProperty("status", OType.STRING, (OType)null, true);
        f.createProperty("function", OType.LINK, database.getMetadata().getSchema().getClass("OFunction"), true).setMandatory(true).setNotNull(true);
        f.createProperty("starttime", OType.DATETIME, (OType)null, true);
    }

    public void initScheduleRecord(ODocument doc) {
        String name = (String)doc.field("name");
        OScheduledEvent event = this.getEvent(name);
        if (event != null && event.getDocument() != doc) {
            throw new ODatabaseException("Scheduled event with name '" + name + "' already exists in database");
        }
        doc.field("status", OScheduler.STATUS.STOPPED.name());
    }

    public void handleUpdateSchedule(ODocument doc) {
        try {
            String schedulerName = (String)doc.field("name");
            OScheduledEvent event = this.getEvent(schedulerName);
            if (event != null) {
                HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(doc.getDirtyFields()));
                if (dirtyFields.contains("name")) {
                    throw new OValidationException("Scheduled event cannot change name");
                }
                if (dirtyFields.contains("rule")) {
                    this.updateEvent(new OScheduledEvent(doc));
                } else {
                    doc.field("status", OScheduler.STATUS.STOPPED.name());
                    event.fromStream(doc);
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error(this, "Error on updating scheduled event", ex, new Object[0]);
        }
    }
}

