/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.security;

public enum OAuditingOperation {
    UNSPECIFIED(-1, "unspecified"),
    CREATED(3, "created"),
    LOADED(0, "loaded"),
    UPDATED(1, "updated"),
    DELETED(2, "deleted"),
    COMMAND(4, "command"),
    CREATEDCLASS(5, "createdClass"),
    DROPPEDCLASS(6, "droppedClass"),
    CHANGEDCONFIG(7, "changedConfig"),
    NODEJOINED(8, "nodeJoined"),
    NODELEFT(9, "nodeLeft"),
    SECURITY(10, "security"),
    RELOADEDSECURITY(11, "reloadedSecurity"),
    CHANGED_PWD(12, "changedPassword");

    private byte byteOp = (byte)-1;
    private String stringOp = "unspecified";

    private OAuditingOperation(byte byteOp, String stringOp) {
        this.byteOp = byteOp;
        this.stringOp = stringOp;
    }

    public byte getByte() {
        return this.byteOp;
    }

    public String toString() {
        return this.stringOp;
    }

    public static OAuditingOperation getByString(String value) {
        if (value == null || value.isEmpty()) {
            return UNSPECIFIED;
        }
        for (OAuditingOperation op : OAuditingOperation.values()) {
            if (!op.toString().equalsIgnoreCase(value)) continue;
            return op;
        }
        return UNSPECIFIED;
    }

    public static OAuditingOperation getByByte(byte value) {
        for (OAuditingOperation op : OAuditingOperation.values()) {
            if (op.getByte() != value) continue;
            return op;
        }
        return UNSPECIFIED;
    }
}

