/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDelegate;
import com.orientechnologies.orient.core.db.record.ridbag.embedded.OEmbeddedRidBag;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinaryV1;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.ChangeSerializationHelper;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeRidBag;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class HelperClasses {
    protected static final String CHARSET_UTF_8 = "UTF-8";
    protected static final ORecordId NULL_RECORD_ID = new ORecordId(-2, -1L);
    public static final long MILLISEC_PER_DAY = 86400000L;

    public static OType readOType(BytesContainer bytes, boolean justRunThrough) {
        if (justRunThrough) {
            ++bytes.offset;
            return null;
        }
        return OType.getById(HelperClasses.readByte(bytes));
    }

    public static void writeOType(BytesContainer bytes, int pos, OType type) {
        bytes.bytes[pos] = (byte)type.getId();
    }

    public static void writeType(BytesContainer bytes, OType type) {
        int pos = bytes.alloc(1);
        bytes.bytes[pos] = (byte)type.getId();
    }

    public static OType readType(BytesContainer bytes) {
        byte typeId;
        if ((typeId = bytes.bytes[bytes.offset++]) == -1) {
            return null;
        }
        return OType.getById(typeId);
    }

    public static byte[] readBinary(BytesContainer bytes) {
        int n = OVarIntSerializer.readAsInteger(bytes);
        byte[] newValue = new byte[n];
        System.arraycopy(bytes.bytes, bytes.offset, newValue, 0, newValue.length);
        bytes.skip(n);
        return newValue;
    }

    public static String readString(BytesContainer bytes) {
        int len = OVarIntSerializer.readAsInteger(bytes);
        if (len == 0) {
            return "";
        }
        String res = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len);
        bytes.skip(len);
        return res;
    }

    public static int readInteger(BytesContainer container) {
        int value = OIntegerSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 4;
        return value;
    }

    public static byte readByte(BytesContainer container) {
        return container.bytes[container.offset++];
    }

    public static long readLong(BytesContainer container) {
        long value = OLongSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 8;
        return value;
    }

    public static ORecordId readOptimizedLink(BytesContainer bytes, boolean justRunThrough) {
        int clusterId = OVarIntSerializer.readAsInteger(bytes);
        long clusterPos = OVarIntSerializer.readAsLong(bytes);
        if (justRunThrough) {
            return null;
        }
        return new ORecordId(clusterId, clusterPos);
    }

    public static String stringFromBytes(byte[] bytes, int offset, int len) {
        try {
            return new String(bytes, offset, len, CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error on string decoding"), e);
        }
    }

    public static byte[] bytesFromString(String toWrite) {
        try {
            return toWrite.getBytes(CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error on string encoding"), e);
        }
    }

    public static long convertDayToTimezone(TimeZone from, TimeZone to, long time) {
        Calendar fromCalendar = Calendar.getInstance(from);
        fromCalendar.setTimeInMillis(time);
        Calendar toCalendar = Calendar.getInstance(to);
        toCalendar.setTimeInMillis(0L);
        toCalendar.set(0, fromCalendar.get(0));
        toCalendar.set(1, fromCalendar.get(1));
        toCalendar.set(2, fromCalendar.get(2));
        toCalendar.set(5, fromCalendar.get(5));
        toCalendar.set(11, 0);
        toCalendar.set(12, 0);
        toCalendar.set(13, 0);
        toCalendar.set(14, 0);
        return toCalendar.getTimeInMillis();
    }

    public static OGlobalProperty getGlobalProperty(ODocument document, int len) {
        int id = len * -1 - 1;
        return ODocumentInternal.getGlobalPropertyById(document, id);
    }

    public static int writeBinary(BytesContainer bytes, byte[] valueBytes) {
        int pointer = OVarIntSerializer.write(bytes, (long)valueBytes.length);
        int start = bytes.alloc(valueBytes.length);
        System.arraycopy(valueBytes, 0, bytes.bytes, start, valueBytes.length);
        return pointer;
    }

    public static int writeOptimizedLink(BytesContainer bytes, OIdentifiable link) {
        if (!link.getIdentity().isPersistent()) {
            try {
                Object real = link.getRecord();
                if (real != null) {
                    link = real;
                }
            }
            catch (ORecordNotFoundException real) {
                // empty catch block
            }
        }
        if (link.getIdentity().getClusterId() < 0) {
            throw new ODatabaseException("Impossible to serialize invalid link " + link.getIdentity());
        }
        int pos = OVarIntSerializer.write(bytes, (long)link.getIdentity().getClusterId());
        OVarIntSerializer.write(bytes, link.getIdentity().getClusterPosition());
        return pos;
    }

    public static int writeNullLink(BytesContainer bytes) {
        int pos = OVarIntSerializer.write(bytes, (long)NULL_RECORD_ID.getIdentity().getClusterId());
        OVarIntSerializer.write(bytes, NULL_RECORD_ID.getIdentity().getClusterPosition());
        return pos;
    }

    public static OType getTypeFromValueEmbedded(Object fieldValue) {
        OType type = OType.getTypeByValue(fieldValue);
        if (type == OType.LINK && fieldValue instanceof ODocument && !((ODocument)fieldValue).getIdentity().isValid()) {
            type = OType.EMBEDDED;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeLinkCollection(BytesContainer bytes, Collection<OIdentifiable> value) {
        boolean disabledAutoConversion;
        int pos = OVarIntSerializer.write(bytes, (long)value.size());
        boolean bl = disabledAutoConversion = value instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)value)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)value)).setAutoConvertToRecord(false);
        }
        try {
            for (OIdentifiable itemValue : value) {
                if (itemValue == null) {
                    HelperClasses.writeNullLink(bytes);
                    continue;
                }
                HelperClasses.writeOptimizedLink(bytes, itemValue);
            }
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)value)).setAutoConvertToRecord(true);
            }
        }
        return pos;
    }

    public static <T extends OTrackedMultiValue<?, OIdentifiable>> T readLinkCollection(BytesContainer bytes, T found, boolean justRunThrough) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            ORecordId id = HelperClasses.readOptimizedLink(bytes, justRunThrough);
            if (justRunThrough) continue;
            if (id.equals(NULL_RECORD_ID)) {
                found.addInternal(null);
                continue;
            }
            found.addInternal((ORecordId)id);
        }
        return found;
    }

    public static int writeString(BytesContainer bytes, String toWrite) {
        byte[] nameBytes = HelperClasses.bytesFromString(toWrite);
        int pointer = OVarIntSerializer.write(bytes, (long)nameBytes.length);
        int start = bytes.alloc(nameBytes.length);
        System.arraycopy(nameBytes, 0, bytes.bytes, start, nameBytes.length);
        return pointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeLinkMap(BytesContainer bytes, Map<Object, OIdentifiable> map) {
        boolean disabledAutoConversion;
        boolean bl = disabledAutoConversion = map instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)map)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(false);
        }
        try {
            int fullPos = OVarIntSerializer.write(bytes, (long)map.size());
            for (Map.Entry<Object, OIdentifiable> entry : map.entrySet()) {
                HelperClasses.writeString(bytes, entry.getKey().toString());
                if (entry.getValue() == null) {
                    HelperClasses.writeNullLink(bytes);
                    continue;
                }
                HelperClasses.writeOptimizedLink(bytes, entry.getValue());
            }
            int n = fullPos;
            return n;
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(true);
            }
        }
    }

    public static Map<Object, OIdentifiable> readLinkMap(BytesContainer bytes, ORecordElement owner, boolean justRunThrough) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        ORecordLazyMap result = null;
        if (!justRunThrough) {
            result = new ORecordLazyMap(owner);
        }
        while (size-- > 0) {
            String key = HelperClasses.readString(bytes);
            ORecordId value = HelperClasses.readOptimizedLink(bytes, justRunThrough);
            if (value.equals(NULL_RECORD_ID)) {
                result.putInternal(key, null);
                continue;
            }
            result.putInternal(key, value);
        }
        return result;
    }

    public static void writeByte(BytesContainer bytes, byte val) {
        int pos = bytes.alloc(1);
        OByteSerializer.INSTANCE.serialize(val, bytes.bytes, pos, new Object[0]);
    }

    public static void writeRidBag(BytesContainer bytes, ORidBag ridbag) {
        ridbag.checkAndConvert();
        UUID ownerUuid = ridbag.getTemporaryId();
        int positionOffset = bytes.offset;
        OSBTreeCollectionManager sbTreeCollectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
        UUID uuid = null;
        if (sbTreeCollectionManager != null) {
            uuid = sbTreeCollectionManager.listenForChanges(ridbag);
        }
        byte configByte = 0;
        if (ridbag.isEmbedded()) {
            configByte = (byte)(configByte | 1);
        }
        if (uuid != null) {
            configByte = (byte)(configByte | 2);
        }
        int posForWrite = bytes.alloc(1);
        OByteSerializer.INSTANCE.serialize(configByte, bytes.bytes, posForWrite, new Object[0]);
        if (ridbag.isEmbedded()) {
            HelperClasses.writeEmbeddedRidbag(bytes, ridbag);
        } else {
            HelperClasses.writeSBTreeRidbag(bytes, ridbag, ownerUuid);
        }
    }

    protected static void writeEmbeddedRidbag(BytesContainer bytes, ORidBag ridbag) {
        OVarIntSerializer.write(bytes, (long)ridbag.size());
        Object[] entries = ((OEmbeddedRidBag)ridbag.getDelegate()).getEntries();
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        for (int i = 0; i < entries.length; ++i) {
            Object entry = entries[i];
            if (!(entry instanceof OIdentifiable)) continue;
            OIdentifiable itemValue = (OIdentifiable)entry;
            ORID rid = itemValue.getIdentity();
            if (db != null && !db.isClosed() && db.getTransaction().isActive() && !itemValue.getIdentity().isPersistent()) {
                itemValue = db.getTransaction().getRecord(itemValue.getIdentity());
            }
            if (itemValue == null) {
                String errorMessage = "Found null entry in ridbag with rid=" + rid;
                OSerializationException exc = new OSerializationException(errorMessage);
                OLogManager.instance().error(ORecordSerializerBinaryV1.class, errorMessage, null, new Object[0]);
                throw exc;
            }
            entries[i] = itemValue.getIdentity();
            HelperClasses.writeLinkOptimized(bytes, itemValue);
        }
    }

    protected static void writeSBTreeRidbag(BytesContainer bytes, ORidBag ridbag, UUID ownerUuid) {
        ((OSBTreeRidBag)ridbag.getDelegate()).applyNewEntries();
        OBonsaiCollectionPointer pointer = ridbag.getPointer();
        boolean remoteMode = ODatabaseRecordThreadLocal.instance().get().getStorage() instanceof OStorageProxy;
        ORecordSerializationContext context = remoteMode ? null : ORecordSerializationContext.getContext();
        if (pointer == null && context != null) {
            int clusterId = HelperClasses.getHighLevelDocClusterId(ridbag);
            assert (clusterId > -1);
            try {
                OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                assert (atomicOperation != null);
                pointer = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager().createSBTree(clusterId, atomicOperation, ownerUuid);
            }
            catch (IOException e) {
                throw OException.wrapException(new ODatabaseException("Error during creation of ridbag"), e);
            }
        }
        ((OSBTreeRidBag)ridbag.getDelegate()).setCollectionPointer(pointer);
        OVarIntSerializer.write(bytes, pointer.getFileId());
        OVarIntSerializer.write(bytes, pointer.getRootPointer().getPageIndex());
        OVarIntSerializer.write(bytes, (long)pointer.getRootPointer().getPageOffset());
        OVarIntSerializer.write(bytes, (long)ridbag.size());
        if (context != null) {
            ((OSBTreeRidBag)ridbag.getDelegate()).handleContextSBTree(context, pointer);
            OVarIntSerializer.write(bytes, 0L);
        } else {
            OVarIntSerializer.write(bytes, 0L);
        }
    }

    private static int getHighLevelDocClusterId(ORidBag ridbag) {
        ORecordElement owner;
        ORidBagDelegate delegate = ridbag.getDelegate();
        for (owner = delegate.getOwner(); owner != null && owner.getOwner() != null; owner = owner.getOwner()) {
        }
        if (owner != null) {
            return ((OIdentifiable)((Object)owner)).getIdentity().getClusterId();
        }
        return -1;
    }

    public static void writeLinkOptimized(BytesContainer bytes, OIdentifiable link) {
        ORID id = link.getIdentity();
        OVarIntSerializer.write(bytes, (long)id.getClusterId());
        OVarIntSerializer.write(bytes, id.getClusterPosition());
    }

    public static ORidBag readRidbag(BytesContainer bytes) {
        byte configByte;
        boolean isEmbedded = ((configByte = OByteSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset++).byteValue()) & 1) != 0;
        UUID uuid = null;
        ORidBag ridbag = null;
        if (isEmbedded) {
            ridbag = new ORidBag();
            int size = OVarIntSerializer.readAsInteger(bytes);
            ridbag.getDelegate().setSize(size);
            for (int i = 0; i < size; ++i) {
                OIdentifiable record = HelperClasses.readLinkOptimizedEmbedded(bytes);
                ((OEmbeddedRidBag)ridbag.getDelegate()).addInternal(record);
            }
        } else {
            long fileId = OVarIntSerializer.readAsLong(bytes);
            long pageIndex = OVarIntSerializer.readAsLong(bytes);
            int pageOffset = OVarIntSerializer.readAsInteger(bytes);
            OVarIntSerializer.readAsInteger(bytes);
            OBonsaiCollectionPointer pointer = null;
            if (fileId != -1L) {
                pointer = new OBonsaiCollectionPointer(fileId, new OBonsaiBucketPointer(pageIndex, pageOffset));
            }
            HashMap<OIdentifiable, Change> changes = new HashMap<OIdentifiable, Change>();
            int changesSize = OVarIntSerializer.readAsInteger(bytes);
            for (int i = 0; i < changesSize; ++i) {
                OIdentifiable recId = HelperClasses.readLinkOptimizedSBTree(bytes);
                Change change = HelperClasses.deserializeChange(bytes);
                changes.put(recId, change);
            }
            ridbag = new ORidBag(pointer, changes, uuid);
            ridbag.getDelegate().setSize(-1);
        }
        return ridbag;
    }

    private static OIdentifiable readLinkOptimizedEmbedded(BytesContainer bytes) {
        ORecordId rid = new ORecordId(OVarIntSerializer.readAsInteger(bytes), OVarIntSerializer.readAsLong(bytes));
        ORecordId identifiable = null;
        if (rid.isTemporary()) {
            identifiable = (ORecordId)rid.getRecord();
        }
        if (identifiable == null) {
            identifiable = rid;
        }
        return identifiable;
    }

    private static OIdentifiable readLinkOptimizedSBTree(BytesContainer bytes) {
        ORecordId rid = new ORecordId(OVarIntSerializer.readAsInteger(bytes), OVarIntSerializer.readAsLong(bytes));
        ORecordId identifiable = rid.isTemporary() && rid.getRecord() != null ? rid.getRecord() : rid;
        return identifiable;
    }

    private static Change deserializeChange(BytesContainer bytes) {
        byte type = OByteSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
        bytes.skip(1);
        int change = OIntegerSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
        bytes.skip(4);
        return ChangeSerializationHelper.createChangeInstance(type, change);
    }

    public static OType getLinkedType(OClass clazz, OType type, String key) {
        OProperty prop;
        if (type != OType.EMBEDDEDLIST && type != OType.EMBEDDEDSET && type != OType.EMBEDDEDMAP) {
            return null;
        }
        if (clazz != null && (prop = clazz.getProperty(key)) != null) {
            return prop.getLinkedType();
        }
        return null;
    }

    protected static class MapRecordInfo
    extends RecordInfo {
        public String key;
        public OType keyType;

        protected MapRecordInfo() {
        }
    }

    protected static class RecordInfo {
        public int fieldStartOffset;
        public int fieldLength;
        public OType fieldType;

        protected RecordInfo() {
        }
    }

    public static class Tuple<T1, T2> {
        private final T1 firstVal;
        private final T2 secondVal;

        Tuple(T1 firstVal, T2 secondVal) {
            this.firstVal = firstVal;
            this.secondVal = secondVal;
        }

        public T1 getFirstVal() {
            return this.firstVal;
        }

        public T2 getSecondVal() {
            return this.secondVal;
        }
    }
}

