/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinaryV0;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinaryV1;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OResultBinary;
import com.orientechnologies.orient.core.sql.executor.OResult;
import java.util.Base64;

public class ORecordSerializerBinary
implements ORecordSerializer {
    public static final String NAME = "ORecordSerializerBinary";
    public static final ORecordSerializerBinary INSTANCE = new ORecordSerializerBinary();
    private static final byte CURRENT_RECORD_VERSION = 1;
    private ODocumentSerializer[] serializerByVersion;
    private final byte currentSerializerVersion;

    private void init() {
        this.serializerByVersion = new ODocumentSerializer[2];
        this.serializerByVersion[0] = new ORecordSerializerBinaryV0();
        this.serializerByVersion[1] = new ORecordSerializerBinaryV1();
    }

    public ORecordSerializerBinary(byte serializerVersion) {
        this.currentSerializerVersion = serializerVersion;
        this.init();
    }

    public ORecordSerializerBinary() {
        this.currentSerializerVersion = 1;
        this.init();
    }

    public int getNumberOfSupportedVersions() {
        return this.serializerByVersion.length;
    }

    @Override
    public int getCurrentVersion() {
        return this.currentSerializerVersion;
    }

    @Override
    public int getMinSupportedVersion() {
        return this.currentSerializerVersion;
    }

    public ODocumentSerializer getSerializer(int iVersion) {
        return this.serializerByVersion[iVersion];
    }

    public ODocumentSerializer getCurrentSerializer() {
        return this.serializerByVersion[this.currentSerializerVersion];
    }

    public String toString() {
        return NAME;
    }

    @Override
    public ORecord fromStream(byte[] iSource, ORecord iRecord, String[] iFields) {
        if (iSource == null || iSource.length == 0) {
            return iRecord;
        }
        if (iRecord == null) {
            iRecord = new ODocument();
        } else {
            if (iRecord instanceof OBlob) {
                iRecord.fromStream(iSource);
                return iRecord;
            }
            if (iRecord instanceof ORecordFlat) {
                iRecord.fromStream(iSource);
                return iRecord;
            }
        }
        BytesContainer container = new BytesContainer(iSource).skip(1);
        try {
            if (iFields != null && iFields.length > 0) {
                this.serializerByVersion[iSource[0]].deserializePartial((ODocument)iRecord, container, iFields);
            } else {
                this.serializerByVersion[iSource[0]].deserialize((ODocument)iRecord, container);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            OLogManager.instance().warn((Object)this, "Error deserializing record with id %s send this data for debugging: %s ", iRecord.getIdentity().toString(), Base64.getEncoder().encodeToString(iSource));
            throw e;
        }
        return iRecord;
    }

    @Override
    public byte[] toStream(ORecord record) {
        if (record instanceof OBlob) {
            return record.toStream();
        }
        if (record instanceof ORecordFlat) {
            return record.toStream();
        }
        ODocument documentToSerialize = (ODocument)record;
        BytesContainer container = new BytesContainer();
        int pos = container.alloc(1);
        container.bytes[pos] = this.currentSerializerVersion;
        this.serializerByVersion[this.currentSerializerVersion].serialize(documentToSerialize, container);
        return container.fitBytes();
    }

    @Override
    public String[] getFieldNames(ODocument reference, byte[] iSource) {
        if (iSource == null || iSource.length == 0) {
            return new String[0];
        }
        BytesContainer container = new BytesContainer(iSource).skip(1);
        try {
            return this.serializerByVersion[iSource[0]].getFieldNames(reference, container, false);
        }
        catch (RuntimeException e) {
            OLogManager.instance().warn((Object)this, "Error deserializing record to get field-names, send this data for debugging: %s ", Base64.getEncoder().encodeToString(iSource));
            throw e;
        }
    }

    @Override
    public boolean getSupportBinaryEvaluate() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public OResult getBinaryResult(ODatabaseSession db, byte[] bytes, ORecordId id) {
        ODocumentSerializer serializer = this.getSerializer(bytes[0]);
        return new OResultBinary(db, bytes, 1, bytes.length, serializer, id);
    }
}

