/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.ODecimalSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OPropertyEncryption;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentEmbedded;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryComparator;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryField;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializationDebug;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OSerializableWrapper;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class ORecordSerializerNetworkV0
implements ODocumentSerializer {
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final ORecordId NULL_RECORD_ID = new ORecordId(-2, -1L);
    private static final long MILLISEC_PER_DAY = 86400000L;

    @Override
    public void deserializePartial(ODocument document, BytesContainer bytes, String[] iFields) {
        int len;
        String className = this.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        byte[][] fields = new byte[iFields.length][];
        for (int i = 0; i < iFields.length; ++i) {
            fields[i] = iFields[i].getBytes();
        }
        String fieldName = null;
        int unmarshalledFields = 0;
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            if (len > 0) {
                boolean match = false;
                for (int i = 0; i < iFields.length; ++i) {
                    if (iFields[i].length() != len) continue;
                    boolean matchField = true;
                    for (int j = 0; j < len; ++j) {
                        if (bytes.bytes[bytes.offset + j] == fields[i][j]) continue;
                        matchField = false;
                        break;
                    }
                    if (!matchField) continue;
                    fieldName = iFields[i];
                    ++unmarshalledFields;
                    bytes.skip(len);
                    match = true;
                    break;
                }
                if (!match) {
                    bytes.skip(len + 4 + 1);
                    continue;
                }
            } else {
                throw new OStorageException("property id not supported in network serialization");
            }
            int valuePos = this.readInteger(bytes);
            OType type = this.readOType(bytes);
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, document);
                bytes.offset = headerCursor;
                document.field(fieldName, value, type);
            } else {
                document.field(fieldName, null, null);
            }
            if (unmarshalledFields != iFields.length) continue;
            break;
        }
    }

    @Override
    public void deserialize(ODocument document, BytesContainer bytes) {
        int len;
        String className = this.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        int last = 0;
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            if (len <= 0) {
                throw new OStorageException("property id not supported in network serialization");
            }
            String fieldName = this.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
            bytes.skip(len);
            int valuePos = this.readInteger(bytes);
            OType type = this.readOType(bytes);
            if (ODocumentInternal.rawContainsField(document, fieldName)) continue;
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, document);
                if (bytes.offset > last) {
                    last = bytes.offset;
                }
                bytes.offset = headerCursor;
                document.field(fieldName, value, type);
                continue;
            }
            document.field(fieldName, null, null);
        }
        ORecordInternal.clearSource(document);
        if (last > bytes.offset) {
            bytes.offset = last;
        }
    }

    @Override
    public void serialize(ODocument document, BytesContainer bytes) {
        OImmutableSchema schema = ODocumentInternal.getImmutableSchema(document);
        OPropertyEncryption encryption = ODocumentInternal.getPropertyEncryption(document);
        this.serializeClass(document, bytes);
        List<Map.Entry<String, ODocumentEntry>> fields = ODocumentInternal.filteredEntries(document);
        int[] pos = new int[fields.size()];
        int i = 0;
        Map.Entry[] values = new Map.Entry[fields.size()];
        for (Map.Entry<String, ODocumentEntry> entry : fields) {
            ODocumentEntry docEntry = entry.getValue();
            if (!docEntry.exists()) continue;
            this.writeString(bytes, entry.getKey());
            pos[i] = bytes.alloc(5);
            values[i] = entry;
            ++i;
        }
        this.writeEmptyString(bytes);
        int size = i;
        for (i = 0; i < size; ++i) {
            int pointer = 0;
            Object value = ((ODocumentEntry)values[i].getValue()).value;
            if (value == null) continue;
            OType type = this.getFieldType((ODocumentEntry)values[i].getValue());
            if (type == null) {
                throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
            }
            pointer = this.serializeValue(bytes, value, type, this.getLinkedType(document, type, (String)values[i].getKey()), schema, encryption);
            OIntegerSerializer.INSTANCE.serializeLiteral(pointer, bytes.bytes, pos[i]);
            this.writeOType(bytes, pos[i] + 4, type);
        }
    }

    @Override
    public String[] getFieldNames(ODocument reference, BytesContainer bytes, boolean embedded) {
        int classNameLen = OVarIntSerializer.readAsInteger(bytes);
        bytes.skip(classNameLen);
        ArrayList<String> result = new ArrayList<String>();
        while (true) {
            OGlobalProperty prop = null;
            int len = OVarIntSerializer.readAsInteger(bytes);
            if (len == 0) break;
            if (len > 0) {
                String fieldName = this.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
                result.add(fieldName);
                bytes.skip(len + 4 + 1);
                continue;
            }
            int id = len * -1 - 1;
            prop = ODocumentInternal.getGlobalPropertyById(reference, id);
            result.add(prop.getName());
            bytes.skip(4 + (prop.getType() != OType.ANY ? 0 : 1));
        }
        return result.toArray(new String[result.size()]);
    }

    protected OClass serializeClass(ODocument document, BytesContainer bytes) {
        OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(document);
        String name = null;
        if (clazz != null) {
            name = clazz.getName();
        }
        if (name == null) {
            name = document.getClassName();
        }
        if (name != null) {
            this.writeString(bytes, name);
        } else {
            this.writeEmptyString(bytes);
        }
        return clazz;
    }

    protected OType readOType(BytesContainer bytes) {
        return OType.getById(this.readByte(bytes));
    }

    private void writeOType(BytesContainer bytes, int pos, OType type) {
        bytes.bytes[pos] = (byte)type.getId();
    }

    @Override
    public Object deserializeValue(BytesContainer bytes, OType type, ORecordElement owner) {
        Object value = null;
        switch (type) {
            case INTEGER: {
                value = OVarIntSerializer.readAsInteger(bytes);
                break;
            }
            case LONG: {
                value = OVarIntSerializer.readAsLong(bytes);
                break;
            }
            case SHORT: {
                value = OVarIntSerializer.readAsShort(bytes);
                break;
            }
            case STRING: {
                value = this.readString(bytes);
                break;
            }
            case DOUBLE: {
                value = Double.longBitsToDouble(this.readLong(bytes));
                break;
            }
            case FLOAT: {
                value = Float.valueOf(Float.intBitsToFloat(this.readInteger(bytes)));
                break;
            }
            case BYTE: {
                value = this.readByte(bytes);
                break;
            }
            case BOOLEAN: {
                value = this.readByte(bytes) == 1;
                break;
            }
            case DATETIME: {
                value = new Date(OVarIntSerializer.readAsLong(bytes));
                break;
            }
            case DATE: {
                long savedTime = OVarIntSerializer.readAsLong(bytes) * 86400000L;
                savedTime = this.convertDayToTimezone(TimeZone.getTimeZone("GMT"), ODateHelper.getDatabaseTimeZone(), savedTime);
                value = new Date(savedTime);
                break;
            }
            case EMBEDDED: {
                value = new ODocumentEmbedded();
                this.deserialize((ODocument)value, bytes);
                if (((ODocument)value).containsField("__orientdb_serilized_class__ ")) {
                    String className = (String)((ODocument)value).field("__orientdb_serilized_class__ ");
                    try {
                        Class<?> clazz = Class.forName(className);
                        ODocumentSerializable newValue = (ODocumentSerializable)clazz.newInstance();
                        newValue.fromDocument((ODocument)value);
                        value = newValue;
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ODocumentInternal.addOwner((ODocument)value, owner);
                break;
            }
            case EMBEDDEDSET: {
                OTrackedSet<Object> set = new OTrackedSet<Object>(owner);
                value = this.readEmbeddedCollection(bytes, set, set);
                break;
            }
            case EMBEDDEDLIST: {
                OTrackedList<Object> list = new OTrackedList<Object>(owner);
                value = this.readEmbeddedCollection(bytes, list, list);
                break;
            }
            case LINKSET: {
                value = this.readLinkCollection(bytes, new ORecordLazySet(owner));
                break;
            }
            case LINKLIST: {
                value = this.readLinkCollection(bytes, new ORecordLazyList(owner));
                break;
            }
            case BINARY: {
                value = this.readBinary(bytes);
                break;
            }
            case LINK: {
                value = this.readOptimizedLink(bytes);
                break;
            }
            case LINKMAP: {
                value = this.readLinkMap(bytes, owner);
                break;
            }
            case EMBEDDEDMAP: {
                value = this.readEmbeddedMap(bytes, owner);
                break;
            }
            case DECIMAL: {
                value = ODecimalSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
                bytes.skip(ODecimalSerializer.INSTANCE.getObjectSize(bytes.bytes, bytes.offset));
                break;
            }
            case LINKBAG: {
                ORidBag bag = new ORidBag();
                bag.fromStream(bytes);
                bag.setOwner(owner);
                value = bag;
                break;
            }
            case TRANSIENT: {
                break;
            }
            case CUSTOM: {
                try {
                    String className = this.readString(bytes);
                    Class<?> clazz = Class.forName(className);
                    OSerializableStream stream = (OSerializableStream)clazz.newInstance();
                    stream.fromStream(this.readBinary(bytes));
                    if (stream instanceof OSerializableWrapper) {
                        value = ((OSerializableWrapper)stream).getSerializable();
                        break;
                    }
                    value = stream;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return value;
    }

    private byte[] readBinary(BytesContainer bytes) {
        int n = OVarIntSerializer.readAsInteger(bytes);
        byte[] newValue = new byte[n];
        System.arraycopy(bytes.bytes, bytes.offset, newValue, 0, newValue.length);
        bytes.skip(n);
        return newValue;
    }

    private Map<Object, OIdentifiable> readLinkMap(BytesContainer bytes, ORecordElement owner) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        ORecordLazyMap result = new ORecordLazyMap(owner);
        while (size-- > 0) {
            OType keyType = this.readOType(bytes);
            Object key = this.deserializeValue(bytes, keyType, result);
            ORecordId value = this.readOptimizedLink(bytes);
            if (value.equals(NULL_RECORD_ID)) {
                result.put(key, null);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private Object readEmbeddedMap(BytesContainer bytes, ORecordElement owner) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        OTrackedMap<Object> result = new OTrackedMap<Object>(owner);
        int last = 0;
        while (size-- > 0) {
            OType keyType = this.readOType(bytes);
            Object key = this.deserializeValue(bytes, keyType, result);
            int valuePos = this.readInteger(bytes);
            OType type = this.readOType(bytes);
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, result);
                if (bytes.offset > last) {
                    last = bytes.offset;
                }
                bytes.offset = headerCursor;
                result.put(key, value);
                continue;
            }
            result.put(key, (Object)null);
        }
        if (last > bytes.offset) {
            bytes.offset = last;
        }
        return result;
    }

    private Collection<OIdentifiable> readLinkCollection(BytesContainer bytes, Collection<OIdentifiable> found) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            ORecordId id = this.readOptimizedLink(bytes);
            if (id.equals(NULL_RECORD_ID)) {
                found.add(null);
                continue;
            }
            found.add(id);
        }
        return found;
    }

    private ORecordId readOptimizedLink(BytesContainer bytes) {
        return new ORecordId(OVarIntSerializer.readAsInteger(bytes), OVarIntSerializer.readAsLong(bytes));
    }

    private Collection<?> readEmbeddedCollection(BytesContainer bytes, Collection<Object> found, ORecordElement owner) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        OType type = this.readOType(bytes);
        if (type == OType.ANY) {
            for (int i = 0; i < items; ++i) {
                OType itemType = this.readOType(bytes);
                if (itemType == OType.ANY) {
                    found.add(null);
                    continue;
                }
                found.add(this.deserializeValue(bytes, itemType, owner));
            }
            return found;
        }
        return null;
    }

    private OType getLinkedType(ODocument document, OType type, String key) {
        OProperty prop;
        if (type != OType.EMBEDDEDLIST && type != OType.EMBEDDEDSET && type != OType.EMBEDDEDMAP) {
            return null;
        }
        OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass(document);
        if (immutableClass != null && (prop = immutableClass.getProperty(key)) != null) {
            return prop.getLinkedType();
        }
        return null;
    }

    @Override
    public int serializeValue(BytesContainer bytes, Object value, OType type, OType linkedType, OImmutableSchema schema, OPropertyEncryption encryption) {
        int pointer = 0;
        switch (type) {
            case INTEGER: 
            case LONG: 
            case SHORT: {
                pointer = OVarIntSerializer.write(bytes, ((Number)value).longValue());
                break;
            }
            case STRING: {
                pointer = this.writeString(bytes, value.toString());
                break;
            }
            case DOUBLE: {
                long dg = Double.doubleToLongBits((Double)value);
                pointer = bytes.alloc(8);
                OLongSerializer.INSTANCE.serializeLiteral(dg, bytes.bytes, pointer);
                break;
            }
            case FLOAT: {
                int fg = Float.floatToIntBits(((Float)value).floatValue());
                pointer = bytes.alloc(4);
                OIntegerSerializer.INSTANCE.serializeLiteral(fg, bytes.bytes, pointer);
                break;
            }
            case BYTE: {
                pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Byte)value;
                break;
            }
            case BOOLEAN: {
                pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Boolean)value != false ? (byte)1 : 0;
                break;
            }
            case DATETIME: {
                if (value instanceof Long) {
                    pointer = OVarIntSerializer.write(bytes, (long)((Long)value));
                    break;
                }
                pointer = OVarIntSerializer.write(bytes, ((Date)value).getTime());
                break;
            }
            case DATE: {
                long dateValue = value instanceof Long ? ((Long)value).longValue() : ((Date)value).getTime();
                dateValue = this.convertDayToTimezone(ODateHelper.getDatabaseTimeZone(), TimeZone.getTimeZone("GMT"), dateValue);
                pointer = OVarIntSerializer.write(bytes, dateValue / 86400000L);
                break;
            }
            case EMBEDDED: {
                pointer = bytes.offset;
                if (value instanceof ODocumentSerializable) {
                    ODocument cur = ((ODocumentSerializable)value).toDocument();
                    cur.field("__orientdb_serilized_class__ ", value.getClass().getName());
                    this.serialize(cur, bytes);
                    break;
                }
                this.serialize((ODocument)value, bytes);
                break;
            }
            case EMBEDDEDSET: 
            case EMBEDDEDLIST: {
                if (value.getClass().isArray()) {
                    pointer = this.writeEmbeddedCollection(bytes, Arrays.asList(OMultiValue.array(value)), linkedType, schema, encryption);
                    break;
                }
                pointer = this.writeEmbeddedCollection(bytes, (Collection)value, linkedType, schema, encryption);
                break;
            }
            case DECIMAL: {
                BigDecimal decimalValue = (BigDecimal)value;
                pointer = bytes.alloc(ODecimalSerializer.INSTANCE.getObjectSize(decimalValue, new Object[0]));
                ODecimalSerializer.INSTANCE.serialize(decimalValue, bytes.bytes, pointer, new Object[0]);
                break;
            }
            case BINARY: {
                pointer = this.writeBinary(bytes, (byte[])value);
                break;
            }
            case LINKSET: 
            case LINKLIST: {
                Collection ridCollection = (Collection)value;
                pointer = this.writeLinkCollection(bytes, ridCollection);
                break;
            }
            case LINK: {
                if (!(value instanceof OIdentifiable)) {
                    throw new OValidationException("Value '" + value + "' is not a OIdentifiable");
                }
                pointer = this.writeOptimizedLink(bytes, (OIdentifiable)value);
                break;
            }
            case LINKMAP: {
                pointer = this.writeLinkMap(bytes, (Map)value);
                break;
            }
            case EMBEDDEDMAP: {
                pointer = this.writeEmbeddedMap(bytes, (Map)value, schema, encryption);
                break;
            }
            case LINKBAG: {
                pointer = ((ORidBag)value).toStream(bytes);
                break;
            }
            case CUSTOM: {
                if (!(value instanceof OSerializableStream)) {
                    value = new OSerializableWrapper((Serializable)value);
                }
                pointer = this.writeString(bytes, value.getClass().getName());
                this.writeBinary(bytes, ((OSerializableStream)value).toStream());
                break;
            }
            case TRANSIENT: {
                break;
            }
        }
        return pointer;
    }

    private int writeBinary(BytesContainer bytes, byte[] valueBytes) {
        int pointer = OVarIntSerializer.write(bytes, (long)valueBytes.length);
        int start = bytes.alloc(valueBytes.length);
        System.arraycopy(valueBytes, 0, bytes.bytes, start, valueBytes.length);
        return pointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLinkMap(BytesContainer bytes, Map<Object, OIdentifiable> map) {
        boolean disabledAutoConversion;
        boolean bl = disabledAutoConversion = map instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)map)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(false);
        }
        try {
            int fullPos = OVarIntSerializer.write(bytes, (long)map.size());
            for (Map.Entry<Object, OIdentifiable> entry : map.entrySet()) {
                OType type = OType.STRING;
                this.writeOType(bytes, bytes.alloc(1), type);
                this.writeString(bytes, entry.getKey().toString());
                if (entry.getValue() == null) {
                    this.writeNullLink(bytes);
                    continue;
                }
                this.writeOptimizedLink(bytes, entry.getValue());
            }
            int n = fullPos;
            return n;
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(true);
            }
        }
    }

    private int writeEmbeddedMap(BytesContainer bytes, Map<Object, Object> map, OImmutableSchema schema, OPropertyEncryption encryption) {
        OType type;
        int[] pos = new int[map.size()];
        int i = 0;
        Map.Entry[] values = new Map.Entry[map.size()];
        int fullPos = OVarIntSerializer.write(bytes, (long)map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            type = OType.STRING;
            this.writeOType(bytes, bytes.alloc(1), type);
            this.writeString(bytes, entry.getKey().toString());
            pos[i] = bytes.alloc(5);
            values[i] = entry;
            ++i;
        }
        for (i = 0; i < values.length; ++i) {
            int pointer = 0;
            Object value = values[i].getValue();
            if (value == null) continue;
            type = this.getTypeFromValueEmbedded(value);
            if (type == null) {
                throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
            }
            pointer = this.serializeValue(bytes, value, type, null, schema, encryption);
            OIntegerSerializer.INSTANCE.serializeLiteral(pointer, bytes.bytes, pos[i]);
            this.writeOType(bytes, pos[i] + 4, type);
        }
        return fullPos;
    }

    private int writeNullLink(BytesContainer bytes) {
        int pos = OVarIntSerializer.write(bytes, (long)NULL_RECORD_ID.getIdentity().getClusterId());
        OVarIntSerializer.write(bytes, NULL_RECORD_ID.getIdentity().getClusterPosition());
        return pos;
    }

    private int writeOptimizedLink(BytesContainer bytes, OIdentifiable link) {
        Object real;
        if (!link.getIdentity().isPersistent() && (real = link.getRecord()) != null) {
            link = real;
        }
        int pos = OVarIntSerializer.write(bytes, (long)link.getIdentity().getClusterId());
        OVarIntSerializer.write(bytes, link.getIdentity().getClusterPosition());
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLinkCollection(BytesContainer bytes, Collection<OIdentifiable> value) {
        boolean disabledAutoConversion;
        int pos = OVarIntSerializer.write(bytes, (long)value.size());
        boolean bl = disabledAutoConversion = value instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)value)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)value)).setAutoConvertToRecord(false);
        }
        try {
            for (OIdentifiable itemValue : value) {
                if (itemValue == null) {
                    this.writeNullLink(bytes);
                    continue;
                }
                this.writeOptimizedLink(bytes, itemValue);
            }
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)value)).setAutoConvertToRecord(true);
            }
        }
        return pos;
    }

    private int writeEmbeddedCollection(BytesContainer bytes, Collection<?> value, OType linkedType, OImmutableSchema schema, OPropertyEncryption encryption) {
        int pos = OVarIntSerializer.write(bytes, (long)value.size());
        this.writeOType(bytes, bytes.alloc(1), OType.ANY);
        for (Object itemValue : value) {
            if (itemValue == null) {
                this.writeOType(bytes, bytes.alloc(1), OType.ANY);
                continue;
            }
            OType type = linkedType == null ? this.getTypeFromValueEmbedded(itemValue) : linkedType;
            if (type != null) {
                this.writeOType(bytes, bytes.alloc(1), type);
                this.serializeValue(bytes, itemValue, type, null, schema, encryption);
                continue;
            }
            throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
        }
        return pos;
    }

    private OType getFieldType(ODocumentEntry entry) {
        OProperty prop;
        OType type = entry.type;
        if (type == null && (prop = entry.property) != null) {
            type = prop.getType();
        }
        if (type == null || OType.ANY == type) {
            type = OType.getTypeByValue(entry.value);
        }
        return type;
    }

    private OType getTypeFromValueEmbedded(Object fieldValue) {
        OType type = OType.getTypeByValue(fieldValue);
        if (type == OType.LINK && fieldValue instanceof ODocument && !((ODocument)fieldValue).getIdentity().isValid()) {
            type = OType.EMBEDDED;
        }
        return type;
    }

    protected String readString(BytesContainer bytes) {
        int len = OVarIntSerializer.readAsInteger(bytes);
        String res = this.stringFromBytes(bytes.bytes, bytes.offset, len);
        bytes.skip(len);
        return res;
    }

    protected int readInteger(BytesContainer container) {
        int value = OIntegerSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 4;
        return value;
    }

    private byte readByte(BytesContainer container) {
        return container.bytes[container.offset++];
    }

    private long readLong(BytesContainer container) {
        long value = OLongSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 8;
        return value;
    }

    private int writeEmptyString(BytesContainer bytes) {
        return OVarIntSerializer.write(bytes, 0L);
    }

    private int writeString(BytesContainer bytes, String toWrite) {
        byte[] nameBytes = this.bytesFromString(toWrite);
        int pointer = OVarIntSerializer.write(bytes, (long)nameBytes.length);
        int start = bytes.alloc(nameBytes.length);
        System.arraycopy(nameBytes, 0, bytes.bytes, start, nameBytes.length);
        return pointer;
    }

    private byte[] bytesFromString(String toWrite) {
        try {
            return toWrite.getBytes(CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error on string encoding"), e);
        }
    }

    protected String stringFromBytes(byte[] bytes, int offset, int len) {
        try {
            return new String(bytes, offset, len, CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error on string decoding"), e);
        }
    }

    @Override
    public OBinaryField deserializeField(BytesContainer bytes, OClass iClass, String iFieldName, boolean embedded, OImmutableSchema schema, OPropertyEncryption encryption) {
        throw new UnsupportedOperationException("network serializer doesn't support comparators");
    }

    @Override
    public OBinaryComparator getComparator() {
        throw new UnsupportedOperationException("network serializer doesn't support comparators");
    }

    private long convertDayToTimezone(TimeZone from, TimeZone to, long time) {
        Calendar fromCalendar = Calendar.getInstance(from);
        fromCalendar.setTimeInMillis(time);
        Calendar toCalendar = Calendar.getInstance(to);
        toCalendar.setTimeInMillis(0L);
        toCalendar.set(0, fromCalendar.get(0));
        toCalendar.set(1, fromCalendar.get(1));
        toCalendar.set(2, fromCalendar.get(2));
        toCalendar.set(5, fromCalendar.get(5));
        toCalendar.set(11, 0);
        toCalendar.set(12, 0);
        toCalendar.set(13, 0);
        toCalendar.set(14, 0);
        return toCalendar.getTimeInMillis();
    }

    @Override
    public boolean isSerializingClassNameByDefault() {
        return true;
    }

    @Override
    public <RET> RET deserializeFieldTyped(BytesContainer record, String iFieldName, boolean isEmbedded, OImmutableSchema schema, OPropertyEncryption encryption) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deserializeDebug(BytesContainer bytes, ODatabaseDocumentInternal db, ORecordSerializationDebug debugInfo, OImmutableSchema schema) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

