/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OVarIntSerializer {
    public static void write(DataOutput output, long value) throws IOException {
        value = OVarIntSerializer.signedToUnsigned(value);
        OVarIntSerializer.writeUnsignedVarLong(value, output);
    }

    public static int write(BytesContainer bytes, long value) {
        value = OVarIntSerializer.signedToUnsigned(value);
        int pos = bytes.offset;
        OVarIntSerializer.writeUnsignedVarLong(value, bytes);
        return pos;
    }

    public static int readAsInt(DataInput input) throws IOException {
        return (int)OVarIntSerializer.readSignedVarLong(input);
    }

    public static long readAsLong(DataInput input) throws IOException {
        return OVarIntSerializer.readSignedVarLong(input);
    }

    public static short readAsShort(BytesContainer bytes) {
        return (short)OVarIntSerializer.readSignedVarLong(bytes);
    }

    public static long readAsLong(BytesContainer bytes) {
        return OVarIntSerializer.readSignedVarLong(bytes);
    }

    public static int readAsInteger(BytesContainer bytes) {
        return (int)OVarIntSerializer.readSignedVarLong(bytes);
    }

    public static byte readAsByte(BytesContainer bytes) {
        return (byte)OVarIntSerializer.readSignedVarLong(bytes);
    }

    private static long signedToUnsigned(long value) {
        return value << 1 ^ value >> 63;
    }

    public static void writeUnsignedVarLong(long value, BytesContainer bos) {
        int pos;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            pos = bos.alloc(1);
            bos.bytes[pos] = (byte)(value & 0x7FL | 0x80L);
            value >>>= 7;
        }
        pos = bos.alloc(1);
        bos.bytes[pos] = (byte)(value & 0x7FL);
    }

    public static void writeUnsignedVarLong(long value, DataOutput bos) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            bos.writeByte((byte)(value & 0x7FL | 0x80L));
            value >>>= 7;
        }
        bos.writeByte((byte)(value & 0x7FL));
    }

    public static long readSignedVarLong(BytesContainer bytes) {
        long raw = OVarIntSerializer.readUnsignedVarLong(bytes);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readSignedVarLong(DataInput bytes) throws IOException {
        long raw = OVarIntSerializer.readUnsignedVarLong(bytes);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readUnsignedVarLong(BytesContainer bytes) {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)bytes.bytes[bytes.offset++]) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IllegalArgumentException("Variable length quantity is too long (must be <= 63)");
        }
        return value | b << i;
    }

    public static long readUnsignedVarLong(DataInput bytes) throws IOException {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)bytes.readByte()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IllegalArgumentException("Variable length quantity is too long (must be <= 63)");
        }
        return value | b << i;
    }
}

