/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sharding.auto;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.OIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sharding.auto.OAutoShardingMurmurStrategy;
import com.orientechnologies.orient.core.sharding.auto.OAutoShardingStrategy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashFunction;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OHashTable;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OMurmurHash3HashFunction;
import com.orientechnologies.orient.core.storage.index.hashindex.local.OSHA256HashFunction;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.LocalHashTableV2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class OAutoShardingIndexEngine
implements OIndexEngine {
    public static final int VERSION = 1;
    private static final String SUBINDEX_METADATA_FILE_EXTENSION = ".asm";
    private static final String SUBINDEX_TREE_FILE_EXTENSION = ".ast";
    private static final String SUBINDEX_BUCKET_FILE_EXTENSION = ".asb";
    private static final String SUBINDEX_NULL_BUCKET_FILE_EXTENSION = ".asn";
    private final OAbstractPaginatedStorage storage;
    private List<OHashTable<Object, Object>> partitions;
    private OAutoShardingStrategy strategy;
    private final String name;
    private int partitionSize;
    private final AtomicLong bonsayFileId = new AtomicLong(0L);
    private final int id;

    OAutoShardingIndexEngine(String iName, int id, OAbstractPaginatedStorage iStorage, int iVersion) {
        this.name = iName;
        this.id = id;
        this.storage = iStorage;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OAutoShardingStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void create(OAtomicOperation atomicOperation, OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        this.strategy = new OAutoShardingMurmurStrategy(keySerializer);
        OHashFunction hashFunction = encryption != null ? new OSHA256HashFunction(keySerializer) : new OMurmurHash3HashFunction(keySerializer);
        String partitionsProperty = engineProperties.get("partitions");
        if (partitionsProperty != null) {
            try {
                this.partitionSize = Integer.parseInt(partitionsProperty);
            }
            catch (NumberFormatException e) {
                OLogManager.instance().error(this, "Invalid value of 'partitions' property : `" + partitionsProperty + "`", e, new Object[0]);
            }
        }
        engineProperties.put("partitions", String.valueOf(this.partitionSize));
        this.init();
        try {
            for (OHashTable<Object, Object> p : this.partitions) {
                p.create(atomicOperation, keySerializer, valueSerializer, keyTypes, encryption, hashFunction, nullPointerSupport);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during creation of index with name " + this.name), e);
        }
    }

    @Override
    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        this.strategy = new OAutoShardingMurmurStrategy(keySerializer);
        if (this.storage != null) {
            String partitionsAsString = engineProperties.get("partitions");
            if (partitionsAsString == null || partitionsAsString.isEmpty()) {
                throw new OIndexException("Cannot load autosharding index '" + indexName + "' because there is no metadata about the number of partitions");
            }
            this.partitionSize = Integer.parseInt(partitionsAsString);
            this.init();
            int i = 0;
            OHashFunction hashFunction = encryption != null ? new OSHA256HashFunction(keySerializer) : new OMurmurHash3HashFunction(keySerializer);
            for (OHashTable<Object, Object> p : this.partitions) {
                p.load(indexName + "_" + i++, keyTypes, nullPointerSupport, encryption, hashFunction, keySerializer, valueSerializer);
            }
        }
    }

    @Override
    public void flush() {
        if (this.partitions != null) {
            for (OHashTable<Object, Object> p : this.partitions) {
                p.flush();
            }
        }
    }

    @Override
    public void delete(OAtomicOperation atomicOperation) {
        try {
            if (this.partitions != null) {
                this.doClearPartitions(atomicOperation);
                for (OHashTable<Object, Object> p : this.partitions) {
                    p.delete(atomicOperation);
                }
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during deletion of index with name " + this.name), e);
        }
    }

    private void doClearPartitions(OAtomicOperation atomicOperation) throws IOException {
        for (OHashTable<Object, Object> p : this.partitions) {
            OHashTable.Entry<Object, Object> firstEntry = p.firstEntry();
            if (firstEntry != null) {
                OHashTable.Entry<Object, Object>[] entries = p.ceilingEntries(firstEntry.key);
                while (entries.length > 0) {
                    for (OHashTable.Entry<Object, Object> entry : entries) {
                        p.remove(atomicOperation, entry.key);
                    }
                    entries = p.higherEntries(entries[entries.length - 1].key);
                }
            }
            if (!p.isNullKeyIsSupported()) continue;
            p.remove(atomicOperation, null);
        }
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
    }

    private void init() {
        if (this.partitions != null) {
            return;
        }
        this.partitions = new ArrayList<OHashTable<Object, Object>>(this.partitionSize);
        for (int i = 0; i < this.partitionSize; ++i) {
            this.partitions.add(new LocalHashTableV2(this.name + "_" + i, SUBINDEX_METADATA_FILE_EXTENSION, SUBINDEX_TREE_FILE_EXTENSION, SUBINDEX_BUCKET_FILE_EXTENSION, SUBINDEX_NULL_BUCKET_FILE_EXTENSION, this.storage));
        }
    }

    @Override
    public boolean remove(OAtomicOperation atomicOperation, Object key) {
        try {
            return this.getPartition(key).remove(atomicOperation, key) != null;
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during deletion of key " + key + " of index with name " + this.name), e);
        }
    }

    @Override
    public void clear(OAtomicOperation atomicOperation) {
        try {
            if (this.partitions != null) {
                this.doClearPartitions(atomicOperation);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during clear of index with name " + this.name), e);
        }
    }

    @Override
    public void close() {
        if (this.partitions != null) {
            for (OHashTable<Object, Object> p : this.partitions) {
                p.close();
            }
        }
    }

    @Override
    public Object get(Object key) {
        return this.getPartition(key).get(key);
    }

    @Override
    public void put(OAtomicOperation atomicOperation, Object key, Object value) {
        try {
            this.getPartition(key).put(atomicOperation, key, value);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during insertion of key " + key + " of index with name " + this.name), e);
        }
    }

    @Override
    public void update(OAtomicOperation atomicOperation, Object key, OIndexKeyUpdater<Object> updater) {
        Object value = this.get(key);
        OIndexUpdateAction<Object> updated = updater.update(value, this.bonsayFileId);
        if (updated.isChange()) {
            this.put(atomicOperation, key, updated.getValue());
        } else if (updated.isRemove()) {
            this.remove(atomicOperation, key);
        } else if (updated.isNothing()) {
            // empty if block
        }
    }

    @Override
    public boolean validatedPut(OAtomicOperation atomicOperation, Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) {
        try {
            return this.getPartition(key).validatedPut(atomicOperation, key, value, validator);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during insertion of key " + key + " of index with name " + this.name), e);
        }
    }

    @Override
    public long size(OBaseIndexEngine.ValuesTransformer transformer) {
        long counter = 0L;
        if (this.partitions != null) {
            for (OHashTable<Object, Object> p : this.partitions) {
                if (transformer == null) {
                    counter += p.size();
                    continue;
                }
                OHashTable.Entry<Object, Object> firstEntry = p.firstEntry();
                if (firstEntry == null) continue;
                OHashTable.Entry<Object, Object>[] entries = p.ceilingEntries(firstEntry.key);
                while (entries.length > 0) {
                    for (OHashTable.Entry<Object, Object> entry : entries) {
                        counter += (long)transformer.transformFromValue(entry.value).size();
                    }
                    entries = p.higherEntries(entries[entries.length - 1].key);
                }
            }
        }
        return counter;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return false;
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        return this.partitions.stream().flatMap(partition -> StreamSupport.stream(new HashTableSpliterator(valuesTransformer, (OHashTable)partition), false));
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        throw new UnsupportedOperationException("descCursor");
    }

    @Override
    public Stream<Object> keyStream() {
        return StreamSupport.stream(new Spliterator<Object>(){
            private int nextPartition = 1;
            private OHashTable<Object, Object> hashTable;
            private int nextEntriesIndex;
            private OHashTable.Entry<Object, Object>[] entries;
            {
                if (OAutoShardingIndexEngine.this.partitions == null || OAutoShardingIndexEngine.this.partitions.isEmpty()) {
                    this.entries = OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY;
                } else {
                    this.hashTable = (OHashTable)OAutoShardingIndexEngine.this.partitions.get(0);
                    OHashTable.Entry<Object, Object> firstEntry = this.hashTable.firstEntry();
                    this.entries = firstEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : this.hashTable.ceilingEntries(firstEntry.key);
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super Object> action) {
                if (this.entries.length == 0) {
                    return false;
                }
                OHashTable.Entry<Object, Object> bucketEntry = this.entries[this.nextEntriesIndex];
                ++this.nextEntriesIndex;
                if (this.nextEntriesIndex >= this.entries.length) {
                    this.entries = this.hashTable.higherEntries(this.entries[this.entries.length - 1].key);
                    this.nextEntriesIndex = 0;
                    if (this.entries.length == 0 && this.nextPartition < OAutoShardingIndexEngine.this.partitions.size()) {
                        this.hashTable = (OHashTable)OAutoShardingIndexEngine.this.partitions.get(this.nextPartition++);
                        OHashTable.Entry<Object, Object> firstEntry = this.hashTable.firstEntry();
                        this.entries = firstEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : this.hashTable.ceilingEntries(firstEntry.key);
                    }
                }
                action.accept(bucketEntry.key);
                return true;
            }

            @Override
            public Spliterator<Object> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 256;
            }
        }, false);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesBetween");
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesMajor");
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesMinor");
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        this.getPartition(key).acquireAtomicExclusiveLock();
        return false;
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.getPartition(key).getName();
    }

    private OHashTable<Object, Object> getPartition(Object iKey) {
        int partitionId = Optional.ofNullable(iKey).map(key -> this.strategy.getPartitionsId(key, this.partitionSize)).orElse(0);
        return this.partitions.get(partitionId);
    }

    private static final class HashTableSpliterator
    implements Spliterator<ORawPair<Object, ORID>> {
        private int nextEntriesIndex;
        private OHashTable.Entry<Object, Object>[] entries;
        private final OBaseIndexEngine.ValuesTransformer valuesTransformer;
        private Iterator<ORID> currentIterator = new OEmptyIterator<ORID>();
        private Object currentKey;
        private final OHashTable hashTable;

        private HashTableSpliterator(OBaseIndexEngine.ValuesTransformer valuesTransformer, OHashTable hashTable) {
            this.valuesTransformer = valuesTransformer;
            this.hashTable = hashTable;
            OHashTable.Entry firstEntry = hashTable.firstEntry();
            this.entries = firstEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : hashTable.ceilingEntries(firstEntry.key);
            if (this.entries.length == 0) {
                this.currentIterator = null;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super ORawPair<Object, ORID>> action) {
            if (this.currentIterator == null) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                OIdentifiable identifiable = this.currentIterator.next();
                action.accept(new ORawPair<Object, ORID>(this.currentKey, identifiable.getIdentity()));
                return true;
            }
            while (this.currentIterator != null && !this.currentIterator.hasNext()) {
                if (this.entries.length == 0) {
                    this.currentIterator = null;
                    return false;
                }
                OHashTable.Entry<Object, Object> bucketEntry = this.entries[this.nextEntriesIndex];
                this.currentKey = bucketEntry.key;
                Object value = bucketEntry.value;
                this.currentIterator = this.valuesTransformer != null ? this.valuesTransformer.transformFromValue(value).iterator() : Collections.singletonList((ORID)value).iterator();
                ++this.nextEntriesIndex;
                if (this.nextEntriesIndex < this.entries.length) continue;
                this.entries = this.hashTable.higherEntries(this.entries[this.entries.length - 1].key);
                this.nextEntriesIndex = 0;
            }
            if (this.currentIterator != null) {
                OIdentifiable identifiable = this.currentIterator.next();
                action.accept(new ORawPair<Object, ORID>(this.currentKey, identifiable.getIdentity()));
                return true;
            }
            this.currentIterator = null;
            return false;
        }

        @Override
        public Spliterator<ORawPair<Object, ORID>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 256;
        }
    }
}

