/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OCommandExecutorSQLDeleteEdge
extends OCommandExecutorSQLSetAware
implements OCommandDistributedReplicateRequest,
OCommandResultListener {
    public static final String NAME = "DELETE EDGE";
    private static final String KEYWORD_BATCH = "BATCH";
    private List<ORecordId> rids;
    private String fromExpr;
    private String toExpr;
    private int removed = 0;
    private OCommandRequest query;
    private OSQLFilter compiledFilter;
    private String label;
    private OModifiableBoolean shutdownFlag = new OModifiableBoolean();
    private boolean txAlreadyBegun;
    private int batch = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLDeleteEdge parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            this.parserRequiredKeyword("DELETE");
            this.parserRequiredKeyword("EDGE");
            OClass clazz = null;
            String where = null;
            String temp = this.parseOptionalWord(true, new String[0]);
            String originalTemp = null;
            int limit = -1;
            if (temp != null && !this.parserIsEnded()) {
                originalTemp = this.parserText.substring(this.parserGetPreviousPosition(), this.parserGetCurrentPosition()).trim();
            }
            OModifiableBoolean shutdownFlag = new OModifiableBoolean();
            ODatabaseDocumentInternal curDb = ODatabaseRecordThreadLocal.instance().get();
            try {
                while (temp != null) {
                    if (temp.equals("FROM")) {
                        this.fromExpr = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                        if (this.rids != null) {
                            this.throwSyntaxErrorException("FROM '" + this.fromExpr + "' is not allowed when specify a RIDs (" + this.rids + ")");
                        }
                    } else if (temp.equals("TO")) {
                        this.toExpr = this.parserRequiredWord(false, "Syntax error", " =><,\r\n");
                        if (this.rids != null) {
                            this.throwSyntaxErrorException("TO '" + this.toExpr + "' is not allowed when specify a RID (" + this.rids + ")");
                        }
                    } else if (temp.startsWith("#")) {
                        this.rids = new ArrayList<ORecordId>();
                        this.rids.add(new ORecordId(temp));
                        if (this.fromExpr != null || this.toExpr != null) {
                            this.throwSyntaxErrorException("Specifying the RID " + this.rids + " is not allowed with FROM/TO");
                        }
                    } else if (temp.startsWith("[") && temp.endsWith("]")) {
                        temp = temp.substring(1, temp.length() - 1);
                        this.rids = new ArrayList<ORecordId>();
                        for (String rid : temp.split(",")) {
                            if (!(rid = rid.trim()).startsWith("#")) {
                                this.throwSyntaxErrorException("Not a valid RID: " + rid);
                            }
                            this.rids.add(new ORecordId(rid));
                        }
                    } else {
                        if (temp.equals("WHERE")) {
                            if (clazz == null) {
                                clazz = curDb.getMetadata().getSchema().getClass("E");
                            }
                            where = this.parserGetCurrentPosition() > -1 ? " " + this.parserText.substring(this.parserGetCurrentPosition()) : "";
                            this.compiledFilter = OSQLEngine.getInstance().parseCondition(where, this.getContext(), "WHERE");
                            break;
                        }
                        if (temp.equals(KEYWORD_BATCH)) {
                            temp = this.parserNextWord(true);
                            if (temp != null) {
                                this.batch = Integer.parseInt(temp);
                            }
                        } else if (temp.equals("LIMIT")) {
                            temp = this.parserNextWord(true);
                            if (temp != null) {
                                limit = Integer.parseInt(temp);
                            }
                        } else if (temp.length() > 0) {
                            this.label = originalTemp;
                            clazz = curDb.getMetadata().getSchema().getClass(temp);
                            if (clazz == null) {
                                throw new OCommandSQLParsingException("Class '" + temp + "' was not found");
                            }
                        }
                    }
                    temp = this.parseOptionalWord(true, new String[0]);
                    if (!this.parserIsEnded()) continue;
                }
                where = where == null ? (limit > -1 ? " LIMIT " + limit : "") : " WHERE " + where;
                if (this.fromExpr == null && this.toExpr == null && this.rids == null) {
                    this.query = clazz == null ? curDb.command(new OSQLAsynchQuery("select from E" + where, (OCommandResultListener)this)) : curDb.command(new OSQLAsynchQuery("select from `" + clazz.getName() + "` " + where, (OCommandResultListener)this));
                }
                String[] stringArray = this;
                ODatabaseRecordThreadLocal.instance().set(curDb);
                return stringArray;
            }
            catch (Throwable throwable) {
                ODatabaseRecordThreadLocal.instance().set(curDb);
                throw throwable;
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.fromExpr == null && this.toExpr == null && this.rids == null && this.query == null && this.compiledFilter == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal db = OCommandExecutorSQLDeleteEdge.getDatabase();
        this.txAlreadyBegun = db.getTransaction().isActive();
        if (this.rids != null) {
            db.begin();
            for (ORecordId rid : this.rids) {
                OEdge e = this.toEdge(rid);
                if (e == null) continue;
                e.delete();
                ++this.removed;
            }
            db.commit();
            return this.removed;
        }
        HashSet<OEdge> edges = new HashSet<OEdge>();
        if (this.query == null) {
            OVertex v;
            db.begin();
            Set<OIdentifiable> fromIds = null;
            if (this.fromExpr != null) {
                fromIds = OSQLEngine.getInstance().parseRIDTarget(db, this.fromExpr, this.context, iArgs);
            }
            Set<OIdentifiable> toIds = null;
            if (this.toExpr != null) {
                toIds = OSQLEngine.getInstance().parseRIDTarget(db, this.toExpr, this.context, iArgs);
            }
            if (this.label == null) {
                this.label = "E";
            }
            if (fromIds != null && toIds != null) {
                OVertex v2;
                int fromCount = 0;
                int toCount = 0;
                for (OIdentifiable fromId : fromIds) {
                    v2 = this.toVertex(fromId);
                    if (v2 == null) continue;
                    fromCount += this.count(v2.getEdges(ODirection.OUT, this.label));
                }
                for (OIdentifiable toId : toIds) {
                    v2 = this.toVertex(toId);
                    if (v2 == null) continue;
                    toCount += this.count(v2.getEdges(ODirection.IN, this.label));
                }
                if (fromCount <= toCount) {
                    for (OIdentifiable fromId : fromIds) {
                        v2 = this.toVertex(fromId);
                        if (v2 == null) continue;
                        for (OEdge e : v2.getEdges(ODirection.OUT, this.label)) {
                            OVertex inV = e.getTo();
                            if (inV == null || !toIds.contains(inV.getIdentity())) continue;
                            edges.add(e);
                        }
                    }
                } else {
                    for (OIdentifiable toId : toIds) {
                        v2 = this.toVertex(toId);
                        if (v2 == null) continue;
                        for (OEdge e : v2.getEdges(ODirection.IN, this.label)) {
                            OVertex outV = e.getFrom();
                            if (outV == null || !fromIds.contains(outV.getIdentity())) continue;
                            edges.add(e);
                        }
                    }
                }
            } else if (fromIds != null) {
                for (OIdentifiable fromId : fromIds) {
                    v = this.toVertex(fromId);
                    if (v == null) continue;
                    for (OEdge e : v.getEdges(ODirection.OUT, this.label)) {
                        edges.add(e);
                    }
                }
            } else if (toIds != null) {
                for (OIdentifiable toId : toIds) {
                    v = this.toVertex(toId);
                    if (v == null) continue;
                    for (OEdge e : v.getEdges(ODirection.IN, this.label)) {
                        edges.add(e);
                    }
                }
            } else {
                throw new OCommandExecutionException("Invalid target: " + toIds);
            }
            if (this.compiledFilter != null) {
                Iterator it = edges.iterator();
                while (it.hasNext()) {
                    OEdge edge = (OEdge)it.next();
                    if (((Boolean)this.compiledFilter.evaluate((OIdentifiable)edge.getRecord(), null, this.context)).booleanValue()) continue;
                    it.remove();
                }
            }
            this.removed = edges.size();
            for (OEdge edge : edges) {
                edge.delete();
            }
            db.commit();
            return this.removed;
        }
        db.begin();
        this.query.setContext(this.getContext());
        this.query.execute(iArgs);
        db.commit();
        return this.removed;
    }

    private int count(Iterable<OEdge> edges) {
        int result = 0;
        for (OEdge x : edges) {
            ++result;
        }
        return result;
    }

    @Override
    public boolean result(Object iRecord) {
        OEdge e;
        OIdentifiable id = (OIdentifiable)iRecord;
        if (this.compiledFilter != null && !((Boolean)this.compiledFilter.evaluate((OIdentifiable)id.getRecord(), null, this.context)).booleanValue()) {
            return true;
        }
        if (id.getIdentity().isValid() && (e = this.toEdge(id)) != null) {
            e.delete();
            if (!this.txAlreadyBegun && this.batch > 0 && (this.removed + 1) % this.batch == 0) {
                OCommandExecutorSQLDeleteEdge.getDatabase().commit();
                OCommandExecutorSQLDeleteEdge.getDatabase().begin();
            }
            ++this.removed;
        }
        return true;
    }

    private OEdge toEdge(OIdentifiable item) {
        if (item != null && item instanceof OElement) {
            OIdentifiable a = item;
            return ((OElement)item).asEdge().orElseThrow(() -> new OCommandExecutionException("" + a.getIdentity() + " is not an edge"));
        }
        item = (OIdentifiable)OCommandExecutorSQLDeleteEdge.getDatabase().load(item.getIdentity());
        if (item != null && item instanceof OElement) {
            OIdentifiable a = item;
            return ((OElement)item).asEdge().orElseThrow(() -> new OCommandExecutionException("" + a.getIdentity() + " is not an edge"));
        }
        return null;
    }

    private OVertex toVertex(OIdentifiable item) {
        if (item != null && item instanceof OElement) {
            return ((OElement)item).asVertex().orElse(null);
        }
        item = (OIdentifiable)OCommandExecutorSQLDeleteEdge.getDatabase().load(item.getIdentity());
        if (item != null && item instanceof OElement) {
            return ((OElement)item).asVertex().orElse(null);
        }
        return null;
    }

    @Override
    public String getSyntax() {
        return "DELETE EDGE <rid>|FROM <rid>|TO <rid>|<[<class>] [WHERE <conditions>]> [BATCH <batch-size>]";
    }

    @Override
    public void end() {
    }

    @Override
    public int getSecurityOperationType() {
        return ORole.PERMISSION_DELETE;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT getDistributedResultManagement() {
        if (this.getDistributedExecutionMode() == OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL) {
            return OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.CHECK_FOR_EQUALS;
        }
        return OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.MERGE;
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        if (this.query != null && !OCommandExecutorSQLDeleteEdge.getDatabase().getTransaction().isActive()) {
            return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.REPLICATE;
        }
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    @Override
    public Set<String> getInvolvedClusters() {
        HashSet<String> result = new HashSet<String>();
        if (this.rids != null) {
            ODatabaseDocumentInternal database = OCommandExecutorSQLDeleteEdge.getDatabase();
            for (ORecordId rid : this.rids) {
                result.add(database.getClusterNameById(rid.getClusterId()));
            }
        } else if (this.query != null) {
            OCommandExecutor executor = OCommandExecutorSQLDeleteEdge.getDatabase().getSharedContext().getOrientDB().getScriptManager().getCommandManager().getExecutor((OCommandRequestInternal)this.query);
            executor.setContext(this.context);
            executor.parse(this.query);
            return executor.getInvolvedClusters();
        }
        return result;
    }

    @Override
    public <RET extends OCommandExecutor> RET setLimit(int iLimit) {
        return (RET)this;
    }
}

