/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.collection.OSortedMultiIterator;
import com.orientechnologies.common.concur.resource.OSharedResource;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.stream.BreakingForEach;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.common.util.OPatternConst;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexEngineException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClusters;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OChainedIndexProxy;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetDelegate;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OFilterAnalyzer;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.OMetricRecorder;
import com.orientechnologies.orient.core.sql.OOrderByOptimizer;
import com.orientechnologies.orient.core.sql.ORuntimeResult;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.OTemporaryRidGenerator;
import com.orientechnologies.orient.core.sql.filter.OFilterOptimizer;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionCount;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorAnd;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinorEquals;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OOrderBy;
import com.orientechnologies.orient.core.sql.parser.OOrderByItem;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.query.OLegacyResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLQuery;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public class OCommandExecutorSQLSelect
extends OCommandExecutorSQLResultsetAbstract
implements OTemporaryRidGenerator {
    public static final String KEYWORD_SELECT = "SELECT";
    public static final String KEYWORD_ASC = "ASC";
    public static final String KEYWORD_DESC = "DESC";
    public static final String KEYWORD_ORDER = "ORDER";
    public static final String KEYWORD_BY = "BY";
    public static final String KEYWORD_GROUP = "GROUP";
    public static final String KEYWORD_UNWIND = "UNWIND";
    public static final String KEYWORD_FETCHPLAN = "FETCHPLAN";
    public static final String KEYWORD_NOCACHE = "NOCACHE";
    private static final String KEYWORD_AS = "AS";
    private static final String KEYWORD_PARALLEL = "PARALLEL";
    private static final int PARTIAL_SORT_BUFFER_THRESHOLD = 10000;
    private static final String NULL_VALUE = "null";
    private static final AsyncResult PARALLEL_END_EXECUTION_THREAD = new AsyncResult(null, null);
    private final OOrderByOptimizer orderByOptimizer = new OOrderByOptimizer();
    private final OMetricRecorder metricRecorder = new OMetricRecorder();
    private final OFilterOptimizer filterOptimizer = new OFilterOptimizer();
    private final OFilterAnalyzer filterAnalyzer = new OFilterAnalyzer();
    private Map<String, String> projectionDefinition = null;
    private Map<String, Object> projections = null;
    private List<OPair<String, String>> orderedFields = new ArrayList<OPair<String, String>>();
    private List<String> groupByFields;
    private ConcurrentHashMap<Object, ORuntimeResult> groupedResult = new ConcurrentHashMap();
    private boolean aggregate = false;
    private List<String> unwindFields;
    private Object expandTarget;
    private int fetchLimit = -1;
    private OIdentifiable lastRecord;
    private String fetchPlan;
    private boolean fullySortedByIndex = false;
    private OStorage.LOCKING_STRATEGY lockingStrategy = OStorage.LOCKING_STRATEGY.DEFAULT;
    private Boolean isAnyFunctionAggregates = null;
    private volatile boolean parallel = false;
    private volatile boolean parallelRunning;
    private final ArrayBlockingQueue<AsyncResult> resultQueue;
    private ConcurrentHashMap<ORID, ORID> uniqueResult;
    private boolean noCache = false;
    private int tipLimitThreshold;
    private AtomicLong tmpQueueOffer = new AtomicLong();
    private Object resultLock = new Object();

    public OCommandExecutorSQLSelect() {
        OContextConfiguration conf = OCommandExecutorSQLSelect.getDatabase().getConfiguration();
        this.resultQueue = new ArrayBlockingQueue(conf.getValueAsInteger(OGlobalConfiguration.QUERY_PARALLEL_RESULT_QUEUE_SIZE));
        this.tipLimitThreshold = conf.getValueAsInteger(OGlobalConfiguration.QUERY_LIMIT_THRESHOLD_TIP);
    }

    private static Object getIndexKey(OIndexDefinition indexDefinition, Object value, OCommandContext context) {
        if (indexDefinition instanceof OCompositeIndexDefinition || indexDefinition.getParamCount() > 1) {
            if (value instanceof List) {
                List values = (List)value;
                ArrayList<Object> keyParams = new ArrayList<Object>(values.size());
                for (Object o : values) {
                    keyParams.add(OSQLHelper.getValue(o, null, context));
                }
                return indexDefinition.createValue(keyParams);
            }
            if ((value = OSQLHelper.getValue(value)) instanceof OCompositeKey) {
                return value;
            }
            return indexDefinition.createValue(value);
        }
        if (indexDefinition instanceof OIndexDefinitionMultiValue) {
            return ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(OSQLHelper.getValue(value));
        }
        return indexDefinition.createValue(OSQLHelper.getValue(value, null, context));
    }

    public boolean hasGroupBy() {
        return this.groupByFields != null && this.groupByFields.size() > 0;
    }

    @Override
    protected boolean isUseCache() {
        return !this.noCache && this.request.isUseCache();
    }

    private static ODocument createIndexEntryAsDocument(Object iKey, OIdentifiable iValue) {
        ODocument doc = new ODocument().setOrdered(true);
        doc.field("key", iKey);
        doc.field("rid", iValue);
        ORecordInternal.unsetDirty(doc);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCommandExecutorSQLSelect parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            super.parse(iRequest);
            this.initContext();
            int pos = this.parseProjections();
            if (pos == -1) {
                OCommandExecutorSQLSelect oCommandExecutorSQLSelect = this;
                return oCommandExecutorSQLSelect;
            }
            int endPosition = this.parserText.length();
            this.parserNextWord(true);
            if (this.parserGetLastWord().equalsIgnoreCase("FROM")) {
                this.parsedTarget = OSQLEngine.getInstance().parseTarget(this.parserText.substring(this.parserGetCurrentPosition(), endPosition), this.getContext());
                this.parserSetCurrentPosition(this.parsedTarget.parserIsEnded() ? endPosition : this.parsedTarget.parserGetCurrentPosition() + this.parserGetCurrentPosition());
            } else {
                this.parserGoBack();
            }
            if (!this.parserIsEnded()) {
                this.parserSkipWhiteSpaces();
                while (!this.parserIsEnded()) {
                    String w = this.parserNextWord(true);
                    if (w.isEmpty()) continue;
                    if (w.equals("WHERE")) {
                        this.compiledFilter = OSQLEngine.getInstance().parseCondition(this.parserText.substring(this.parserGetCurrentPosition(), endPosition), this.getContext(), "WHERE");
                        this.optimize();
                        if (this.compiledFilter.parserIsEnded()) {
                            this.parserSetCurrentPosition(endPosition);
                            continue;
                        }
                        this.parserSetCurrentPosition(this.compiledFilter.parserGetCurrentPosition() + this.parserGetCurrentPosition());
                        continue;
                    }
                    if (w.equals("LET")) {
                        this.parseLet();
                        continue;
                    }
                    if (w.equals(KEYWORD_GROUP)) {
                        this.parseGroupBy();
                        continue;
                    }
                    if (w.equals(KEYWORD_ORDER)) {
                        this.parseOrderBy();
                        continue;
                    }
                    if (w.equals(KEYWORD_UNWIND)) {
                        this.parseUnwind();
                        continue;
                    }
                    if (w.equals("LIMIT")) {
                        this.parseLimit(w);
                        continue;
                    }
                    if (w.equals("SKIP") || w.equals("OFFSET")) {
                        this.parseSkip(w);
                        continue;
                    }
                    if (w.equals(KEYWORD_FETCHPLAN)) {
                        this.parseFetchplan(w);
                        continue;
                    }
                    if (w.equals(KEYWORD_NOCACHE)) {
                        this.parseNoCache(w);
                        continue;
                    }
                    if (w.equals("TIMEOUT")) {
                        this.parseTimeout(w);
                        continue;
                    }
                    if (w.equals("LOCK")) {
                        String lock = this.parseLock();
                        if (lock.equalsIgnoreCase("DEFAULT")) {
                            this.lockingStrategy = OStorage.LOCKING_STRATEGY.DEFAULT;
                            continue;
                        }
                        if (lock.equals("NONE")) {
                            this.lockingStrategy = OStorage.LOCKING_STRATEGY.NONE;
                            continue;
                        }
                        if (lock.equals("RECORD")) {
                            this.lockingStrategy = OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK;
                            continue;
                        }
                        if (!lock.equals("SHARED")) continue;
                        this.lockingStrategy = OStorage.LOCKING_STRATEGY.SHARED_LOCK;
                        continue;
                    }
                    if (w.equals(KEYWORD_PARALLEL)) {
                        this.parallel = this.parseParallel(w);
                        continue;
                    }
                    if (this.preParsedStatement != null) continue;
                    this.throwParsingException("Invalid keyword '" + w + "'");
                }
            }
            if (this.limit == 0 || this.limit < -1) {
                throw new IllegalArgumentException("Limit must be > 0 or = -1 (no limit)");
            }
            this.validateQuery();
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    private void validateQuery() {
        if (this.let != null) {
            for (Object letValue : this.let.values()) {
                OSQLFunctionRuntime f;
                if (!(letValue instanceof OSQLFunctionRuntime) || !(f = (OSQLFunctionRuntime)letValue).getFunction().aggregateResults() || this.groupByFields == null || this.groupByFields.size() <= 0) continue;
                this.throwParsingException("Aggregate function cannot be used in LET clause together with GROUP BY");
            }
        }
    }

    @Override
    public Set<String> getInvolvedClusters() {
        HashSet<String> clusters = new HashSet<String>();
        if (this.parsedTarget != null) {
            ODatabaseDocumentInternal db = OCommandExecutorSQLSelect.getDatabase();
            if (this.parsedTarget.getTargetQuery() != null && this.parsedTarget.getTargetRecords() instanceof OCommandExecutorSQLResultsetDelegate) {
                Set<String> clIds = ((OCommandExecutorSQLResultsetDelegate)this.parsedTarget.getTargetRecords()).getInvolvedClusters();
                for (String c : clIds) {
                    if (!this.checkClusterAccess(db, c)) continue;
                    clusters.add(c);
                }
            } else if (this.parsedTarget.getTargetRecords() != null) {
                for (OIdentifiable oIdentifiable : this.parsedTarget.getTargetRecords()) {
                    String c = db.getClusterNameById(oIdentifiable.getIdentity().getClusterId()).toLowerCase(Locale.ENGLISH);
                    if (!this.checkClusterAccess(db, c)) continue;
                    clusters.add(c);
                }
            }
            if (this.parsedTarget.getTargetClasses() != null) {
                return this.getInvolvedClustersOfClasses(this.parsedTarget.getTargetClasses().values());
            }
            if (this.parsedTarget.getTargetClusters() != null) {
                return this.getInvolvedClustersOfClusters(this.parsedTarget.getTargetClusters().keySet());
            }
            if (this.parsedTarget.getTargetIndex() != null) {
                return this.getInvolvedClustersOfIndex(this.parsedTarget.getTargetIndex());
            }
        }
        return clusters;
    }

    public boolean isAnyFunctionAggregates() {
        if (this.isAnyFunctionAggregates == null) {
            if (this.projections != null) {
                for (Map.Entry<String, Object> p : this.projections.entrySet()) {
                    if (!(p.getValue() instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)p.getValue()).aggregateResults()) continue;
                    this.isAnyFunctionAggregates = true;
                    break;
                }
            }
            if (this.isAnyFunctionAggregates == null) {
                this.isAnyFunctionAggregates = false;
            }
        }
        return this.isAnyFunctionAggregates;
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this.iterator(null);
    }

    @Override
    public Iterator<OIdentifiable> iterator(Map<Object, Object> iArgs) {
        Iterator subIterator;
        if (this.target == null) {
            this.executeSearch(iArgs);
            this.applyExpand();
            this.handleNoTarget();
            this.handleGroupBy(this.context);
            this.applyOrderBy(true);
            subIterator = new ArrayList((List)this.getResult()).iterator();
            this.lastRecord = null;
            this.tempResult = null;
            this.groupedResult.clear();
            this.aggregate = false;
        } else {
            subIterator = this.target;
        }
        return subIterator;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        this.bindDefaultContextVariables();
        if (iArgs != null) {
            for (Map.Entry<Object, Object> arg : iArgs.entrySet()) {
                this.context.setVariable(arg.getKey().toString(), arg.getValue());
            }
        }
        if (this.timeoutMs > 0L) {
            this.getContext().beginExecution(this.timeoutMs, this.timeoutStrategy);
        }
        if (!this.optimizeExecution()) {
            this.fetchLimit = this.getQueryFetchLimit();
            this.executeSearch(iArgs);
            this.applyExpand();
            this.handleNoTarget();
            this.handleGroupBy(this.context);
            this.applyOrderBy(true);
            this.applyLimitAndSkip();
        }
        return this.getResult();
    }

    public Map<String, Object> getProjections() {
        return this.projections;
    }

    @Override
    public String getSyntax() {
        return "SELECT [<Projections>] FROM <Target> [LET <Assignment>*] [WHERE <Condition>*] [ORDER BY <Fields>* [ASC|DESC]*] [LIMIT <MaxRecords>] [TIMEOUT <TimeoutInMs>] [LOCK none|record] [NOCACHE]";
    }

    @Override
    public String getFetchPlan() {
        return this.fetchPlan != null ? this.fetchPlan : this.request.getFetchPlan();
    }

    protected void executeSearch(Map<Object, Object> iArgs) {
        this.assignTarget(iArgs);
        if (this.target == null) {
            if (this.let != null) {
                this.assignLetClauses(this.lastRecord != null ? (ORecord)this.lastRecord.getRecord() : null);
            }
            return;
        }
        this.fetchFromTarget(this.target);
    }

    @Override
    protected boolean assignTarget(Map<Object, Object> iArgs) {
        if (!super.assignTarget(iArgs)) {
            if (this.parsedTarget.getTargetIndex() != null) {
                this.searchInIndex();
            } else {
                throw new OQueryParsingException("No source found in query: specify class, cluster(s), index or single record(s). Use " + this.getSyntax());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeSearchRecord(OIdentifiable id, OCommandContext iContext, boolean callHooks) {
        block30: {
            ORecord record;
            OStorage.LOCKING_STRATEGY localLockingStrategy;
            if (id == null) {
                return false;
            }
            ORID identity = id.getIdentity();
            if (this.uniqueResult != null) {
                if (this.uniqueResult.containsKey(identity)) {
                    return true;
                }
                if (identity.isValid()) {
                    this.uniqueResult.put(identity, identity);
                }
            }
            if (!this.checkInterruption()) {
                return false;
            }
            OStorage.LOCKING_STRATEGY contextLockingStrategy = iContext.getVariable("$locking") != null ? (OStorage.LOCKING_STRATEGY)((Object)iContext.getVariable("$locking")) : null;
            OStorage.LOCKING_STRATEGY lOCKING_STRATEGY = localLockingStrategy = contextLockingStrategy != null ? contextLockingStrategy : this.lockingStrategy;
            if (localLockingStrategy != null && localLockingStrategy != OStorage.LOCKING_STRATEGY.DEFAULT && localLockingStrategy != OStorage.LOCKING_STRATEGY.NONE && localLockingStrategy != OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK && localLockingStrategy != OStorage.LOCKING_STRATEGY.SHARED_LOCK) {
                throw new IllegalStateException("Unsupported locking strategy " + (Object)((Object)localLockingStrategy));
            }
            if (localLockingStrategy == OStorage.LOCKING_STRATEGY.SHARED_LOCK) {
                id.lock(false);
                if (id instanceof ORecord) {
                    record = (ORecord)id;
                    record.reload(null, true, false);
                }
            } else if (localLockingStrategy == OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK) {
                id.lock(true);
                if (id instanceof ORecord) {
                    record = (ORecord)id;
                    record.reload(null, true, false);
                }
            }
            record = null;
            try {
                if (!(id instanceof ORecord)) {
                    record = (ORecord)OCommandExecutorSQLSelect.getDatabase().load(id.getIdentity(), (String)null, !this.isUseCache());
                    if (id instanceof OContextualRecordId && ((OContextualRecordId)id).getContext() != null) {
                        Map<String, Object> ridContext = ((OContextualRecordId)id).getContext();
                        for (String key : ridContext.keySet()) {
                            this.context.setVariable(key, ridContext.get(key));
                        }
                    }
                } else {
                    record = (ORecord)id;
                }
                iContext.updateMetric("recordReads", 1L);
                if (record == null) {
                    boolean ridContext = true;
                    return ridContext;
                }
                if (ORecordInternal.getRecordType(record) != 100 && this.checkSkipBlob()) {
                    boolean ridContext = true;
                    return ridContext;
                }
                iContext.updateMetric("documentReads", 1L);
                iContext.setVariable("current", record);
                if (!this.filter(record, iContext)) break block30;
                if (callHooks) {
                    OCommandExecutorSQLSelect.getDatabase().beforeReadOperations(record);
                    OCommandExecutorSQLSelect.getDatabase().afterReadOperations(record);
                }
                if (this.parallel) {
                    try {
                        this.applyGroupBy(record, iContext);
                        this.resultQueue.put(new AsyncResult(record, iContext));
                    }
                    catch (InterruptedException ignore) {
                        Thread.currentThread().interrupt();
                        boolean bl = false;
                        if (localLockingStrategy != null && record != null && record.isLocked() && (localLockingStrategy == OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK || localLockingStrategy == OStorage.LOCKING_STRATEGY.SHARED_LOCK)) {
                            record.unlock();
                        }
                        return bl;
                    }
                    this.tmpQueueOffer.incrementAndGet();
                    break block30;
                }
                this.applyGroupBy(record, iContext);
                if (!this.handleResult(record, iContext)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                if (localLockingStrategy != null && record != null && record.isLocked() && (localLockingStrategy == OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK || localLockingStrategy == OStorage.LOCKING_STRATEGY.SHARED_LOCK)) {
                    record.unlock();
                }
            }
        }
        return true;
    }

    private boolean checkSkipBlob() {
        if (this.expandTarget != null) {
            return true;
        }
        if (this.projections != null) {
            if (this.projections.size() > 1) {
                return true;
            }
            if (this.projections.containsKey("@rid")) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected boolean handleResult(OIdentifiable iRecord, OCommandContext iContext) {
        this.lastRecord = iRecord;
        if ((this.orderedFields.isEmpty() || this.fullySortedByIndex || this.isRidOnlySort()) && this.skip > 0 && this.unwindFields == null && this.expandTarget == null) {
            this.lastRecord = null;
            --this.skip;
            return true;
        }
        if (!this.addResult(this.lastRecord, iContext)) {
            return false;
        }
        return this.continueSearching();
    }

    private boolean continueSearching() {
        return !this.orderedFields.isEmpty() && !this.fullySortedByIndex && !this.isRidOnlySort() || this.isAnyFunctionAggregates() || this.groupByFields != null && !this.groupByFields.isEmpty() || this.fetchLimit <= -1 || this.resultCount < this.fetchLimit || this.expandTarget != null;
    }

    @Override
    public int getTemporaryRIDCounter(OCommandContext iContext) {
        OTemporaryRidGenerator parentQuery = (OTemporaryRidGenerator)iContext.getVariable("parentQuery");
        if (parentQuery != null && parentQuery != this) {
            return parentQuery.getTemporaryRIDCounter(iContext);
        }
        return this.serialTempRID.getAndIncrement();
    }

    protected boolean addResult(OIdentifiable iRecord, OCommandContext iContext) {
        boolean result;
        block13: {
            ArrayList<OIdentifiable> allResults;
            block12: {
                ++this.resultCount;
                if (iRecord == null) {
                    return true;
                }
                if (this.projections != null || this.groupByFields != null && !this.groupByFields.isEmpty()) {
                    if (!this.aggregate) {
                        iRecord = ORuntimeResult.getProjectionResult(this.getTemporaryRIDCounter(iContext), this.projections, iContext, iRecord);
                        if (iRecord == null) {
                            --this.resultCount;
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                if (this.tipLimitThreshold > 0 && this.resultCount > this.tipLimitThreshold && this.getLimit() == -1) {
                    this.reportTip(String.format("Query '%s' returned a result set with more than %d records. Check if you really need all these records, or reduce the resultset by using a LIMIT to improve both performance and used RAM", this.parserText, this.tipLimitThreshold));
                    this.tipLimitThreshold = 0;
                }
                allResults = new ArrayList<OIdentifiable>();
                if (this.unwindFields != null) {
                    Collection<OIdentifiable> partial = this.unwind(iRecord, this.unwindFields, iContext);
                    for (OIdentifiable item : partial) {
                        allResults.add(item);
                    }
                } else {
                    allResults.add(iRecord);
                }
                result = true;
                if (!this.allowsStreamedResult()) break block12;
                if (this.request.getResultListener() == null) break block13;
                for (OIdentifiable iRes : allResults) {
                    result = this.pushResult(iRes);
                }
                break block13;
            }
            if (this.tempResult == null) {
                this.tempResult = new ArrayList();
            }
            this.applyPartialOrderBy();
            for (OIdentifiable iRes : allResults) {
                ((Collection)this.tempResult).add(iRes);
            }
        }
        return result;
    }

    private ODocument applyGroupBy(OIdentifiable iRecord, OCommandContext iContext) {
        if (!this.aggregate) {
            return null;
        }
        Object fieldValue = null;
        if (this.groupByFields != null && !this.groupByFields.isEmpty()) {
            if (this.groupByFields.size() > 1) {
                ODocument doc = (ODocument)iRecord.getRecord();
                Object[] fields = new Object[this.groupByFields.size()];
                for (int i = 0; i < this.groupByFields.size(); ++i) {
                    String field = this.groupByFields.get(i);
                    fields[i] = field.startsWith("$") ? iContext.getVariable(field) : doc.field(field);
                }
                fieldValue = fields;
            } else {
                String field = this.groupByFields.get(0);
                if (field != null) {
                    fieldValue = field.startsWith("$") ? iContext.getVariable(field) : ((ODocument)iRecord.getRecord()).field(field);
                }
            }
        }
        return this.getProjectionGroup(fieldValue, iContext).applyRecord(iRecord);
    }

    private boolean allowsStreamedResult() {
        return (this.fullySortedByIndex || this.orderedFields.isEmpty()) && this.expandTarget == null && this.unwindFields == null;
    }

    private void applyPartialOrderBy() {
        if (this.expandTarget != null || this.unwindFields != null && this.unwindFields.size() > 0 || this.orderedFields.isEmpty() || this.fullySortedByIndex || this.isRidOnlySort()) {
            return;
        }
        if (this.limit > 0) {
            int sortBufferSize = this.limit + 1;
            if (this.skip > 0) {
                sortBufferSize += this.skip;
            }
            if (this.tempResult instanceof List && ((List)this.tempResult).size() >= sortBufferSize + 10000) {
                this.applyOrderBy(false);
                this.tempResult = new ArrayList(((List)this.tempResult).subList(0, sortBufferSize));
            }
        }
    }

    private Collection<OIdentifiable> unwind(OIdentifiable iRecord, List<String> unwindFields, OCommandContext iContext) {
        ArrayList<OIdentifiable> result = new ArrayList<OIdentifiable>();
        ODocument doc = iRecord instanceof ODocument ? (ODocument)iRecord : (ODocument)iRecord.getRecord();
        if (unwindFields.size() == 0) {
            ORecordInternal.setIdentity(doc, new ORecordId(-2, this.getTemporaryRIDCounter(iContext)));
            result.add(doc);
        } else {
            String firstField = unwindFields.get(0);
            List<String> nextFields = unwindFields.subList(1, unwindFields.size());
            Object fieldValue = doc.field(firstField);
            if (fieldValue == null || !(fieldValue instanceof Iterable) || fieldValue instanceof ODocument) {
                result.addAll(this.unwind(doc, nextFields, iContext));
            } else {
                Iterator iterator = ((Iterable)fieldValue).iterator();
                if (!iterator.hasNext()) {
                    ODocument unwindedDoc = new ODocument();
                    doc.copyTo(unwindedDoc);
                    unwindedDoc.field(firstField, (Object)null);
                    result.addAll(this.unwind(unwindedDoc, nextFields, iContext));
                } else {
                    do {
                        Object o = iterator.next();
                        ODocument unwindedDoc = new ODocument();
                        doc.copyTo(unwindedDoc);
                        unwindedDoc.field(firstField, o);
                        result.addAll(this.unwind(unwindedDoc, nextFields, iContext));
                    } while (iterator.hasNext());
                }
            }
        }
        return result;
    }

    protected void reportTip(String iMessage) {
        Orient.instance().getProfiler().reportTip(iMessage);
        ArrayList<String> tips = (ArrayList<String>)this.context.getVariable("tips");
        if (tips == null) {
            tips = new ArrayList<String>(3);
            this.context.setVariable("tips", tips);
        }
        tips.add(iMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ORuntimeResult getProjectionGroup(Object fieldValue, OCommandContext iContext) {
        long projectionElapsed = (Long)this.context.getVariable("projectionElapsed", 0L);
        long begin = System.currentTimeMillis();
        try {
            ORuntimeResult prev;
            Object key;
            this.aggregate = true;
            if (fieldValue != null) {
                if (fieldValue.getClass().isArray()) {
                    Object[] array = (Object[])fieldValue;
                    StringBuilder keyArray = new StringBuilder();
                    for (Object o : array) {
                        if (keyArray.length() > 0) {
                            keyArray.append(",");
                        }
                        if (o != null) {
                            keyArray.append(o instanceof OIdentifiable ? ((OIdentifiable)o).getIdentity().toString() : o.toString());
                            continue;
                        }
                        keyArray.append(NULL_VALUE);
                    }
                    key = keyArray.toString();
                } else {
                    key = fieldValue;
                }
            } else {
                key = NULL_VALUE;
            }
            ORuntimeResult group = (ORuntimeResult)this.groupedResult.get(key);
            if (group == null && (prev = this.groupedResult.putIfAbsent(key, group = new ORuntimeResult(fieldValue, this.createProjectionFromDefinition(), this.getTemporaryRIDCounter(iContext), this.context))) != null) {
                group = prev;
            }
            ORuntimeResult oRuntimeResult = group;
            return oRuntimeResult;
        }
        finally {
            this.context.setVariable("projectionElapsed", projectionElapsed + (System.currentTimeMillis() - begin));
        }
    }

    protected void parseGroupBy() {
        this.parserRequiredKeyword(KEYWORD_BY);
        this.groupByFields = new ArrayList<String>();
        while (!(this.parserIsEnded() || this.groupByFields.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.groupByFields.add(fieldName);
            this.parserSkipWhiteSpaces();
        }
        if (this.groupByFields.size() == 0) {
            this.throwParsingException("Group by field set was missed. Example: GROUP BY name, salary");
        }
        this.aggregate = true;
        this.groupedResult.clear();
    }

    protected void parseUnwind() {
        this.unwindFields = new ArrayList<String>();
        while (!(this.parserIsEnded() || this.unwindFields.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.unwindFields.add(fieldName);
            this.parserSkipWhiteSpaces();
        }
        if (this.unwindFields.size() == 0) {
            this.throwParsingException("unwind field set was missed. Example: UNWIND name, salary");
        }
    }

    protected void parseOrderBy() {
        this.parserRequiredKeyword(KEYWORD_BY);
        String fieldOrdering = null;
        this.orderedFields = new ArrayList<OPair<String, String>>();
        while (!(this.parserIsEnded() || this.orderedFields.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserOptionalWord(true);
            String word = this.parserGetLastWord();
            if (word.length() == 0) {
                fieldOrdering = KEYWORD_ASC;
            } else if (word.equals("LIMIT") || word.equals("SKIP") || word.equals("OFFSET")) {
                fieldOrdering = KEYWORD_ASC;
                this.parserGoBack();
            } else if (word.equals(KEYWORD_ASC)) {
                fieldOrdering = KEYWORD_ASC;
            } else if (word.equals(KEYWORD_DESC)) {
                fieldOrdering = KEYWORD_DESC;
            } else {
                this.throwParsingException("Ordering mode '" + word + "' not supported. Valid is 'ASC', 'DESC' or nothing ('ASC' by default)");
            }
            this.orderedFields.add(new OPair<String, String>(fieldName, fieldOrdering));
            this.parserSkipWhiteSpaces();
        }
        if (this.orderedFields.size() == 0) {
            this.throwParsingException("Order by field set was missed. Example: ORDER BY name ASC, salary DESC");
        }
    }

    @Override
    protected void searchInClasses() {
        String className = this.parsedTarget.getTargetClasses().keySet().iterator().next();
        OClass cls = OCommandExecutorSQLSelect.getDatabase().getMetadata().getImmutableSchemaSnapshot().getClass(className);
        if (!this.searchForIndexes(cls) && !this.searchForSubclassIndexes(cls)) {
            boolean browsingOrderAsc = this.isBrowsingAscendingOrder();
            super.searchInClasses(browsingOrderAsc);
        }
    }

    private boolean isBrowsingAscendingOrder() {
        return this.orderedFields.size() != 1 || !((String)this.orderedFields.get(0).getKey()).equalsIgnoreCase("@rid") || !this.orderedFields.get(0).getValue().equalsIgnoreCase(KEYWORD_DESC);
    }

    protected int parseProjections() {
        if (!this.parserOptionalKeyword(KEYWORD_SELECT)) {
            return -1;
        }
        int upperBound = OStringSerializerHelper.getLowerIndexOfKeywords(this.parserTextUpperCase, this.parserGetCurrentPosition(), "FROM", "LET");
        if (upperBound == -1) {
            upperBound = this.parserText.length();
        }
        int lastRealPositionProjection = -1;
        int currPos = this.parserGetCurrentPosition();
        if (currPos == -1) {
            return -1;
        }
        String projectionString = this.parserText.substring(currPos, upperBound);
        if (projectionString.trim().length() > 0) {
            this.projections = new LinkedHashMap<String, Object>();
            this.projectionDefinition = new LinkedHashMap<String, String>();
            List<String> items = OStringSerializerHelper.smartSplit(projectionString, ',', new char[0]);
            for (String projectionItem : items) {
                String fieldName;
                String projection = OStringSerializerHelper.smartTrim(projectionItem.trim(), true, true);
                if (this.projectionDefinition == null) {
                    throw new OCommandSQLParsingException("Projection not allowed with FLATTEN() and EXPAND() operators");
                }
                List<String> words = OStringSerializerHelper.smartSplit(projection, ' ', new char[0]);
                if (words.size() > 1 && words.get(1).trim().equalsIgnoreCase(KEYWORD_AS)) {
                    if (words.size() < 3) {
                        throw new OCommandSQLParsingException("Found 'AS' without alias");
                    }
                    fieldName = words.get(2).trim();
                    if (this.projectionDefinition.containsKey(fieldName)) {
                        throw new OCommandSQLParsingException("Field '" + fieldName + "' is duplicated in current SELECT, choose a different name");
                    }
                    projection = words.get(0).trim();
                    lastRealPositionProjection = words.size() > 3 ? projectionString.indexOf(words.get(3)) : (lastRealPositionProjection += projectionItem.length() + 1);
                } else {
                    int endPos;
                    fieldName = projection = words.get(0);
                    lastRealPositionProjection = projectionString.indexOf(fieldName) + fieldName.length() + 1;
                    if (fieldName.charAt(0) == '@') {
                        fieldName = fieldName.substring(1);
                    }
                    if ((endPos = this.extractProjectionNameSubstringEndPosition(fieldName)) > -1) {
                        fieldName = fieldName.substring(0, endPos);
                    }
                    int fieldIndex = 2;
                    while (this.projectionDefinition.containsKey(fieldName)) {
                        fieldName = fieldName + fieldIndex;
                        ++fieldIndex;
                    }
                }
                String p = this.upperCase(projection);
                if (p.startsWith("FLATTEN(") || p.startsWith("EXPAND(")) {
                    List<String> pars;
                    if (p.startsWith("FLATTEN(")) {
                        OLogManager.instance().debug((Object)this, "FLATTEN() operator has been replaced by EXPAND()", new Object[0]);
                    }
                    if ((pars = OStringSerializerHelper.getParameters(projection)).size() != 1) {
                        throw new OCommandSQLParsingException("EXPAND/FLATTEN operators expects the field name as parameter. Example EXPAND( out )");
                    }
                    this.expandTarget = OSQLHelper.parseValue(this, pars.get(0).trim(), this.context);
                    this.projectionDefinition = null;
                    this.projections = null;
                    if (this.aggregate || !(this.expandTarget instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)this.expandTarget).aggregateResults()) continue;
                    this.aggregate = true;
                    continue;
                }
                fieldName = OIOUtils.getStringContent(fieldName);
                this.projectionDefinition.put(fieldName, projection);
            }
            if (!(this.projectionDefinition == null || this.projectionDefinition.size() <= 1 && this.projectionDefinition.values().iterator().next().equals("*"))) {
                this.projections = this.createProjectionFromDefinition();
                for (Object p : this.projections.values()) {
                    if (this.aggregate || !(p instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)p).aggregateResults()) continue;
                    this.getProjectionGroup(null, this.context);
                    break;
                }
            } else {
                this.projectionDefinition = null;
                this.projections = null;
            }
        }
        if (upperBound < this.parserText.length() - 1) {
            this.parserSetCurrentPosition(upperBound);
        } else if (lastRealPositionProjection > -1) {
            this.parserMoveCurrentPosition(lastRealPositionProjection);
        } else {
            this.parserSetEndOfText();
        }
        return this.parserGetCurrentPosition();
    }

    protected Map<String, Object> createProjectionFromDefinition() {
        if (this.projectionDefinition == null) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> projections = new LinkedHashMap<String, Object>(this.projectionDefinition.size());
        for (Map.Entry<String, String> p : this.projectionDefinition.entrySet()) {
            Object projectionValue = OSQLHelper.parseValue(this, p.getValue(), this.context);
            projections.put(p.getKey(), projectionValue);
        }
        return projections;
    }

    protected int extractProjectionNameSubstringEndPosition(String projection) {
        int endPos;
        int pos1 = projection.indexOf(46);
        int pos2 = projection.indexOf(40);
        int pos3 = projection.indexOf(91);
        if (pos1 > -1 && pos2 == -1 && pos3 == -1) {
            endPos = pos1;
        } else if (pos2 > -1 && pos1 == -1 && pos3 == -1) {
            endPos = pos2;
        } else if (pos3 > -1 && pos1 == -1 && pos2 == -1) {
            endPos = pos3;
        } else if (pos1 > -1 && pos2 > -1 && pos3 == -1) {
            endPos = Math.min(pos1, pos2);
        } else if (pos2 > -1 && pos3 > -1 && pos1 == -1) {
            endPos = Math.min(pos2, pos3);
        } else if (pos1 > -1 && pos3 > -1 && pos2 == -1) {
            endPos = Math.min(pos1, pos3);
        } else if (pos1 > -1 && pos2 > -1 && pos3 > -1) {
            endPos = Math.min(pos1, pos2);
            endPos = Math.min(endPos, pos3);
        } else {
            endPos = -1;
        }
        return endPos;
    }

    protected boolean parseFetchplan(String w) throws OCommandSQLParsingException {
        String word;
        if (!w.equals(KEYWORD_FETCHPLAN)) {
            return false;
        }
        this.parserSkipWhiteSpaces();
        int start = this.parserGetCurrentPosition();
        this.parserNextWord(true);
        int end = this.parserGetCurrentPosition();
        this.parserSkipWhiteSpaces();
        int position = this.parserGetCurrentPosition();
        while (!this.parserIsEnded() && OPatternConst.PATTERN_FETCH_PLAN.matcher(word = OIOUtils.getStringContent(this.parserNextWord(true))).matches()) {
            end = this.parserGetCurrentPosition();
            this.parserSkipWhiteSpaces();
            position = this.parserGetCurrentPosition();
        }
        this.parserSetCurrentPosition(position);
        this.fetchPlan = end < 0 ? OIOUtils.getStringContent(this.parserText.substring(start)) : OIOUtils.getStringContent(this.parserText.substring(start, end));
        this.request.setFetchPlan(this.fetchPlan);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean optimizeExecution() {
        block17: {
            if (this.compiledFilter != null) {
                this.mergeRangeConditionsToBetweenOperators(this.compiledFilter);
            }
            if ((this.compiledFilter == null || this.compiledFilter.getRootCondition() == null) && this.groupByFields == null && this.projections != null && this.projections.size() == 1) {
                long startOptimization = System.currentTimeMillis();
                try {
                    boolean restrictedClasses;
                    Map.Entry<String, Object> entry = this.projections.entrySet().iterator().next();
                    if (!(entry.getValue() instanceof OSQLFunctionRuntime)) break block17;
                    OSQLFunctionRuntime rf = (OSQLFunctionRuntime)entry.getValue();
                    if (!(rf.function instanceof OSQLFunctionCount) || rf.configuredParameters.length != 1 || !"*".equals(rf.configuredParameters[0]) || (restrictedClasses = this.isUsingRestrictedClasses())) break block17;
                    long count = 0L;
                    ODatabaseDocumentInternal database = OCommandExecutorSQLSelect.getDatabase();
                    if (this.parsedTarget.getTargetClasses() != null) {
                        String className = this.parsedTarget.getTargetClasses().keySet().iterator().next();
                        OClass cls = database.getMetadata().getImmutableSchemaSnapshot().getClass(className);
                        count = cls.count();
                    } else if (this.parsedTarget.getTargetClusters() != null) {
                        for (String cluster : this.parsedTarget.getTargetClusters().keySet()) {
                            count += database.countClusterElements(cluster);
                        }
                    } else if (this.parsedTarget.getTargetIndex() != null) {
                        count += database.getMetadata().getIndexManagerInternal().getIndex(database, this.parsedTarget.getTargetIndex()).getInternal().size();
                    } else {
                        Iterable<? extends OIdentifiable> recs = this.parsedTarget.getTargetRecords();
                        if (recs != null) {
                            if (recs instanceof Collection) {
                                count += (long)((Collection)recs).size();
                            } else {
                                for (OIdentifiable oIdentifiable : recs) {
                                    ++count;
                                }
                            }
                        }
                    }
                    if (this.tempResult == null) {
                        this.tempResult = new ArrayList();
                    }
                    ((Collection)this.tempResult).add(new ODocument().field(entry.getKey(), count));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.context.setVariable("optimizationElapsed", System.currentTimeMillis() - startOptimization);
                }
            }
        }
        return false;
    }

    private boolean isUsingRestrictedClasses() {
        boolean restrictedClasses = false;
        OSecurityUser user = OCommandExecutorSQLSelect.getDatabase().getUser();
        if (this.parsedTarget.getTargetClasses() != null && user != null && user.checkIfAllowed(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, ORole.PERMISSION_READ) == null) {
            for (String className : this.parsedTarget.getTargetClasses().keySet()) {
                OClass cls = OCommandExecutorSQLSelect.getDatabase().getMetadata().getImmutableSchemaSnapshot().getClass(className);
                if (!cls.isSubClassOf("ORestricted")) continue;
                restrictedClasses = true;
                break;
            }
        }
        return restrictedClasses;
    }

    protected void revertSubclassesProfiler(OCommandContext iContext, int num) {
        OProfiler profiler = Orient.instance().getProfiler();
        if (profiler.isRecording()) {
            profiler.updateCounter(profiler.getDatabaseMetric(OCommandExecutorSQLSelect.getDatabase().getName(), "query.indexUseAttemptedAndReverted"), "Reverted index usage in query", num);
        }
    }

    protected void revertProfiler(OCommandContext iContext, OIndex index, List<Object> keyParams, OIndexDefinition indexDefinition) {
        OProfiler profiler;
        if (iContext.isRecordingMetrics()) {
            iContext.updateMetric("compositeIndexUsed", -1L);
        }
        if ((profiler = Orient.instance().getProfiler()).isRecording()) {
            profiler.updateCounter(profiler.getDatabaseMetric(index.getDatabaseName(), "query.indexUsed"), "Used index in query", -1L);
            int params = indexDefinition.getParamCount();
            if (params > 1) {
                String profiler_prefix = profiler.getDatabaseMetric(index.getDatabaseName(), "query.compositeIndexUsed");
                profiler.updateCounter(profiler_prefix, "Used composite index in query", -1L);
                profiler.updateCounter(profiler_prefix + "." + params, "Used composite index in query with " + params + " params", -1L);
                profiler.updateCounter(profiler_prefix + "." + params + '.' + keyParams.size(), "Used composite index in query with " + params + " params and " + keyParams.size() + " keys", -1L);
            }
        }
    }

    protected boolean parseNoCache(String w) throws OCommandSQLParsingException {
        if (!w.equals(KEYWORD_NOCACHE)) {
            return false;
        }
        this.noCache = true;
        return true;
    }

    private void mergeRangeConditionsToBetweenOperators(OSQLFilter filter) {
        OSQLFilterCondition condition = filter.getRootCondition();
        OSQLFilterCondition newCondition = this.convertToBetweenClause(condition);
        if (newCondition != null) {
            filter.setRootCondition(newCondition);
            this.metricRecorder.recordRangeQueryConvertedInBetween();
            return;
        }
        this.mergeRangeConditionsToBetweenOperators(condition);
    }

    private void mergeRangeConditionsToBetweenOperators(OSQLFilterCondition condition) {
        OSQLFilterCondition newCondition;
        if (condition == null) {
            return;
        }
        if (condition.getLeft() instanceof OSQLFilterCondition) {
            OSQLFilterCondition leftCondition = (OSQLFilterCondition)condition.getLeft();
            newCondition = this.convertToBetweenClause(leftCondition);
            if (newCondition != null) {
                condition.setLeft(newCondition);
                this.metricRecorder.recordRangeQueryConvertedInBetween();
            } else {
                this.mergeRangeConditionsToBetweenOperators(leftCondition);
            }
        }
        if (condition.getRight() instanceof OSQLFilterCondition) {
            OSQLFilterCondition rightCondition = (OSQLFilterCondition)condition.getRight();
            newCondition = this.convertToBetweenClause(rightCondition);
            if (newCondition != null) {
                condition.setRight(newCondition);
                this.metricRecorder.recordRangeQueryConvertedInBetween();
            } else {
                this.mergeRangeConditionsToBetweenOperators(rightCondition);
            }
        }
    }

    private OSQLFilterCondition convertToBetweenClause(OSQLFilterCondition condition) {
        String leftField;
        OSQLFilterItemField itemField;
        String rightField;
        OSQLFilterItemField itemField2;
        if (condition == null) {
            return null;
        }
        Object right = condition.getRight();
        Object left = condition.getLeft();
        OQueryOperator operator = condition.getOperator();
        if (!(operator instanceof OQueryOperatorAnd)) {
            return null;
        }
        if (!(right instanceof OSQLFilterCondition)) {
            return null;
        }
        if (!(left instanceof OSQLFilterCondition)) {
            return null;
        }
        OSQLFilterCondition rightCondition = (OSQLFilterCondition)right;
        OSQLFilterCondition leftCondition = (OSQLFilterCondition)left;
        if (rightCondition.getLeft() instanceof OSQLFilterItemField && rightCondition.getRight() instanceof OSQLFilterItemField) {
            return null;
        }
        if (!(rightCondition.getLeft() instanceof OSQLFilterItemField) && !(rightCondition.getRight() instanceof OSQLFilterItemField)) {
            return null;
        }
        if (leftCondition.getLeft() instanceof OSQLFilterItemField && leftCondition.getRight() instanceof OSQLFilterItemField) {
            return null;
        }
        if (!(leftCondition.getLeft() instanceof OSQLFilterItemField) && !(leftCondition.getRight() instanceof OSQLFilterItemField)) {
            return null;
        }
        ArrayList<Object> betweenBoundaries = new ArrayList<Object>();
        if (rightCondition.getLeft() instanceof OSQLFilterItemField) {
            itemField2 = (OSQLFilterItemField)rightCondition.getLeft();
            if (!itemField2.isFieldChain()) {
                return null;
            }
            if (itemField2.getFieldChain().getItemCount() > 1) {
                return null;
            }
            rightField = itemField2.getRoot();
            betweenBoundaries.add(rightCondition.getRight());
        } else if (rightCondition.getRight() instanceof OSQLFilterItemField) {
            itemField2 = (OSQLFilterItemField)rightCondition.getRight();
            if (!itemField2.isFieldChain()) {
                return null;
            }
            if (itemField2.getFieldChain().getItemCount() > 1) {
                return null;
            }
            rightField = itemField2.getRoot();
            betweenBoundaries.add(rightCondition.getLeft());
        } else {
            return null;
        }
        betweenBoundaries.add("and");
        if (leftCondition.getLeft() instanceof OSQLFilterItemField) {
            itemField = (OSQLFilterItemField)leftCondition.getLeft();
            if (!itemField.isFieldChain()) {
                return null;
            }
            if (itemField.getFieldChain().getItemCount() > 1) {
                return null;
            }
            leftField = itemField.getRoot();
            betweenBoundaries.add(leftCondition.getRight());
        } else if (leftCondition.getRight() instanceof OSQLFilterItemField) {
            itemField = (OSQLFilterItemField)leftCondition.getRight();
            if (!itemField.isFieldChain()) {
                return null;
            }
            if (itemField.getFieldChain().getItemCount() > 1) {
                return null;
            }
            leftField = itemField.getRoot();
            betweenBoundaries.add(leftCondition.getLeft());
        } else {
            return null;
        }
        if (!leftField.equalsIgnoreCase(rightField)) {
            return null;
        }
        OQueryOperator rightOperator = ((OSQLFilterCondition)right).getOperator();
        OQueryOperator leftOperator = ((OSQLFilterCondition)left).getOperator();
        if ((rightOperator instanceof OQueryOperatorMajor || rightOperator instanceof OQueryOperatorMajorEquals) && (leftOperator instanceof OQueryOperatorMinor || leftOperator instanceof OQueryOperatorMinorEquals)) {
            OQueryOperatorBetween between = new OQueryOperatorBetween();
            if (rightOperator instanceof OQueryOperatorMajor) {
                between.setLeftInclusive(false);
            }
            if (leftOperator instanceof OQueryOperatorMinor) {
                between.setRightInclusive(false);
            }
            return new OSQLFilterCondition(new OSQLFilterItemField(this, leftField, null), between, betweenBoundaries.toArray());
        }
        if ((leftOperator instanceof OQueryOperatorMajor || leftOperator instanceof OQueryOperatorMajorEquals) && (rightOperator instanceof OQueryOperatorMinor || rightOperator instanceof OQueryOperatorMinorEquals)) {
            OQueryOperatorBetween between = new OQueryOperatorBetween();
            if (leftOperator instanceof OQueryOperatorMajor) {
                between.setLeftInclusive(false);
            }
            if (rightOperator instanceof OQueryOperatorMinor) {
                between.setRightInclusive(false);
            }
            Collections.reverse(betweenBoundaries);
            return new OSQLFilterCondition(new OSQLFilterItemField(this, leftField, null), between, betweenBoundaries.toArray());
        }
        return null;
    }

    public void initContext() {
        if (this.context == null) {
            this.context = new OBasicCommandContext();
        }
        if (this.context.getDatabase() == null) {
            ((OBasicCommandContext)this.context).setDatabase(OCommandExecutorSQLSelect.getDatabase());
        }
        this.metricRecorder.setContext(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchFromTarget(Iterator<? extends OIdentifiable> iTarget) {
        this.fetchLimit = this.getQueryFetchLimit();
        long startFetching = System.currentTimeMillis();
        int[] clusterIds = iTarget instanceof ORecordIteratorClusters ? ((ORecordIteratorClusters)iTarget).getClusterIds() : null;
        this.parallel = (this.parallel || OCommandExecutorSQLSelect.getDatabase().getConfiguration().getValueAsBoolean(OGlobalConfiguration.QUERY_PARALLEL_AUTO)) && this.canRunParallel(clusterIds, iTarget);
        try {
            if (this.parallel) {
                boolean bl = this.parallelExec(iTarget);
                return bl;
            }
            boolean prefetchPages = false;
            if (this.canScanStorageCluster(clusterIds)) {
                prefetchPages = true;
            }
            ODatabaseDocumentInternal database = OCommandExecutorSQLSelect.getDatabase();
            database.setPrefetchRecords(prefetchPages);
            try {
                boolean bl = this.serialIterator(iTarget);
                database.setPrefetchRecords(false);
                return bl;
            }
            catch (Throwable throwable) {
                database.setPrefetchRecords(false);
                throw throwable;
            }
        }
        finally {
            this.context.setVariable("fetchingFromTargetElapsed", System.currentTimeMillis() - startFetching);
        }
    }

    private boolean canRunParallel(int[] clusterIds, Iterator<? extends OIdentifiable> iTarget) {
        long totalRecords;
        if (OCommandExecutorSQLSelect.getDatabase().getTransaction().isActive()) {
            return false;
        }
        if (iTarget instanceof ORecordIteratorClusters && clusterIds.length > 1 && (totalRecords = OCommandExecutorSQLSelect.getDatabase().getStorage().count(clusterIds)) > OCommandExecutorSQLSelect.getDatabase().getConfiguration().getValueAsLong(OGlobalConfiguration.QUERY_PARALLEL_MINIMUM_RECORDS)) {
            OLogManager.instance().debug((Object)this, "Activated parallel query. clusterIds=%d, totalRecords=%d", clusterIds.length, totalRecords);
            return true;
        }
        return false;
    }

    private boolean canScanStorageCluster(int[] clusterIds) {
        ODatabaseDocumentInternal db = OCommandExecutorSQLSelect.getDatabase();
        if (clusterIds != null && this.request.isIdempotent() && !db.getTransaction().isActive()) {
            OImmutableSchema schema = db.getMetadata().getImmutableSchemaSnapshot();
            for (int clusterId : clusterIds) {
                OImmutableClass cls = (OImmutableClass)schema.getClassByClusterId(clusterId);
                if (cls == null || !cls.isRestricted() && !cls.isOuser() && !cls.isOrole()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean serialIterator(Iterator<? extends OIdentifiable> iTarget) {
        int queryScanThresholdWarning = OCommandExecutorSQLSelect.getDatabase().getConfiguration().getValueAsInteger(OGlobalConfiguration.QUERY_SCAN_THRESHOLD_TIP);
        boolean tipActivated = queryScanThresholdWarning > 0 && iTarget instanceof OIdentifiableIterator && this.compiledFilter != null;
        int browsed = 0;
        while (iTarget.hasNext()) {
            OIdentifiable next = iTarget.next();
            if (!this.executeSearchRecord(next, this.context, false)) {
                return false;
            }
            ++browsed;
        }
        return true;
    }

    private boolean parseParallel(String w) {
        return w.equals(KEYWORD_PARALLEL);
    }

    private boolean parallelExec(Iterator<? extends OIdentifiable> iTarget) {
        OLegacyResultSet result = (OLegacyResultSet)this.getResultInstance();
        ODatabaseDocumentInternal db = OCommandExecutorSQLSelect.getDatabase();
        if (this.limit > -1 && result != null) {
            result.setLimit(this.limit);
        }
        boolean res = this.execParallelWithPool((ORecordIteratorClusters)iTarget, db);
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Parallel query '%s' completed", this.parserText);
        }
        return res;
    }

    private boolean execParallelWithPool(ORecordIteratorClusters iTarget, ODatabaseDocumentInternal db) {
        int i;
        int[] clusterIds = iTarget.getClusterIds();
        int jobNumbers = clusterIds.length;
        ArrayList jobs = new ArrayList();
        OLogManager.instance().debug((Object)this, "Executing parallel query with strategy executors. clusterIds=%d, jobs=%d", clusterIds.length, jobNumbers);
        boolean[] results = new boolean[jobNumbers];
        OCommandContext[] contexts = new OCommandContext[jobNumbers];
        RuntimeException[] exceptions = new RuntimeException[jobNumbers];
        this.parallelRunning = true;
        AtomicInteger runningJobs = new AtomicInteger(jobNumbers);
        int i2 = 0;
        while (i2 < jobNumbers) {
            int current = i2++;
            Runnable job = () -> {
                try {
                    ODatabase localDatabase = null;
                    try {
                        OCommandContext threadContext;
                        exceptions[current] = null;
                        results[current] = true;
                        contexts[current] = threadContext = this.context.copy();
                        localDatabase = db.copy();
                        localDatabase.activateOnCurrentThread();
                        db.getMetadata().getSchema().makeSnapshot();
                        this.scanClusterWithIterator((ODatabaseDocumentInternal)localDatabase, threadContext, clusterIds[current], current, results);
                    }
                    catch (RuntimeException t) {
                        exceptions[current] = t;
                    }
                    finally {
                        runningJobs.decrementAndGet();
                        this.resultQueue.offer(PARALLEL_END_EXECUTION_THREAD);
                        if (localDatabase != null) {
                            localDatabase.close();
                        }
                    }
                }
                catch (Exception e) {
                    if (exceptions[current] == null) {
                        exceptions[current] = new RuntimeException(e);
                    }
                    OLogManager.instance().error(this, "Error during command execution", e, new Object[0]);
                }
                ODatabaseRecordThreadLocal.instance().remove();
            };
            jobs.add(Orient.instance().submit(job));
        }
        int maxQueueSize = OCommandExecutorSQLSelect.getDatabase().getConfiguration().getValueAsInteger(OGlobalConfiguration.QUERY_PARALLEL_RESULT_QUEUE_SIZE) - 1;
        boolean cancelQuery = false;
        boolean tipProvided = false;
        while (runningJobs.get() > 0 || !this.resultQueue.isEmpty()) {
            try {
                AsyncResult result = this.resultQueue.take();
                int qSize = this.resultQueue.size();
                if (!tipProvided && qSize >= maxQueueSize) {
                    OLogManager.instance().debug((Object)this, "Parallel query '%s' has result queue full (size=%d), this could reduce concurrency level. Consider increasing queue size with setting: %s=<size>", this.parserText, maxQueueSize + 1, OGlobalConfiguration.QUERY_PARALLEL_RESULT_QUEUE_SIZE.getKey());
                    tipProvided = true;
                }
                if (OExecutionThreadLocal.isInterruptCurrentOperation()) {
                    throw new InterruptedException("Operation has been interrupted");
                }
                if (result == PARALLEL_END_EXECUTION_THREAD || this.handleResult(result.record, result.context)) continue;
                this.parallelRunning = false;
                break;
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                cancelQuery = true;
                break;
            }
        }
        this.parallelRunning = false;
        if (cancelQuery) {
            for (i = 0; i < jobs.size(); ++i) {
                ((Future)jobs.get(i)).cancel(true);
            }
        } else {
            for (i = 0; i < jobs.size(); ++i) {
                try {
                    ((Future)jobs.get(i)).get();
                    this.context.merge(contexts[i]);
                    continue;
                }
                catch (InterruptedException ignore) {
                    break;
                }
                catch (ExecutionException e) {
                    OLogManager.instance().error(this, "Error on executing parallel query", e, new Object[0]);
                    throw OException.wrapException(new OCommandExecutionException("Error on executing parallel query"), e);
                }
            }
        }
        for (i = 0; i < jobNumbers; ++i) {
            if (exceptions[i] == null) continue;
            throw exceptions[i];
        }
        for (i = 0; i < jobNumbers; ++i) {
            if (results[i]) continue;
            return false;
        }
        return true;
    }

    private void scanClusterWithIterator(ODatabaseDocumentInternal localDatabase, OCommandContext iContext, int iClusterId, int current, boolean[] results) {
        ORecordIteratorCluster it = new ORecordIteratorCluster(localDatabase, iClusterId);
        while (it.hasNext()) {
            Object next = it.next();
            if (!this.executeSearchRecord((OIdentifiable)next, iContext, false)) {
                results[current] = false;
                break;
            }
            if (!this.parallel || this.parallelRunning) continue;
            break;
        }
    }

    private int getQueryFetchLimit() {
        int sqlLimit = this.limit > -1 ? this.limit : -1;
        int requestLimit = this.request.getLimit() > -1 ? this.request.getLimit() : -1;
        if (sqlLimit == -1) {
            return requestLimit;
        }
        if (requestLimit == -1) {
            return sqlLimit;
        }
        return Math.min(sqlLimit, requestLimit);
    }

    private Stream<ORawPair<Object, ORID>> tryGetOptimizedSortStream(OClass iSchemaClass) {
        if (this.orderedFields.size() == 0) {
            return null;
        }
        return this.getOptimizedSortStream(iSchemaClass);
    }

    private boolean tryOptimizeSort(OClass iSchemaClass) {
        if (this.orderedFields.size() == 0) {
            return false;
        }
        return this.optimizeSort(iSchemaClass);
    }

    private boolean searchForSubclassIndexes(OClass iSchemaClass) {
        Iterator<? extends OIdentifiable> parentClassIterator;
        Collection<OClass> subclasses = iSchemaClass.getSubclasses();
        if (subclasses.size() == 0) {
            return false;
        }
        OOrderBy order = new OOrderBy();
        order.setItems(new ArrayList<OOrderByItem>());
        if (this.orderedFields != null) {
            for (OPair<String, String> pair2 : this.orderedFields) {
                OOrderByItem item = new OOrderByItem();
                item.setRecordAttr((String)pair2.getKey());
                if (pair2.getValue() == null) {
                    item.setType(KEYWORD_ASC);
                } else {
                    item.setType(pair2.getValue().toUpperCase(Locale.ENGLISH).equals(KEYWORD_DESC) ? KEYWORD_DESC : KEYWORD_ASC);
                }
                order.getItems().add(item);
            }
        }
        OSortedMultiIterator<OIdentifiable> cursor = new OSortedMultiIterator<OIdentifiable>(order);
        boolean fullySorted = true;
        if (!iSchemaClass.isAbstract() && (parentClassIterator = this.searchInClasses(iSchemaClass, false, true)).hasNext()) {
            cursor.add(parentClassIterator);
            fullySorted = false;
        }
        if (this.uniqueResult != null) {
            this.uniqueResult.clear();
        }
        int attempted = 0;
        for (OClass subclass : subclasses) {
            List<Stream<ORawPair<Object, ORID>>> substreams = this.getIndexCursors(subclass);
            boolean bl = fullySorted = fullySorted && this.fullySortedByIndex;
            if (substreams == null || substreams.size() == 0) {
                if (attempted > 0) {
                    this.revertSubclassesProfiler(this.context, attempted);
                }
                return false;
            }
            for (Stream<ORawPair<Object, ORID>> c : substreams) {
                if (!this.fullySortedByIndex) {
                    // empty if block
                }
                ++attempted;
                cursor.add(c.map(pair -> (OIdentifiable)pair.second).iterator());
            }
        }
        this.fullySortedByIndex = fullySorted;
        this.uniqueResult = new ConcurrentHashMap();
        this.fetchFromTarget(cursor);
        if (this.uniqueResult != null) {
            this.uniqueResult.clear();
        }
        this.uniqueResult = null;
        return true;
    }

    private List<Stream<ORawPair<Object, ORID>>> getIndexCursors(OClass iSchemaClass) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLSelect.getDatabase();
        if (this.compiledFilter == null) {
            Stream<ORawPair<Object, ORID>> stream = this.tryGetOptimizedSortStream(iSchemaClass);
            if (stream == null) {
                return null;
            }
            ArrayList<Stream<ORawPair<Object, ORID>>> result = new ArrayList<Stream<ORawPair<Object, ORID>>>();
            result.add(stream);
            return result;
        }
        List<List<OIndexSearchResult>> conditionHierarchy = this.filterAnalyzer.analyzeMainCondition(this.compiledFilter.getRootCondition(), iSchemaClass, this.context);
        if (conditionHierarchy == null) {
            return null;
        }
        ArrayList<Stream<ORawPair<Object, ORID>>> cursors = new ArrayList<Stream<ORawPair<Object, ORID>>>();
        boolean indexIsUsedInOrderBy = false;
        ArrayList<IndexUsageLog> indexUseAttempts = new ArrayList<IndexUsageLog>();
        OIndexSearchResult lastSearchResult = null;
        for (List<OIndexSearchResult> indexSearchResults : conditionHierarchy) {
            boolean indexUsed = false;
            Iterator<OIndexSearchResult> iterator = indexSearchResults.iterator();
            while (iterator.hasNext()) {
                OIndexSearchResult searchResult;
                lastSearchResult = searchResult = iterator.next();
                List<OIndex> involvedIndexes = this.filterAnalyzer.getInvolvedIndexes(iSchemaClass, searchResult);
                Collections.sort(involvedIndexes, new IndexComparator());
                for (OIndex index : involvedIndexes) {
                    Stream<ORawPair<Object, ORID>> cursor;
                    String relatedIndexField;
                    String lastFiled;
                    OQueryOperator operator;
                    OIndexDefinition indexDefinition = index.getDefinition();
                    if (searchResult.containsNullValues && indexDefinition.isNullValuesIgnored() || !OIndexSearchResult.isIndexEqualityOperator(operator = searchResult.lastOperator) && !(lastFiled = searchResult.lastField.getItemName(searchResult.lastField.getItemCount() - 1)).equals(relatedIndexField = indexDefinition.getFields().get(searchResult.fieldValuePairs.size()))) continue;
                    int searchResultFieldsCount = searchResult.fields().size();
                    ArrayList<Object> keyParams = new ArrayList<Object>(searchResultFieldsCount);
                    for (String fieldName : indexDefinition.getFields().subList(0, searchResultFieldsCount)) {
                        Object fieldValue = searchResult.fieldValuePairs.get(fieldName);
                        if (fieldValue instanceof OSQLQuery) {
                            return null;
                        }
                        if (fieldValue != null) {
                            keyParams.add(fieldValue);
                            continue;
                        }
                        if (searchResult.lastValue instanceof OSQLQuery) {
                            return null;
                        }
                        keyParams.add(searchResult.lastValue);
                    }
                    this.metricRecorder.recordInvolvedIndexesMetric(index);
                    indexIsUsedInOrderBy = this.orderByOptimizer.canBeUsedByOrderBy(index, this.orderedFields) && !(index.getInternal() instanceof OChainedIndexProxy);
                    try {
                        boolean ascSortOrder;
                        boolean bl = ascSortOrder = !indexIsUsedInOrderBy || this.orderedFields.get(0).getValue().equals(KEYWORD_ASC);
                        if (indexIsUsedInOrderBy) {
                            this.fullySortedByIndex = this.expandTarget == null && indexDefinition.getFields().size() >= this.orderedFields.size() && conditionHierarchy.size() == 1;
                        }
                        this.context.setVariable("$limit", this.limit);
                        cursor = operator.executeIndexQuery(this.context, index, keyParams, ascSortOrder);
                    }
                    catch (OIndexEngineException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error on using index %s in query '%s'. Probably you need to rebuild indexes. Now executing query using cluster scan", e, index.getName(), this.request != null && this.request.getText() != null ? this.request.getText() : "");
                        this.fullySortedByIndex = false;
                        cursors.clear();
                        return null;
                    }
                    if (cursor == null) continue;
                    cursors.add(cursor);
                    indexUseAttempts.add(new IndexUsageLog(index, keyParams, indexDefinition));
                    indexUsed = true;
                    break;
                }
                if (!indexUsed) continue;
                break;
            }
            if (indexUsed) continue;
            Stream<ORawPair<Object, ORID>> stream = this.tryGetOptimizedSortStream(iSchemaClass);
            if (stream == null) {
                return null;
            }
            ArrayList<Stream<ORawPair<Object, ORID>>> result = new ArrayList<Stream<ORawPair<Object, ORID>>>();
            result.add(stream);
            return result;
        }
        if (cursors.size() == 0 || lastSearchResult == null) {
            return null;
        }
        this.metricRecorder.recordOrderByOptimizationMetric(indexIsUsedInOrderBy, this.fullySortedByIndex);
        indexUseAttempts.clear();
        return cursors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean searchForIndexes(OClass iSchemaClass) {
        if (this.uniqueResult != null) {
            this.uniqueResult.clear();
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLSelect.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)iSchemaClass.getName().toLowerCase(Locale.ENGLISH));
        if (this.compiledFilter == null) {
            return this.tryOptimizeSort(iSchemaClass);
        }
        Iterator<OIdentifiable> fetchedFromFunction = this.tryIndexedFunctions(iSchemaClass);
        if (fetchedFromFunction != null) {
            this.fetchFromTarget(fetchedFromFunction);
            return true;
        }
        List<List<OIndexSearchResult>> conditionHierarchy = this.filterAnalyzer.analyzeMainCondition(this.compiledFilter.getRootCondition(), iSchemaClass, this.context);
        if (conditionHierarchy == null) {
            return false;
        }
        ArrayList<void> streams = new ArrayList<void>();
        boolean indexIsUsedInOrderBy = false;
        ArrayList<IndexUsageLog> indexUseAttempts = new ArrayList<IndexUsageLog>();
        try {
            Stream stream;
            Map.Entry<String, Object> entry;
            OIndexSearchResult lastSearchResult = null;
            for (List<OIndexSearchResult> list : conditionHierarchy) {
                boolean indexUsed = false;
                for (Object searchResult : list) {
                    lastSearchResult = searchResult;
                    List<OIndex> involvedIndexes = this.filterAnalyzer.getInvolvedIndexes(iSchemaClass, (OIndexSearchResult)searchResult);
                    Collections.sort(involvedIndexes, new IndexComparator());
                    for (OIndex index : involvedIndexes) {
                        void stream2;
                        String relatedIndexField;
                        String lastFiled;
                        OQueryOperator operator;
                        OIndexDefinition indexDefinition = index.getDefinition();
                        if (((OIndexSearchResult)searchResult).containsNullValues && indexDefinition.isNullValuesIgnored() || !OIndexSearchResult.isIndexEqualityOperator(operator = ((OIndexSearchResult)searchResult).lastOperator) && !(lastFiled = ((OIndexSearchResult)searchResult).lastField.getItemName(((OIndexSearchResult)searchResult).lastField.getItemCount() - 1)).equals(relatedIndexField = indexDefinition.getFields().get(((OIndexSearchResult)searchResult).fieldValuePairs.size()))) continue;
                        int searchResultFieldsCount = ((OIndexSearchResult)searchResult).fields().size();
                        ArrayList<Object> keyParams = new ArrayList<Object>(searchResultFieldsCount);
                        for (String fieldName : indexDefinition.getFields().subList(0, searchResultFieldsCount)) {
                            Object fieldValue = ((OIndexSearchResult)searchResult).fieldValuePairs.get(fieldName);
                            if (fieldValue instanceof OSQLQuery) {
                                boolean bl = false;
                                return bl;
                            }
                            if (fieldValue != null) {
                                keyParams.add(fieldValue);
                                continue;
                            }
                            if (((OIndexSearchResult)searchResult).lastValue instanceof OSQLQuery) {
                                boolean bl = false;
                                return bl;
                            }
                            keyParams.add(((OIndexSearchResult)searchResult).lastValue);
                        }
                        indexIsUsedInOrderBy = this.orderByOptimizer.canBeUsedByOrderBy(index, this.orderedFields) && !(index.getInternal() instanceof OChainedIndexProxy);
                        try {
                            boolean ascSortOrder;
                            boolean bl = ascSortOrder = !indexIsUsedInOrderBy || this.orderedFields.get(0).getValue().equals(KEYWORD_ASC);
                            if (indexIsUsedInOrderBy) {
                                this.fullySortedByIndex = this.expandTarget == null && indexDefinition.getFields().size() >= this.orderedFields.size() && conditionHierarchy.size() == 1;
                            }
                            this.context.setVariable("$limit", this.limit);
                            Stream<ORawPair<Object, ORID>> stream22 = operator.executeIndexQuery(this.context, index, keyParams, ascSortOrder);
                            if (stream22 != null) {
                                this.metricRecorder.recordInvolvedIndexesMetric(index);
                            }
                        }
                        catch (OIndexEngineException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            OLogManager.instance().error(this, "Error on using index %s in query '%s'. Probably you need to rebuild indexes. Now executing query using cluster scan", e, index.getName(), this.request != null && this.request.getText() != null ? this.request.getText() : "");
                            this.fullySortedByIndex = false;
                            streams.clear();
                            boolean bl = false;
                            for (IndexUsageLog wastedIndexUsage : indexUseAttempts) {
                                this.revertProfiler(this.context, wastedIndexUsage.index, wastedIndexUsage.keyParams, wastedIndexUsage.indexDefinition);
                            }
                            return bl;
                        }
                        if (stream2 == null) continue;
                        streams.add(stream2);
                        indexUseAttempts.add(new IndexUsageLog(index, keyParams, indexDefinition));
                        indexUsed = true;
                        break;
                    }
                    if (!indexUsed) continue;
                    break;
                }
                if (indexUsed) continue;
                boolean bl = this.tryOptimizeSort(iSchemaClass);
                return bl;
            }
            if (streams.size() == 0 || lastSearchResult == null) {
                boolean bl = false;
                return bl;
            }
            if (streams.size() == 1 && this.canOptimize(conditionHierarchy)) {
                this.filterOptimizer.optimize(this.compiledFilter, lastSearchResult);
            }
            this.uniqueResult = new ConcurrentHashMap();
            if (streams.size() == 1 && (this.compiledFilter == null || this.compiledFilter.getRootCondition() == null) && this.groupByFields == null && this.projections != null && this.projections.size() == 1 && (entry = this.projections.entrySet().iterator().next()).getValue() instanceof OSQLFunctionRuntime) {
                boolean restrictedClasses;
                OSQLFunctionRuntime oSQLFunctionRuntime = (OSQLFunctionRuntime)entry.getValue();
                if (oSQLFunctionRuntime.function instanceof OSQLFunctionCount && oSQLFunctionRuntime.configuredParameters.length == 1 && "*".equals(oSQLFunctionRuntime.configuredParameters[0]) && !(restrictedClasses = this.isUsingRestrictedClasses())) {
                    Iterator cursor = ((Stream)streams.get(0)).iterator();
                    long count = 0L;
                    if (cursor instanceof OSizeable) {
                        count = ((OSizeable)((Object)cursor)).size();
                    } else {
                        while (cursor.hasNext()) {
                            cursor.next();
                            ++count;
                        }
                    }
                    OProfiler profiler = Orient.instance().getProfiler();
                    if (profiler.isRecording()) {
                        profiler.updateCounter(profiler.getDatabaseMetric(database.getName(), "query.indexUsed"), "Used index in query", 1L);
                    }
                    if (this.tempResult == null) {
                        this.tempResult = new ArrayList();
                    }
                    ((Collection)this.tempResult).add(new ODocument().field(entry.getKey(), count));
                    boolean bl = true;
                    return bl;
                }
            }
            Iterator<List<OIndexSearchResult>> iterator = streams.iterator();
            while (iterator.hasNext() && this.fetchValuesFromIndexStream(stream = (Stream)((Object)iterator.next()))) {
            }
            this.uniqueResult.clear();
            this.uniqueResult = null;
            this.metricRecorder.recordOrderByOptimizationMetric(indexIsUsedInOrderBy, this.fullySortedByIndex);
            indexUseAttempts.clear();
            boolean bl = true;
            return bl;
        }
        finally {
            for (IndexUsageLog wastedIndexUsage : indexUseAttempts) {
                this.revertProfiler(this.context, wastedIndexUsage.index, wastedIndexUsage.keyParams, wastedIndexUsage.indexDefinition);
            }
        }
    }

    private Iterator<OIdentifiable> tryIndexedFunctions(OClass iSchemaClass) {
        if (this.preParsedStatement == null) {
            return null;
        }
        OWhereClause where = ((OSelectStatement)this.preParsedStatement).getWhereClause();
        if (where == null) {
            return null;
        }
        List<OBinaryCondition> conditions = where.getIndexedFunctionConditions(iSchemaClass, OCommandExecutorSQLSelect.getDatabase());
        long lastEstimation = Long.MAX_VALUE;
        OBinaryCondition bestCondition = null;
        if (conditions == null) {
            return null;
        }
        for (OBinaryCondition condition : conditions) {
            long estimation = condition.estimateIndexed(((OSelectStatement)this.preParsedStatement).getTarget(), this.getContext());
            if (estimation <= -1L || estimation >= lastEstimation) continue;
            lastEstimation = estimation;
            bestCondition = condition;
        }
        if (bestCondition == null) {
            return null;
        }
        Iterable<OIdentifiable> result = bestCondition.executeIndexedFunction(((OSelectStatement)this.preParsedStatement).getTarget(), this.getContext());
        if (result == null) {
            return null;
        }
        return result.iterator();
    }

    private boolean canOptimize(List<List<OIndexSearchResult>> conditionHierarchy) {
        if (conditionHierarchy.size() > 1) {
            return false;
        }
        for (List<OIndexSearchResult> subCoditions : conditionHierarchy) {
            if (subCoditions.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private boolean optimizeSort(OClass iSchemaClass) {
        Stream<ORawPair<Object, ORID>> stream = this.getOptimizedSortStream(iSchemaClass);
        if (stream != null) {
            this.fetchValuesFromIndexStream(stream);
            return true;
        }
        return false;
    }

    private Stream<ORawPair<Object, ORID>> getOptimizedSortStream(OClass iSchemaClass) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (OPair<String, String> pair : this.orderedFields) {
            fieldNames.add((String)pair.getKey());
        }
        Set<OIndex> indexes = iSchemaClass.getInvolvedIndexes(fieldNames);
        for (OIndex index : indexes) {
            if (!this.orderByOptimizer.canBeUsedByOrderBy(index, this.orderedFields)) continue;
            boolean ascSortOrder = this.orderedFields.get(0).getValue().equals(KEYWORD_ASC);
            ArrayList<Stream<ORawPair<Object, ORID>>> streams = new ArrayList<Stream<ORawPair<Object, ORID>>>();
            Stream<ORawPair<Object, ORID>> stream = null;
            stream = ascSortOrder ? index.getInternal().stream() : index.getInternal().descStream();
            if (stream != null) {
                streams.add(stream);
            }
            if (index.getMetadata() != null && !index.getDefinition().isNullValuesIgnored()) {
                Stream<ORID> nullRids = index.getInternal().getRids(null);
                streams.add(nullRids.map(rid -> new ORawPair<Object, ORID>(null, (ORID)rid)));
            }
            this.fullySortedByIndex = true;
            if (this.context.isRecordingMetrics()) {
                this.context.setVariable("indexIsUsedInOrderBy", true);
                this.context.setVariable("fullySortedByIndex", this.fullySortedByIndex);
                HashSet<String> idxNames = (HashSet<String>)this.context.getVariable("involvedIndexes");
                if (idxNames == null) {
                    idxNames = new HashSet<String>();
                    this.context.setVariable("involvedIndexes", idxNames);
                }
                idxNames.add(index.getName());
            }
            if (streams.isEmpty()) {
                return Stream.empty();
            }
            if (streams.size() == 1) {
                return (Stream)streams.get(0);
            }
            Stream resultStream = (Stream)streams.get(0);
            for (int i = 1; i < streams.size(); ++i) {
                resultStream = Stream.concat(resultStream, (Stream)streams.get(i));
            }
            return resultStream;
        }
        this.metricRecorder.recordOrderByOptimizationMetric(false, this.fullySortedByIndex);
        return null;
    }

    private boolean fetchValuesFromIndexStream(Stream<ORawPair<Object, ORID>> stream) {
        return this.fetchFromTarget(stream.map(pair -> (ORID)pair.second).iterator());
    }

    private void fetchEntriesFromIndexStream(Stream<ORawPair<Object, ORID>> stream) {
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            ORawPair entryRecord = (ORawPair)iterator.next();
            ODocument doc = new ODocument().setOrdered(true);
            doc.field("key", entryRecord.first);
            doc.field("rid", entryRecord.second);
            ORecordInternal.unsetDirty(doc);
            this.applyGroupBy(doc, this.context);
            if (this.handleResult(doc, this.context)) continue;
            break;
        }
    }

    private boolean isRidOnlySort() {
        return this.parsedTarget.getTargetClasses() != null && this.orderedFields.size() == 1 && ((String)this.orderedFields.get(0).getKey()).toLowerCase(Locale.ENGLISH).equals("@rid") && this.target != null && this.target instanceof ORecordIteratorClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyOrderBy(boolean clearOrderedFields) {
        if (this.orderedFields.isEmpty() || this.fullySortedByIndex || this.isRidOnlySort()) {
            return;
        }
        long startOrderBy = System.currentTimeMillis();
        try {
            if (this.tempResult instanceof OMultiCollectionIterator) {
                ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
                for (OIdentifiable o : this.tempResult) {
                    list.add(o);
                }
                this.tempResult = list;
            }
            this.tempResult = this.applySort((List)this.tempResult, this.orderedFields, this.context);
            if (clearOrderedFields) {
                this.orderedFields.clear();
            }
        }
        finally {
            this.metricRecorder.orderByElapsed(startOrderBy);
        }
    }

    private Iterable<OIdentifiable> applySort(List<OIdentifiable> iCollection, List<OPair<String, String>> iOrderFields, OCommandContext iContext) {
        ODocumentHelper.sort(iCollection, iOrderFields, iContext);
        return iCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyExpand() {
        if (this.expandTarget == null) {
            return;
        }
        long startExpand = System.currentTimeMillis();
        try {
            if (this.tempResult == null) {
                this.tempResult = new ArrayList();
                if (this.expandTarget instanceof OSQLFilterItemVariable) {
                    Object r = ((OSQLFilterItemVariable)this.expandTarget).getValue(null, null, this.context);
                    if (r != null) {
                        if (r instanceof OIdentifiable) {
                            ((Collection)this.tempResult).add((OIdentifiable)r);
                        } else if (r instanceof Iterator || OMultiValue.isMultiValue(r)) {
                            for (Object o : OMultiValue.getMultiValueIterable(r)) {
                                ((Collection)this.tempResult).add((OIdentifiable)o);
                            }
                        }
                    }
                } else if (this.expandTarget instanceof OSQLFunctionRuntime && !this.hasFieldItemParams((OSQLFunctionRuntime)this.expandTarget)) {
                    if (((OSQLFunctionRuntime)this.expandTarget).aggregateResults()) {
                        throw new OCommandExecutionException("Unsupported operation: aggregate function in expand(" + this.expandTarget + ")");
                    }
                    Object r = ((OSQLFunctionRuntime)this.expandTarget).execute(null, null, null, this.context);
                    if (r instanceof OIdentifiable) {
                        ((Collection)this.tempResult).add((OIdentifiable)r);
                    } else if (r instanceof Iterator || OMultiValue.isMultiValue(r)) {
                        for (Object o : OMultiValue.getMultiValueIterable(r)) {
                            ((Collection)this.tempResult).add((OIdentifiable)o);
                        }
                    }
                }
            } else {
                if (this.tempResult == null) {
                    this.tempResult = new ArrayList();
                }
                OMultiCollectionIterator finalResult = new OMultiCollectionIterator();
                if (this.orderedFields == null || this.orderedFields.size() == 0) {
                    int iteratorLimit = 0;
                    iteratorLimit = this.limit < 0 ? -1 : (iteratorLimit += this.limit);
                    finalResult.setLimit(iteratorLimit);
                    finalResult.setSkip(this.skip);
                }
                for (OIdentifiable id : this.tempResult) {
                    Object fieldValue = this.expandTarget instanceof OSQLFilterItem ? ((OSQLFilterItem)this.expandTarget).getValue((OIdentifiable)id.getRecord(), null, this.context) : (this.expandTarget instanceof OSQLFunctionRuntime ? ((OSQLFunctionRuntime)this.expandTarget).getResult() : this.expandTarget.toString());
                    if (fieldValue == null) continue;
                    if (fieldValue instanceof Iterable && !(fieldValue instanceof OIdentifiable)) {
                        fieldValue = ((Iterable)fieldValue).iterator();
                    }
                    if (fieldValue instanceof ODocument) {
                        ArrayList<ODocument> partial = new ArrayList<ODocument>();
                        partial.add((ODocument)fieldValue);
                        finalResult.add(partial);
                        continue;
                    }
                    if (fieldValue instanceof Collection || fieldValue.getClass().isArray() || fieldValue instanceof Iterator || fieldValue instanceof OIdentifiable || fieldValue instanceof ORidBag) {
                        finalResult.add(fieldValue);
                        continue;
                    }
                    if (!(fieldValue instanceof Map)) continue;
                    finalResult.add(((Map)fieldValue).values());
                }
                this.tempResult = finalResult;
            }
        }
        finally {
            this.context.setVariable("expandElapsed", System.currentTimeMillis() - startExpand);
        }
    }

    private boolean hasFieldItemParams(OSQLFunctionRuntime expandTarget) {
        Object[] params = expandTarget.getConfiguredParameters();
        if (params == null) {
            return false;
        }
        for (Object o : params) {
            if (!(o instanceof OSQLFilterItemField)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchInIndex() {
        block139: {
            OIndexAbstract.manualIndexesWarning();
            ODatabaseDocumentInternal database = OCommandExecutorSQLSelect.getDatabase();
            OIndex index = database.getMetadata().getIndexManagerInternal().getIndex(database, this.parsedTarget.getTargetIndex());
            if (index == null) {
                throw new OCommandExecutionException("Target index '" + this.parsedTarget.getTargetIndex() + "' not found");
            }
            boolean ascOrder = true;
            if (!this.orderedFields.isEmpty()) {
                if (this.orderedFields.size() != 1) {
                    throw new OCommandExecutionException("Index can be ordered only by key field");
                }
                String fieldName = (String)this.orderedFields.get(0).getKey();
                if (!fieldName.equalsIgnoreCase("key")) {
                    throw new OCommandExecutionException("Index can be ordered only by key field");
                }
                String order = this.orderedFields.get(0).getValue();
                ascOrder = order.equalsIgnoreCase(KEYWORD_ASC);
            }
            if (index.getDefinition() == null) {
                return;
            }
            if (this.compiledFilter != null && this.compiledFilter.getRootCondition() != null) {
                Stream<ORID> res;
                Object value;
                if (!"KEY".equalsIgnoreCase(this.compiledFilter.getRootCondition().getLeft().toString())) {
                    throw new OCommandExecutionException("'Key' field is required for queries against indexes");
                }
                OQueryOperator indexOperator = this.compiledFilter.getRootCondition().getOperator();
                if (indexOperator instanceof OQueryOperatorBetween) {
                    Object[] values = (Object[])this.compiledFilter.getRootCondition().getRight();
                    try (Stream<ORawPair<Object, ORID>> stream = index.getInternal().streamEntriesBetween(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), values[0], this.context), true, OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), values[2], this.context), true, ascOrder);){
                        this.fetchEntriesFromIndexStream(stream);
                    }
                }
                if (indexOperator instanceof OQueryOperatorMajor) {
                    value = this.compiledFilter.getRootCondition().getRight();
                    try (Stream<ORawPair<Object, ORID>> stream = index.getInternal().streamEntriesMajor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value, this.context), false, ascOrder);){
                        this.fetchEntriesFromIndexStream(stream);
                    }
                }
                if (indexOperator instanceof OQueryOperatorMajorEquals) {
                    value = this.compiledFilter.getRootCondition().getRight();
                    try (Stream<ORawPair<Object, ORID>> stream = index.getInternal().streamEntriesMajor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value, this.context), true, ascOrder);){
                        this.fetchEntriesFromIndexStream(stream);
                    }
                }
                if (indexOperator instanceof OQueryOperatorMinor) {
                    value = this.compiledFilter.getRootCondition().getRight();
                    try (Stream<ORawPair<Object, ORID>> stream = index.getInternal().streamEntriesMinor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value, this.context), false, ascOrder);){
                        this.fetchEntriesFromIndexStream(stream);
                    }
                }
                if (indexOperator instanceof OQueryOperatorMinorEquals) {
                    value = this.compiledFilter.getRootCondition().getRight();
                    try (Stream<ORawPair<Object, ORID>> stream = index.getInternal().streamEntriesMinor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value, this.context), true, ascOrder);){
                        this.fetchEntriesFromIndexStream(stream);
                    }
                }
                if (indexOperator instanceof OQueryOperatorIn) {
                    Object val2;
                    List origValues = (List)this.compiledFilter.getRootCondition().getRight();
                    ArrayList<Object> values = new ArrayList<Object>(origValues.size());
                    for (Object val2 : origValues) {
                        if (index.getDefinition() instanceof OCompositeIndexDefinition) {
                            throw new OCommandExecutionException("Operator IN not supported yet.");
                        }
                        val2 = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), val2, this.context);
                        values.add(val2);
                    }
                    Stream<ORawPair<Object, ORID>> stream = index.getInternal().streamEntries(values, true);
                    val2 = null;
                    try {
                        this.fetchEntriesFromIndexStream(stream);
                    }
                    catch (Throwable throwable) {
                        val2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stream != null) {
                            if (val2 != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)val2).addSuppressed(throwable);
                                }
                            } else {
                                stream.close();
                            }
                        }
                    }
                }
                Object right = this.compiledFilter.getRootCondition().getRight();
                Object keyValue = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), right, this.context);
                if (keyValue == null) {
                    return;
                }
                if (index.getDefinition().getParamCount() == 1) {
                    OType type = index.getDefinition().getTypes()[0];
                    keyValue = OType.convert(keyValue, type.getDefaultJavaType());
                    res = index.getInternal().getRids(keyValue);
                } else {
                    Object secondKey = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), right, this.context);
                    if (keyValue instanceof OCompositeKey && secondKey instanceof OCompositeKey && ((OCompositeKey)keyValue).getKeys().size() == index.getDefinition().getParamCount() && ((OCompositeKey)secondKey).getKeys().size() == index.getDefinition().getParamCount()) {
                        res = index.getInternal().getRids(keyValue);
                    } else {
                        try (Stream<ORawPair<Object, ORID>> stream = index.getInternal().streamEntriesBetween(keyValue, true, secondKey, true, true);){
                            this.fetchEntriesFromIndexStream(stream);
                        }
                        return;
                    }
                }
                Object resultKey = keyValue;
                BreakingForEach.forEach(res, (rid, breaker) -> {
                    ODocument record = OCommandExecutorSQLSelect.createIndexEntryAsDocument(resultKey, rid);
                    this.applyGroupBy(record, this.context);
                    if (!this.handleResult(record, this.context)) {
                        breaker.stop();
                    }
                });
            } else {
                if (this.isIndexSizeQuery()) {
                    this.getProjectionGroup(null, this.context).applyValue(this.projections.keySet().iterator().next(), index.getInternal().size());
                    return;
                }
                if (this.isIndexKeySizeQuery()) {
                    this.getProjectionGroup(null, this.context).applyValue(this.projections.keySet().iterator().next(), index.getInternal().size());
                    return;
                }
                OIndexInternal indexInternal = index.getInternal();
                if (indexInternal instanceof OSharedResource) {
                    ((OSharedResource)((Object)indexInternal)).acquireExclusiveLock();
                }
                try {
                    Stream<ORawPair<Object, ORID>> stream;
                    if (ascOrder) {
                        stream = index.getInternal().stream();
                        Throwable throwable = null;
                        try {
                            this.fetchEntriesFromIndexStream(stream);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream != null) {
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                        }
                        this.fetchNullKeyEntries(index);
                        break block139;
                    }
                    stream = index.getInternal().descStream();
                    Throwable throwable = null;
                    try {
                        this.fetchNullKeyEntries(index);
                        this.fetchEntriesFromIndexStream(stream);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (stream != null) {
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stream.close();
                            }
                        }
                    }
                }
                finally {
                    if (indexInternal instanceof OSharedResource) {
                        ((OSharedResource)((Object)indexInternal)).releaseExclusiveLock();
                    }
                }
            }
        }
    }

    private void fetchNullKeyEntries(OIndex index) {
        if (index.getDefinition().isNullValuesIgnored()) {
            return;
        }
        Stream<ORID> rids = index.getInternal().getRids(null);
        BreakingForEach.forEach(rids, (rid, breaker) -> {
            ODocument doc = new ODocument().setOrdered(true);
            doc.field("key", (Object)null);
            doc.field("rid", rid);
            ORecordInternal.unsetDirty(doc);
            this.applyGroupBy(doc, this.context);
            if (!this.handleResult(doc, this.context)) {
                breaker.stop();
            }
        });
    }

    private boolean isIndexSizeQuery() {
        if (!this.aggregate || this.projections.entrySet().size() != 1) {
            return false;
        }
        Object projection = this.projections.values().iterator().next();
        if (!(projection instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection;
        return f.getRoot().equals("count") && (f.configuredParameters == null || f.configuredParameters.length == 0 || f.configuredParameters.length == 1 && f.configuredParameters[0].equals("*"));
    }

    private boolean isIndexKeySizeQuery() {
        if (!this.aggregate || this.projections.entrySet().size() != 1) {
            return false;
        }
        Object projection = this.projections.values().iterator().next();
        if (!(projection instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection;
        if (!f.getRoot().equals("count")) {
            return false;
        }
        if (f.configuredParameters == null || f.configuredParameters.length != 1 || !(f.configuredParameters[0] instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime fConfigured = (OSQLFunctionRuntime)f.configuredParameters[0];
        if (!fConfigured.getRoot().equals("distinct")) {
            return false;
        }
        if (fConfigured.configuredParameters == null || fConfigured.configuredParameters.length != 1 || !(fConfigured.configuredParameters[0] instanceof OSQLFilterItemField)) {
            return false;
        }
        OSQLFilterItemField field = (OSQLFilterItemField)fConfigured.configuredParameters[0];
        return field.getRoot().equals("key");
    }

    private void handleNoTarget() {
        if (this.parsedTarget == null && this.expandTarget == null) {
            this.addResult(ORuntimeResult.createProjectionDocument(this.getTemporaryRIDCounter(this.context)), this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGroupBy(OCommandContext iContext) {
        if (this.aggregate && this.tempResult == null) {
            long startGroupBy = System.currentTimeMillis();
            try {
                this.tempResult = new ArrayList();
                for (Map.Entry g : this.groupedResult.entrySet()) {
                    ODocument doc;
                    if (g.getKey() == null && (this.groupedResult.size() != 1 || this.groupByFields != null) || (doc = ((ORuntimeResult)g.getValue()).getResult()) == null) continue;
                    ((List)this.tempResult).add(doc);
                }
            }
            finally {
                iContext.setVariable("groupByElapsed", System.currentTimeMillis() - startGroupBy);
            }
        }
    }

    public void setProjections(Map<String, Object> projections) {
        this.projections = projections;
    }

    public Map<String, String> getProjectionDefinition() {
        return this.projectionDefinition;
    }

    public void setProjectionDefinition(Map<String, String> projectionDefinition) {
        this.projectionDefinition = projectionDefinition;
    }

    public void setOrderedFields(List<OPair<String, String>> orderedFields) {
        this.orderedFields = orderedFields;
    }

    public void setGroupByFields(List<String> groupByFields) {
        this.groupByFields = groupByFields;
    }

    public void setFetchLimit(int fetchLimit) {
        this.fetchLimit = fetchLimit;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.READ;
    }

    private final class IndexComparator
    implements Comparator<OIndex> {
        private IndexComparator() {
        }

        @Override
        public int compare(OIndex indexOne, OIndex indexTwo) {
            int secondParamCount;
            OIndexDefinition definitionOne = indexOne.getDefinition();
            OIndexDefinition definitionTwo = indexTwo.getDefinition();
            int firstParamCount = definitionOne.getParamCount();
            int result = firstParamCount - (secondParamCount = definitionTwo.getParamCount());
            if (result == 0 && !OCommandExecutorSQLSelect.this.orderedFields.isEmpty()) {
                if (!(indexOne instanceof OChainedIndexProxy) && OCommandExecutorSQLSelect.this.orderByOptimizer.canBeUsedByOrderBy(indexOne, OCommandExecutorSQLSelect.this.orderedFields)) {
                    return 1;
                }
                if (!(indexTwo instanceof OChainedIndexProxy) && OCommandExecutorSQLSelect.this.orderByOptimizer.canBeUsedByOrderBy(indexTwo, OCommandExecutorSQLSelect.this.orderedFields)) {
                    return -1;
                }
            }
            return result;
        }
    }

    private static final class IndexUsageLog {
        private OIndex index;
        private List<Object> keyParams;
        private OIndexDefinition indexDefinition;

        IndexUsageLog(OIndex index, List<Object> keyParams, OIndexDefinition indexDefinition) {
            this.index = index;
            this.keyParams = keyParams;
            this.indexDefinition = indexDefinition;
        }
    }

    private static class AsyncResult {
        private final OIdentifiable record;
        private final OCommandContext context;

        public AsyncResult(ORecord iRecord, OCommandContext iContext) {
            this.record = iRecord;
            this.context = iContext;
        }
    }
}

