/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OTruncateClusterStatement;
import java.util.Map;

public class OCommandExecutorSQLTruncateCluster
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_TRUNCATE = "TRUNCATE";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    private String clusterName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLTruncateCluster parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            ODatabaseDocumentInternal database;
            OIdentifier name;
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLTruncateCluster.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_TRUNCATE)) {
                throw new OCommandSQLParsingException("Keyword TRUNCATE not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLTruncateCluster.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLUSTER)) {
                throw new OCommandSQLParsingException("Keyword CLUSTER not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLTruncateCluster.nextWord(this.parserText, this.parserText, oldPos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Expected cluster name. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            this.clusterName = this.decodeClusterName(word.toString());
            if (this.preParsedStatement != null && (name = ((OTruncateClusterStatement)this.preParsedStatement).clusterName) != null) {
                this.clusterName = name.getStringValue();
            }
            if ((database = OCommandExecutorSQLTruncateCluster.getDatabase()).getClusterIdByName(this.clusterName) == -1) {
                throw new OCommandSQLParsingException("Cluster '" + this.clusterName + "' not found", this.parserText, oldPos);
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    private String decodeClusterName(String s) {
        return this.decodeClassName(s);
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.clusterName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLTruncateCluster.getDatabase();
        int clusterId = database.getClusterIdByName(this.clusterName);
        if (clusterId < 0) {
            throw new ODatabaseException("Cluster with name " + this.clusterName + " does not exist");
        }
        OSchema schema = database.getMetadata().getSchema();
        OClass clazz = schema.getClassByClusterId(clusterId);
        if (clazz == null) {
            database.checkForClusterPermissions(this.clusterName);
            ORecordIteratorCluster iteratorCluster = database.browseCluster(this.clusterName);
            if (iteratorCluster == null) {
                throw new ODatabaseException("Cluster with name " + this.clusterName + " does not exist");
            }
            while (iteratorCluster.hasNext()) {
                Object record = iteratorCluster.next();
                record.delete();
            }
        } else {
            clazz.truncateCluster(this.clusterName);
        }
        return true;
    }

    @Override
    public long getDistributedTimeout() {
        return OCommandExecutorSQLTruncateCluster.getDatabase().getConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT);
    }

    @Override
    public String getSyntax() {
        return "TRUNCATE CLUSTER <cluster-name>";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }
}

