/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.ORidSet;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OTraverseProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractTraverseStep
extends AbstractExecutionStep {
    protected final OWhereClause whileClause;
    protected final List<OTraverseProjectionItem> projections;
    protected final OInteger maxDepth;
    protected List<OResult> entryPoints = null;
    protected List<OResult> results = new ArrayList<OResult>();
    private long cost = 0L;
    protected Set<ORID> traversed = new ORidSet();

    public AbstractTraverseStep(List<OTraverseProjectionItem> projections, OWhereClause whileClause, OInteger maxDepth, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.whileClause = whileClause;
        this.maxDepth = maxDepth;
        try (Stream stream = projections.stream();){
            this.projections = stream.map(OTraverseProjectionItem::copy).collect(Collectors.toList());
        }
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        return new OResultSet(){
            private int localFetched = 0;

            @Override
            public boolean hasNext() {
                if (this.localFetched >= nRecords) {
                    return false;
                }
                if (AbstractTraverseStep.this.results.isEmpty()) {
                    AbstractTraverseStep.this.fetchNextBlock(ctx, nRecords);
                }
                return !AbstractTraverseStep.this.results.isEmpty();
            }

            @Override
            public OResult next() {
                if (this.localFetched >= nRecords) {
                    throw new IllegalStateException();
                }
                if (AbstractTraverseStep.this.results.isEmpty()) {
                    AbstractTraverseStep.this.fetchNextBlock(ctx, nRecords);
                    if (AbstractTraverseStep.this.results.isEmpty()) {
                        throw new IllegalStateException();
                    }
                }
                ++this.localFetched;
                OResult result = AbstractTraverseStep.this.results.remove(0);
                if (result.isElement()) {
                    AbstractTraverseStep.this.traversed.add(result.getElement().get().getIdentity());
                }
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void fetchNextBlock(OCommandContext ctx, int nRecords) {
        if (this.entryPoints == null) {
            this.entryPoints = new ArrayList<OResult>();
        }
        if (!this.results.isEmpty()) {
            return;
        }
        while (this.results.isEmpty()) {
            if (this.entryPoints.isEmpty()) {
                this.fetchNextEntryPoints(ctx, nRecords);
            }
            if (this.entryPoints.isEmpty()) {
                return;
            }
            long begin = this.profilingEnabled ? System.nanoTime() : 0L;
            this.fetchNextResults(ctx, nRecords);
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
            if (this.results.isEmpty()) continue;
            return;
        }
    }

    protected abstract void fetchNextEntryPoints(OCommandContext var1, int var2);

    protected abstract void fetchNextResults(OCommandContext var1, int var2);

    protected boolean isFinished() {
        return this.entryPoints != null && this.entryPoints.isEmpty() && this.results.isEmpty();
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    public String toString() {
        return this.prettyPrint(0, 2);
    }
}

