/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OTimeout;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class AccumulatingTimeoutStep
extends AbstractExecutionStep {
    private final OTimeout timeout;
    private final long timeoutMillis;
    private AtomicLong totalTime = new AtomicLong(0L);

    public AccumulatingTimeoutStep(OTimeout timeout, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.timeout = timeout;
        this.timeoutMillis = this.timeout.getVal().longValue();
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet internal = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (AccumulatingTimeoutStep.this.totalTime.get() / 1000000L > AccumulatingTimeoutStep.this.timeoutMillis) {
                    AccumulatingTimeoutStep.this.fail();
                }
                long begin = System.nanoTime();
                try {
                    boolean bl = internal.hasNext();
                    return bl;
                }
                finally {
                    AccumulatingTimeoutStep.this.totalTime.addAndGet(System.nanoTime() - begin);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                if (AccumulatingTimeoutStep.this.totalTime.get() / 1000000L > AccumulatingTimeoutStep.this.timeoutMillis) {
                    AccumulatingTimeoutStep.this.fail();
                }
                long begin = System.nanoTime();
                try {
                    OResult oResult = internal.next();
                    return oResult;
                }
                finally {
                    AccumulatingTimeoutStep.this.totalTime.addAndGet(System.nanoTime() - begin);
                }
            }

            @Override
            public void close() {
                internal.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return internal.getExecutionPlan();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return internal.getQueryStats();
            }
        };
    }

    private OResultSet fail() {
        this.timedOut = true;
        this.sendTimeout();
        if ("RETURN".equals(this.timeout.getFailureStrategy())) {
            return new OInternalResultSet();
        }
        throw new OTimeoutException("Timeout expired");
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new AccumulatingTimeoutStep(this.timeout.copy(), ctx, this.profilingEnabled);
    }

    @Override
    public void reset() {
        this.totalTime = new AtomicLong(0L);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        return OExecutionStepInternal.getIndent(depth, indent) + "+ TIMEOUT (" + this.timeout.getVal().toString() + "ms)";
    }
}

