/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;

public class CheckSafeDeleteStep
extends AbstractExecutionStep {
    private long cost = 0L;

    public CheckSafeDeleteStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                OResult result = upstream.next();
                long begin = CheckSafeDeleteStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    ODocument doc;
                    OClass clazz;
                    OIdentifiable elem;
                    Object record;
                    if (result.isElement() && (record = (elem = (OIdentifiable)result.getElement().get()).getRecord()) instanceof ODocument && (clazz = (doc = (ODocument)record).getSchemaClass()) != null) {
                        if (clazz.getName().equalsIgnoreCase("V") || clazz.isSubClassOf("V")) {
                            throw new OCommandExecutionException("Cannot safely delete a vertex, please use DELETE VERTEX or UNSAFE");
                        }
                        if (clazz.getName().equalsIgnoreCase("E") || clazz.isSubClassOf("E")) {
                            throw new OCommandExecutionException("Cannot safely delete an edge, please use DELETE EDGE or UNSAFE");
                        }
                    }
                    OResult oResult = result;
                    return oResult;
                }
                finally {
                    if (CheckSafeDeleteStep.this.profilingEnabled) {
                        CheckSafeDeleteStep.this.cost = CheckSafeDeleteStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ CHECK SAFE DELETE");
        if (this.profilingEnabled) {
            result.append(" (" + this.getCostFormatted() + ")");
        }
        return result.toString();
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

