/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class ExpandStep
extends AbstractExecutionStep {
    private long cost = 0L;
    private OResultSet lastResult = null;
    private Iterator nextSubsequence = null;
    private OResult nextElement = null;

    public ExpandStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (this.prev == null || !this.prev.isPresent()) {
            throw new OCommandExecutionException("Cannot expand without a target");
        }
        return new OResultSet(){
            private long localCount = 0L;

            @Override
            public boolean hasNext() {
                if (this.localCount >= (long)nRecords) {
                    return false;
                }
                if (ExpandStep.this.nextElement == null) {
                    ExpandStep.this.fetchNext(ctx, nRecords);
                }
                return ExpandStep.this.nextElement != null;
            }

            @Override
            public OResult next() {
                if (this.localCount >= (long)nRecords) {
                    throw new IllegalStateException();
                }
                if (ExpandStep.this.nextElement == null) {
                    ExpandStep.this.fetchNext(ctx, nRecords);
                }
                if (ExpandStep.this.nextElement == null) {
                    throw new IllegalStateException();
                }
                OResult result = ExpandStep.this.nextElement;
                ++this.localCount;
                ExpandStep.this.nextElement = null;
                ExpandStep.this.fetchNext(ctx, nRecords);
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void fetchNext(OCommandContext ctx, int n) {
        while (true) lbl-1000:
        // 12 sources

        {
            if (this.nextSubsequence != null && this.nextSubsequence.hasNext()) {
                begin = this.profilingEnabled != false ? System.nanoTime() : 0L;
                try {
                    nextElementObj = this.nextSubsequence.next();
                    if (nextElementObj instanceof OResult) {
                        this.nextElement = (OResult)nextElementObj;
                        ** break;
                    }
                    if (nextElementObj instanceof OIdentifiable) {
                        record = ((OIdentifiable)nextElementObj).getRecord();
                        if (record == null) continue;
                        this.nextElement = new OResultInternal();
                        ((OResultInternal)this.nextElement).setElement((OIdentifiable)record);
                        ** break;
                    }
                    this.nextElement = new OResultInternal();
                    ((OResultInternal)this.nextElement).setProperty("value", nextElementObj);
                    ** break;
                }
                finally {
                    if (this.profilingEnabled) {
                        this.cost += System.nanoTime() - begin;
                    }
                    continue;
                }
            }
            if (this.nextSubsequence == null || !this.nextSubsequence.hasNext()) {
                if (this.lastResult == null || !this.lastResult.hasNext()) {
                    this.lastResult = this.getPrev().get().syncPull(ctx, n);
                }
                if (!this.lastResult.hasNext()) {
                    return;
                }
            }
            nextAggregateItem = this.lastResult.next();
            begin = this.profilingEnabled != false ? System.nanoTime() : 0L;
            try {
                if (nextAggregateItem.getPropertyNames().size() == 0) ** GOTO lbl-1000
                if (nextAggregateItem.getPropertyNames().size() > 1) {
                    throw new IllegalStateException("Invalid EXPAND on record " + nextAggregateItem);
                }
                propName = nextAggregateItem.getPropertyNames().iterator().next();
                projValue = nextAggregateItem.getProperty(propName);
                if (projValue == null) ** GOTO lbl-1000
                if (projValue instanceof OIdentifiable) {
                    rec = ((OIdentifiable)projValue).getRecord();
                    if (rec == null) ** GOTO lbl-1000
                    res = new OResultInternal();
                    res.setElement((OIdentifiable)rec);
                    this.nextSubsequence = Collections.singleton(res).iterator();
                }
                if (projValue instanceof OResult) {
                    this.nextSubsequence = Collections.singleton((OResult)projValue).iterator();
                }
                if (projValue instanceof Iterator) {
                    this.nextSubsequence = (Iterator)projValue;
                }
                if (!(projValue instanceof Iterable)) ** GOTO lbl-1000
                this.nextSubsequence = ((Iterable)projValue).iterator();
            }
            finally {
                if (!this.profilingEnabled) continue;
                this.cost += System.nanoTime() - begin;
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
lbl57:
        // 3 sources

    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ EXPAND";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

