/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FetchFromStorageMetadataStep
extends AbstractExecutionStep {
    private boolean served = false;
    private long cost = 0L;

    public FetchFromStorageMetadataStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return !FetchFromStorageMetadataStep.this.served;
            }

            @Override
            public OResult next() {
                long begin = FetchFromStorageMetadataStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (!FetchFromStorageMetadataStep.this.served) {
                        OResultInternal result = new OResultInternal();
                        if (ctx.getDatabase() instanceof ODatabaseInternal) {
                            ODatabaseInternal db = (ODatabaseInternal)ctx.getDatabase();
                            OStorage storage = db.getStorage();
                            result.setProperty("clusters", FetchFromStorageMetadataStep.this.toResult(storage.getClusterInstances()));
                            result.setProperty("defaultClusterId", storage.getDefaultClusterId());
                            result.setProperty("totalClusters", storage.getClusters());
                            result.setProperty("configuration", FetchFromStorageMetadataStep.this.toResult(storage.getConfiguration()));
                            result.setProperty("conflictStrategy", storage.getRecordConflictStrategy() == null ? null : storage.getRecordConflictStrategy().getName());
                            result.setProperty("name", storage.getName());
                            result.setProperty("size", storage.getSize());
                            result.setProperty("type", storage.getType());
                            result.setProperty("version", storage.getVersion());
                            result.setProperty("createdAtVersion", storage.getCreatedAtVersion());
                        }
                        FetchFromStorageMetadataStep.this.served = true;
                        OResultInternal oResultInternal = result;
                        return oResultInternal;
                    }
                    throw new IllegalStateException();
                }
                finally {
                    if (FetchFromStorageMetadataStep.this.profilingEnabled) {
                        FetchFromStorageMetadataStep.this.cost = FetchFromStorageMetadataStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }

            @Override
            public void reset() {
                FetchFromStorageMetadataStep.this.served = false;
            }
        };
    }

    private Object toResult(OStorageConfiguration configuration) {
        OResultInternal result = new OResultInternal();
        result.setProperty("charset", configuration.getCharset());
        result.setProperty("clusterSelection", configuration.getClusterSelection());
        result.setProperty("conflictStrategy", configuration.getConflictStrategy());
        result.setProperty("dateFormat", configuration.getDateFormat());
        result.setProperty("dateTimeFormat", configuration.getDateTimeFormat());
        result.setProperty("localeCountry", configuration.getLocaleCountry());
        result.setProperty("localeLanguage", configuration.getLocaleLanguage());
        result.setProperty("recordSerializer", configuration.getRecordSerializer());
        result.setProperty("timezone", String.valueOf(configuration.getTimeZone()));
        result.setProperty("properties", this.toResult(configuration.getProperties()));
        return result;
    }

    private List<OResult> toResult(List<OStorageEntryConfiguration> properties) {
        ArrayList<OResult> result = new ArrayList<OResult>();
        if (properties != null) {
            for (OStorageEntryConfiguration entry : properties) {
                OResultInternal item = new OResultInternal();
                item.setProperty("name", entry.name);
                item.setProperty("value", entry.value);
                result.add(item);
            }
        }
        return result;
    }

    private List<OResult> toResult(Collection<? extends OCluster> clusterInstances) {
        ArrayList<OResult> result = new ArrayList<OResult>();
        if (clusterInstances != null) {
            for (OCluster oCluster : clusterInstances) {
                OResultInternal item = new OResultInternal();
                item.setProperty("name", oCluster.getName());
                item.setProperty("fileName", oCluster.getFileName());
                item.setProperty("id", oCluster.getId());
                item.setProperty("entries", oCluster.getEntries());
                item.setProperty("conflictStrategy", oCluster.getRecordConflictStrategy() == null ? null : oCluster.getRecordConflictStrategy().getName());
                item.setProperty("tombstonesCount", oCluster.getTombstonesCount());
                try {
                    item.setProperty("encryption", oCluster.encryption());
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Can not set value of encryption parameter", e, new Object[0]);
                }
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ FETCH STORAGE METADATA";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

