/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;

public class FetchFromVariableStep
extends AbstractExecutionStep {
    private String variableName;
    private OResultSet source;
    private OResult nextResult = null;
    private boolean inited = false;

    public FetchFromVariableStep(String variableName, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.variableName = variableName;
        this.reset();
    }

    @Override
    public void reset() {
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init();
        return new OResultSet(){
            private int internalNext = 0;

            private void fetchNext() {
                if (FetchFromVariableStep.this.nextResult != null) {
                    return;
                }
                if (FetchFromVariableStep.this.source.hasNext()) {
                    FetchFromVariableStep.this.nextResult = FetchFromVariableStep.this.source.next();
                }
            }

            @Override
            public boolean hasNext() {
                if (this.internalNext >= nRecords) {
                    return false;
                }
                if (FetchFromVariableStep.this.nextResult == null) {
                    this.fetchNext();
                }
                return FetchFromVariableStep.this.nextResult != null;
            }

            @Override
            public OResult next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                ++this.internalNext;
                OResult result = FetchFromVariableStep.this.nextResult;
                FetchFromVariableStep.this.nextResult = null;
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        Object src = this.ctx.getVariable(this.variableName);
        if (src instanceof OInternalResultSet) {
            this.source = ((OInternalResultSet)src).copy();
        } else if (src instanceof OResultSet) {
            this.source = (OResultSet)src;
            this.source.reset();
        } else if (src instanceof OElement) {
            this.source = new OInternalResultSet();
            ((OInternalResultSet)this.source).add(new OResultInternal((OElement)src));
        } else if (src instanceof OResult) {
            this.source = new OInternalResultSet();
            ((OInternalResultSet)this.source).add((OResult)src);
        } else if (src instanceof Iterable) {
            this.source = new OInternalResultSet();
            for (Object next : (Iterable)src) {
                if (next instanceof OElement) {
                    ((OInternalResultSet)this.source).add(new OResultInternal((OElement)next));
                    continue;
                }
                if (next instanceof OResult) {
                    ((OInternalResultSet)this.source).add((OResult)next);
                    continue;
                }
                OResultInternal item = new OResultInternal();
                item.setProperty("value", next);
                ((OInternalResultSet)this.source).add(item);
            }
        } else {
            throw new OCommandExecutionException("Cannot use variable as query target: " + this.variableName);
        }
        this.nextResult = null;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        return OExecutionStepInternal.getIndent(depth, indent) + "+ FETCH FROM VARIABLE\n" + OExecutionStepInternal.getIndent(depth, indent) + "  " + this.variableName;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        result.setProperty("variableName", this.variableName);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            if (fromResult.getProperty("variableName") != null) {
                this.variableName = (String)fromResult.getProperty(this.variableName);
            }
            this.reset();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }
}

