/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromClusterExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class FetchTemporaryFromTxStep
extends AbstractExecutionStep {
    private String className;
    private Iterator<ORecord> txEntries;
    private Object order;
    private long cost = 0L;

    public FetchTemporaryFromTxStep(OCommandContext ctx, String className, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.className = className;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init();
        return new OResultSet(){
            private int currentElement = 0;

            @Override
            public boolean hasNext() {
                if (FetchTemporaryFromTxStep.this.txEntries == null) {
                    return false;
                }
                if (this.currentElement >= nRecords) {
                    return false;
                }
                return FetchTemporaryFromTxStep.this.txEntries.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                long begin = FetchTemporaryFromTxStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (FetchTemporaryFromTxStep.this.txEntries == null) {
                        throw new IllegalStateException();
                    }
                    if (this.currentElement >= nRecords) {
                        throw new IllegalStateException();
                    }
                    if (!FetchTemporaryFromTxStep.this.txEntries.hasNext()) {
                        throw new IllegalStateException();
                    }
                    ORecord record = (ORecord)FetchTemporaryFromTxStep.this.txEntries.next();
                    ++this.currentElement;
                    OResultInternal result = new OResultInternal();
                    result.setElement(record);
                    ctx.setVariable("$current", result);
                    OResultInternal oResultInternal = result;
                    return oResultInternal;
                }
                finally {
                    if (FetchTemporaryFromTxStep.this.profilingEnabled) {
                        FetchTemporaryFromTxStep.this.cost = FetchTemporaryFromTxStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            if (this.txEntries == null) {
                Iterable<? extends ORecordOperation> iterable = this.ctx.getDatabase().getTransaction().getRecordOperations();
                ArrayList<ORecord> records = new ArrayList<ORecord>();
                if (iterable != null) {
                    for (ORecordOperation oRecordOperation : iterable) {
                        ORecord record = oRecordOperation.getRecord();
                        if (!this.matchesClass(record, this.className) || this.hasCluster(record)) continue;
                        records.add(record);
                    }
                }
                if (this.order == FetchFromClusterExecutionStep.ORDER_ASC) {
                    Collections.sort(records, new Comparator<ORecord>(){

                        @Override
                        public int compare(ORecord o1, ORecord o2) {
                            long p2;
                            long p1 = o1.getIdentity().getClusterPosition();
                            if (p1 == (p2 = o2.getIdentity().getClusterPosition())) {
                                return 0;
                            }
                            if (p1 > p2) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                } else {
                    Collections.sort(records, new Comparator<ORecord>(){

                        @Override
                        public int compare(ORecord o1, ORecord o2) {
                            long p2;
                            long p1 = o1.getIdentity().getClusterPosition();
                            if (p1 == (p2 = o2.getIdentity().getClusterPosition())) {
                                return 0;
                            }
                            if (p1 > p2) {
                                return -1;
                            }
                            return 1;
                        }
                    });
                }
                this.txEntries = records.iterator();
            }
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    private boolean hasCluster(ORecord record) {
        ORID rid = record.getIdentity();
        if (rid == null) {
            return false;
        }
        return rid.getClusterId() >= 0;
    }

    private boolean matchesClass(ORecord record, String className) {
        Object doc = record.getRecord();
        if (!(doc instanceof ODocument)) {
            return false;
        }
        OClass schema = ((ODocument)doc).getSchemaClass();
        if (schema == null) {
            return className == null;
        }
        if (schema.getName().equals(className)) {
            return true;
        }
        return schema.isSubClassOf(className);
    }

    public void setOrder(Object order) {
        this.order = order;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ FETCH NEW RECORDS FROM CURRENT TRANSACTION SCOPE (if any)");
        if (this.profilingEnabled) {
            result.append(" (" + this.getCostFormatted() + ")");
        }
        return result.toString();
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        result.setProperty("className", this.className);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            this.className = (String)fromResult.getProperty("className");
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        FetchTemporaryFromTxStep result = new FetchTemporaryFromTxStep(ctx, this.className, this.profilingEnabled);
        return result;
    }
}

