/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;

public class GlobalLetExpressionStep
extends AbstractExecutionStep {
    private final OIdentifier varname;
    private final OExpression expression;
    private boolean executed = false;

    public GlobalLetExpressionStep(OIdentifier varName, OExpression expression, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.varname = varName;
        this.expression = expression;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.calculate(ctx);
        return new OInternalResultSet();
    }

    private void calculate(OCommandContext ctx) {
        if (this.executed) {
            return;
        }
        Object value = this.expression.execute((OResult)null, ctx);
        ctx.setVariable(this.varname.getStringValue(), value);
        this.executed = true;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        return spaces + "+ LET (once)\n" + spaces + "  " + this.varname + " = " + this.expression;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new GlobalLetExpressionStep(this.varname.copy(), this.expression.copy(), ctx, this.profilingEnabled);
    }

    @Override
    public boolean canBeCached() {
        return true;
    }
}

