/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.query.live.OLiveQueryListenerV2;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public class LiveQueryListenerImpl
implements OLiveQueryListenerV2 {
    public static final String BEFORE_METADATA_KEY = "$$before$$";
    private final OLiveQueryResultListener clientListener;
    private ODatabaseDocument execDb;
    private final OSelectStatement statement;
    private String className;
    private List<ORecordId> rids;
    private final Map<Object, Object> params;
    private int token;
    private static final Random random = new Random();

    public LiveQueryListenerImpl(OLiveQueryResultListener clientListener, String query, ODatabaseDocument db, Object[] iArgs) {
        this(clientListener, query, db, LiveQueryListenerImpl.toPositionalParams(iArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveQueryListenerImpl(OLiveQueryResultListener clientListener, String query, final ODatabaseDocument db, Map<Object, Object> iArgs) {
        OStatement stm;
        this.clientListener = clientListener;
        this.params = iArgs;
        if (query.trim().toLowerCase().startsWith("live ")) {
            query = query.trim().substring(5);
        }
        if (!((stm = OSQLEngine.parse(query, (ODatabaseDocumentInternal)db)) instanceof OSelectStatement)) {
            throw new OCommandExecutionException("Only SELECT statement can be used as a live query: " + query);
        }
        this.statement = (OSelectStatement)stm;
        this.validateStatement(this.statement);
        if (this.statement.getTarget().getItem().getIdentifier() != null) {
            this.className = this.statement.getTarget().getItem().getIdentifier().getStringValue();
            if (db.getClass(this.className) == null) {
                throw new OCommandExecutionException("Class " + this.className + " not found in the schema: " + query);
            }
        } else if (this.statement.getTarget().getItem().getRids() != null) {
            this.rids = this.statement.getTarget().getItem().getRids().stream().map(x -> x.toRecordId(new OResultInternal(), (OCommandContext)new OBasicCommandContext())).collect(Collectors.toList());
        }
        this.execInSeparateDatabase(new OCallable(){

            public Object call(Object iArgument) {
                return LiveQueryListenerImpl.this.execDb = ((ODatabaseDocumentInternal)db).copy();
            }
        });
        Random random = LiveQueryListenerImpl.random;
        synchronized (random) {
            this.token = LiveQueryListenerImpl.random.nextInt();
        }
        OLiveQueryHookV2.subscribe(this.token, this, (ODatabaseInternal)((Object)db));
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (iArgs != null) {
            for (Map.Entry<Object, Object> arg : iArgs.entrySet()) {
                ctx.setVariable(arg.getKey().toString(), arg.getValue());
            }
        }
    }

    private void validateStatement(OSelectStatement statement) {
        if (statement.getProjection() != null) {
            if (statement.getProjection().getItems().size() > 1) {
                throw new OCommandExecutionException("Projections cannot be used in live query " + statement);
            }
            if (statement.getProjection().getItems().get(0).isAll()) {
                throw new OCommandExecutionException("Projections cannot be used in live query " + statement);
            }
        }
        if (statement.getTarget().getItem().getIdentifier() == null && statement.getTarget().getItem().getRids() == null) {
            throw new OCommandExecutionException("Live queries can only be executed against a Class or on RIDs" + statement);
        }
        if (statement.getOrderBy() != null) {
            throw new OCommandExecutionException("Live queries do not support ORDER BY " + statement);
        }
        if (statement.getGroupBy() != null) {
            throw new OCommandExecutionException("Live queries do not support GROUP BY " + statement);
        }
        if (statement.getSkip() != null || statement.getLimit() != null) {
            throw new OCommandExecutionException("Live queries do not support SKIP/LIMIT " + statement);
        }
    }

    @Override
    public int getToken() {
        return this.token;
    }

    @Override
    public void onLiveResult(OLiveQueryHookV2.OLiveQueryOp iRecord) {
        OResult before;
        OResultInternal record;
        this.execDb.activateOnCurrentThread();
        if (iRecord.type == 3 || iRecord.type == 1) {
            record = this.copy(iRecord.after);
            if (iRecord.type == 1) {
                before = this.copy(iRecord.before);
                record.setMetadata(BEFORE_METADATA_KEY, before);
            }
        } else {
            record = this.copy(iRecord.before);
            record.setMetadata(BEFORE_METADATA_KEY, record);
        }
        if (this.filter(record)) {
            switch (iRecord.type) {
                case 2: {
                    record.setMetadata(BEFORE_METADATA_KEY, null);
                    this.clientListener.onDelete(this.execDb, record);
                    break;
                }
                case 1: {
                    before = (OResult)record.getMetadata(BEFORE_METADATA_KEY);
                    record.setMetadata(BEFORE_METADATA_KEY, null);
                    this.clientListener.onUpdate(this.execDb, before, record);
                    break;
                }
                case 3: {
                    this.clientListener.onCreate(this.execDb, record);
                }
            }
        }
    }

    private boolean filter(OResult record) {
        OWhereClause where;
        if (this.className != null) {
            Object filterClass = record.getProperty("@class");
            String recordClassName = String.valueOf(filterClass);
            if (filterClass == null) {
                return false;
            }
            if (!this.className.equalsIgnoreCase(recordClassName)) {
                OClass recordClass = this.execDb.getClass(recordClassName);
                if (recordClass == null) {
                    return false;
                }
                if (!recordClass.getName().equalsIgnoreCase(this.className) && !recordClass.isSubClassOf(this.className)) {
                    return false;
                }
            }
        }
        if (this.rids != null && this.rids.size() > 0) {
            boolean found = false;
            for (ORecordId rid : this.rids) {
                if (rid.equals(record.getIdentity().orElse(null))) {
                    found = true;
                    break;
                }
                if (!rid.equals(record.getProperty("@rid"))) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if ((where = this.statement.getWhereClause()) == null) {
            return true;
        }
        OBasicCommandContext ctx = new OBasicCommandContext();
        ctx.setInputParameters(this.params);
        return where.matchesFilters(record, (OCommandContext)ctx);
    }

    private OResultInternal copy(OResult item) {
        if (item == null) {
            return null;
        }
        OResultInternal result = new OResultInternal();
        for (String prop : item.getPropertyNames()) {
            result.setProperty(prop, item.getProperty(prop));
        }
        return result;
    }

    private static Map<Object, Object> toPositionalParams(Object[] iArgs) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int i = 0; i < iArgs.length; ++i) {
            result.put(i, iArgs[i]);
        }
        return result;
    }

    @Override
    public void onLiveResultEnd() {
        this.clientListener.onEnd(this.execDb);
    }

    protected void execInSeparateDatabase(OCallable iCallback) {
        ODatabaseDocumentInternal prevDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            iCallback.call(null);
        }
        finally {
            if (prevDb != null) {
                ODatabaseRecordThreadLocal.instance().set(prevDb);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }
}

