/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.EdgeTraversal;
import com.orientechnologies.orient.core.sql.executor.MatchEdgeTraverser;
import com.orientechnologies.orient.core.sql.executor.MatchFieldTraverser;
import com.orientechnologies.orient.core.sql.executor.MatchMultiEdgeTraverser;
import com.orientechnologies.orient.core.sql.executor.MatchReverseEdgeTraverser;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OFieldMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.OMultiMatchPathItem;
import java.util.Map;
import java.util.Optional;

public class MatchStep
extends AbstractExecutionStep {
    protected final EdgeTraversal edge;
    private OResultSet upstream;
    private OResult lastUpstreamRecord;
    private MatchEdgeTraverser traverser;
    private OResult nextResult;

    public MatchStep(OCommandContext context, EdgeTraversal edge, boolean profilingEnabled) {
        super(context, profilingEnabled);
        this.edge = edge;
    }

    @Override
    public void reset() {
        this.upstream = null;
        this.lastUpstreamRecord = null;
        this.traverser = null;
        this.nextResult = null;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        return new OResultSet(){
            private int localCount = 0;

            @Override
            public boolean hasNext() {
                if (this.localCount >= nRecords) {
                    return false;
                }
                if (MatchStep.this.nextResult == null) {
                    MatchStep.this.fetchNext(ctx, nRecords);
                }
                return MatchStep.this.nextResult != null;
            }

            @Override
            public OResult next() {
                if (this.localCount >= nRecords) {
                    throw new IllegalStateException();
                }
                if (MatchStep.this.nextResult == null) {
                    MatchStep.this.fetchNext(ctx, nRecords);
                }
                if (MatchStep.this.nextResult == null) {
                    throw new IllegalStateException();
                }
                OResult result = MatchStep.this.nextResult;
                MatchStep.this.fetchNext(ctx, nRecords);
                ++this.localCount;
                ctx.setVariable("$matched", result);
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void fetchNext(OCommandContext ctx, int nRecords) {
        boolean found;
        this.nextResult = null;
        block0: do {
            if (this.traverser != null && this.traverser.hasNext(ctx)) {
                this.nextResult = this.traverser.next(ctx);
                break;
            }
            if (this.upstream == null || !this.upstream.hasNext()) {
                this.upstream = this.getPrev().get().syncPull(ctx, nRecords);
            }
            if (!this.upstream.hasNext()) {
                return;
            }
            this.lastUpstreamRecord = this.upstream.next();
            this.traverser = this.createTraverser(this.lastUpstreamRecord);
            found = false;
            while (this.traverser.hasNext(ctx)) {
                this.nextResult = this.traverser.next(ctx);
                if (this.nextResult == null) continue;
                found = true;
                continue block0;
            }
        } while (!found);
    }

    protected MatchEdgeTraverser createTraverser(OResult lastUpstreamRecord) {
        if (this.edge.edge.item instanceof OMultiMatchPathItem) {
            return new MatchMultiEdgeTraverser(lastUpstreamRecord, this.edge);
        }
        if (this.edge.edge.item instanceof OFieldMatchPathItem) {
            return new MatchFieldTraverser(lastUpstreamRecord, this.edge);
        }
        if (this.edge.out) {
            return new MatchEdgeTraverser(lastUpstreamRecord, this.edge);
        }
        return new MatchReverseEdgeTraverser(lastUpstreamRecord, this.edge);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ MATCH ");
        if (this.edge.out) {
            result.append("     ---->\n");
        } else {
            result.append("     <----\n");
        }
        result.append(spaces);
        result.append("  ");
        result.append("{" + this.edge.edge.out.alias + "}");
        if (this.edge.edge.item instanceof OFieldMatchPathItem) {
            result.append(".");
            result.append(((OFieldMatchPathItem)this.edge.edge.item).getField());
        } else {
            result.append(this.edge.edge.item.getMethod());
        }
        result.append("{" + this.edge.edge.in.alias + "}");
        return result.toString();
    }
}

