/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import java.util.List;
import java.util.stream.Collectors;

public interface OExecutionStep {
    public String getName();

    public String getType();

    public String getTargetNode();

    public String getDescription();

    public List<OExecutionStep> getSubSteps();

    default public long getCost() {
        return -1L;
    }

    default public OResult toResult() {
        OResultInternal result = new OResultInternal();
        result.setProperty("name", this.getName());
        result.setProperty("type", this.getType());
        result.setProperty("targetNode", this.getType());
        result.setProperty("javaType", this.getClass().getName());
        result.setProperty("cost", this.getCost());
        result.setProperty("subSteps", this.getSubSteps() == null ? null : this.getSubSteps().stream().map(x -> x.toResult()).collect(Collectors.toList()));
        result.setProperty("description", this.getDescription());
        return result;
    }
}

