/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.BatchStep;
import com.orientechnologies.orient.core.sql.executor.ConvertToUpdatableResultStep;
import com.orientechnologies.orient.core.sql.executor.MoveVertexStep;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.SaveElementStep;
import com.orientechnologies.orient.core.sql.executor.SubQueryStep;
import com.orientechnologies.orient.core.sql.executor.UpdateContentStep;
import com.orientechnologies.orient.core.sql.executor.UpdateMergeStep;
import com.orientechnologies.orient.core.sql.executor.UpdateRemoveStep;
import com.orientechnologies.orient.core.sql.executor.UpdateSetStep;
import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OMoveVertexStatement;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OUpdateOperations;

public class OMoveVertexExecutionPlanner {
    private final OFromItem source;
    private final OIdentifier targetClass;
    private final OCluster targetCluster;
    private final OUpdateOperations updateOperations;
    private final OBatch batch;

    public OMoveVertexExecutionPlanner(OMoveVertexStatement oStatement) {
        this.source = oStatement.getSource();
        this.targetClass = oStatement.getTargetClass();
        this.targetCluster = oStatement.getTargetCluster();
        this.updateOperations = oStatement.getUpdateOperations();
        this.batch = oStatement.getBatch();
    }

    public OUpdateExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OUpdateExecutionPlan result = new OUpdateExecutionPlan(ctx);
        this.handleSource(result, ctx, this.source, enableProfiling);
        this.convertToModifiableResult(result, ctx, enableProfiling);
        this.handleTarget(result, this.targetClass, this.targetCluster, ctx, enableProfiling);
        this.handleOperations(result, ctx, this.updateOperations, enableProfiling);
        this.handleBatch(result, ctx, this.batch, enableProfiling);
        this.handleSave(result, ctx, enableProfiling);
        return result;
    }

    private void handleTarget(OUpdateExecutionPlan result, OIdentifier targetClass, OCluster targetCluster, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new MoveVertexStep(targetClass, targetCluster, ctx, profilingEnabled));
    }

    private void handleBatch(OUpdateExecutionPlan result, OCommandContext ctx, OBatch batch, boolean profilingEnabled) {
        if (batch != null) {
            result.chain(new BatchStep(batch, ctx, profilingEnabled));
        }
    }

    private void convertToModifiableResult(OUpdateExecutionPlan plan, OCommandContext ctx, boolean profilingEnabled) {
        plan.chain(new ConvertToUpdatableResultStep(ctx, profilingEnabled));
    }

    private void handleSave(OUpdateExecutionPlan result, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new SaveElementStep(ctx, profilingEnabled));
    }

    private void handleOperations(OUpdateExecutionPlan plan, OCommandContext ctx, OUpdateOperations op, boolean profilingEnabled) {
        if (op != null) {
            switch (op.getType()) {
                case 0: {
                    plan.chain(new UpdateSetStep(op.getUpdateItems(), ctx, profilingEnabled));
                    break;
                }
                case 6: {
                    plan.chain(new UpdateRemoveStep(op.getUpdateRemoveItems(), ctx, profilingEnabled));
                    break;
                }
                case 2: {
                    plan.chain(new UpdateMergeStep(op.getJson(), ctx, profilingEnabled));
                    break;
                }
                case 3: {
                    plan.chain(new UpdateContentStep(op.getJson(), ctx, profilingEnabled));
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    throw new OCommandExecutionException("Cannot execute with UPDATE PUT/ADD/INCREMENT new executor: " + op);
                }
            }
        }
    }

    private void handleSource(OUpdateExecutionPlan result, OCommandContext ctx, OFromItem source, boolean profilingEnabled) {
        OSelectStatement sourceStatement = new OSelectStatement(-1);
        sourceStatement.setTarget(new OFromClause(-1));
        sourceStatement.getTarget().setItem(source);
        OSelectExecutionPlanner planner = new OSelectExecutionPlanner(sourceStatement);
        result.chain(new SubQueryStep(planner.createExecutionPlan(ctx, profilingEnabled, false), ctx, ctx, profilingEnabled));
    }
}

