/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.sql.executor.OResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class OResultInternal
implements OResult {
    protected Map<String, Object> content = new LinkedHashMap<String, Object>();
    protected Map<String, Object> temporaryContent;
    protected Map<String, Object> metadata;
    protected OIdentifiable element;

    public OResultInternal() {
    }

    public OResultInternal(OIdentifiable ident) {
        this.element = ident;
    }

    public void setProperty(String name, Object value) {
        if (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        this.checkType(value);
        if (value instanceof OResult && ((OResult)value).isElement()) {
            this.content.put(name, ((OResult)value).getElement().get());
        } else {
            this.content.put(name, value);
        }
    }

    private void checkType(Object value) {
        if (value == null) {
            return;
        }
        if (OType.isSimpleType(value) || value instanceof Character) {
            return;
        }
        if (value instanceof OIdentifiable) {
            return;
        }
        if (value instanceof OResult) {
            return;
        }
        if (value instanceof Collection || value instanceof Map) {
            return;
        }
        if (value instanceof OSerializableStream || value instanceof Serializable) {
            return;
        }
        throw new IllegalArgumentException("Invalid property value for OResult: " + value + " - " + value.getClass().getName());
    }

    public void setTemporaryProperty(String name, Object value) {
        if (this.temporaryContent == null) {
            this.temporaryContent = new HashMap<String, Object>();
        }
        if (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value instanceof OResult && ((OResult)value).isElement()) {
            this.temporaryContent.put(name, ((OResult)value).getElement().get());
        } else {
            this.temporaryContent.put(name, value);
        }
    }

    public Object getTemporaryProperty(String name) {
        if (name == null || this.temporaryContent == null) {
            return null;
        }
        return this.temporaryContent.get(name);
    }

    public Set<String> getTemporaryProperties() {
        return this.temporaryContent == null ? Collections.emptySet() : this.temporaryContent.keySet();
    }

    public void removeProperty(String name) {
        this.content.remove(name);
    }

    @Override
    public <T> T getProperty(String name) {
        Object result = null;
        if (this.content.containsKey(name)) {
            result = this.wrap(this.content.get(name));
        } else if (this.element != null) {
            result = this.wrap(((ODocument)this.element.getRecord()).getProperty(name));
        }
        if (result instanceof OIdentifiable && ((OIdentifiable)result).getIdentity().isPersistent()) {
            result = ((OIdentifiable)result).getIdentity();
        }
        return (T)result;
    }

    @Override
    public OElement getElementProperty(String name) {
        Object result = null;
        if (this.content.containsKey(name)) {
            result = this.content.get(name);
        } else if (this.element != null) {
            result = ((ODocument)this.element.getRecord()).getProperty(name);
        }
        if (result instanceof OResult) {
            result = ((OResult)result).getRecord().orElse(null);
        }
        if (result instanceof ORID) {
            result = ((ORID)result).getRecord();
        }
        return result instanceof OElement ? (OElement)result : null;
    }

    @Override
    public OVertex getVertexProperty(String name) {
        Object result = null;
        if (this.content.containsKey(name)) {
            result = this.content.get(name);
        } else if (this.element != null) {
            result = ((ODocument)this.element.getRecord()).getProperty(name);
        }
        if (result instanceof OResult) {
            result = ((OResult)result).getRecord().orElse(null);
        }
        if (result instanceof ORID) {
            result = ((ORID)result).getRecord();
        }
        return result instanceof OElement ? (OVertex)((OElement)result).asVertex().orElse(null) : null;
    }

    @Override
    public OEdge getEdgeProperty(String name) {
        Object result = null;
        if (this.content.containsKey(name)) {
            result = this.content.get(name);
        } else if (this.element != null) {
            result = ((ODocument)this.element.getRecord()).getProperty(name);
        }
        if (result instanceof OResult) {
            result = ((OResult)result).getRecord().orElse(null);
        }
        if (result instanceof ORID) {
            result = ((ORID)result).getRecord();
        }
        return result instanceof OElement ? (OEdge)((OElement)result).asEdge().orElse(null) : null;
    }

    @Override
    public OBlob getBlobProperty(String name) {
        Object result = null;
        if (this.content.containsKey(name)) {
            result = this.content.get(name);
        } else if (this.element != null) {
            result = ((ODocument)this.element.getRecord()).getProperty(name);
        }
        if (result instanceof OResult) {
            result = ((OResult)result).getRecord().orElse(null);
        }
        if (result instanceof ORID) {
            result = ((ORID)result).getRecord();
        }
        return result instanceof OBlob ? (OBlob)result : null;
    }

    private Object wrap(Object input) {
        if (input instanceof OElement && !((OElement)input).getIdentity().isValid()) {
            OResultInternal result = new OResultInternal();
            OElement elem = (OElement)input;
            for (String prop : elem.getPropertyNames()) {
                result.setProperty(prop, elem.getProperty(prop));
            }
            elem.getSchemaType().ifPresent(x -> result.setProperty("@class", x.getName()));
            return result;
        }
        if (this.isEmbeddedList(input)) {
            return ((List)input).stream().map(this::wrap).collect(Collectors.toList());
        }
        if (this.isEmbeddedSet(input)) {
            return ((Set)input).stream().map(this::wrap).collect(Collectors.toSet());
        }
        if (this.isEmbeddedMap(input)) {
            HashMap result = new HashMap();
            for (Map.Entry o : ((Map)input).entrySet()) {
                result.put(o.getKey(), this.wrap(o.getValue()));
            }
            return result;
        }
        return input;
    }

    private boolean isEmbeddedSet(Object input) {
        return OType.getTypeByValue(input) == OType.EMBEDDEDSET && input instanceof Set;
    }

    private boolean isEmbeddedMap(Object input) {
        return OType.getTypeByValue(input) == OType.EMBEDDEDMAP && input instanceof Map;
    }

    private boolean isEmbeddedList(Object input) {
        return OType.getTypeByValue(input) == OType.EMBEDDEDLIST && input instanceof List;
    }

    @Override
    public Set<String> getPropertyNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (this.element != null && !(this.element instanceof ORecordBytes)) {
            result.addAll(((ODocument)this.element.getRecord()).getPropertyNames());
        }
        result.addAll(this.content.keySet());
        return result;
    }

    @Override
    public boolean hasProperty(String propName) {
        if (this.element != null && ((ODocument)this.element.getRecord()).containsField(propName)) {
            return true;
        }
        return this.content.containsKey(propName);
    }

    @Override
    public boolean isElement() {
        if (this.element == null) {
            return false;
        }
        if (this.element instanceof OElement) {
            return true;
        }
        return this.element.getRecord() instanceof OElement;
    }

    @Override
    public Optional<OElement> getElement() {
        if (this.element == null || this.element instanceof OElement) {
            return Optional.ofNullable((OElement)this.element);
        }
        Object rec = this.element.getRecord();
        if (rec instanceof OElement) {
            return Optional.ofNullable((OElement)rec);
        }
        return Optional.empty();
    }

    @Override
    public OElement toElement() {
        if (this.isElement()) {
            return this.getElement().get();
        }
        ODocument doc = new ODocument();
        for (String s : this.getPropertyNames()) {
            if (s == null) continue;
            if (s.equalsIgnoreCase("@rid")) {
                Object newRid = this.getProperty(s);
                if (!(newRid instanceof OIdentifiable)) continue;
                newRid = ((OIdentifiable)newRid).getIdentity();
                ORecordId oldId = (ORecordId)doc.getIdentity();
                oldId.setClusterId(((ORID)newRid).getClusterId());
                oldId.setClusterPosition(((ORID)newRid).getClusterPosition());
                continue;
            }
            if (s.equalsIgnoreCase("@version")) {
                Object v = this.getProperty(s);
                if (!(v instanceof Number)) continue;
                ORecordInternal.setVersion(doc, ((Number)v).intValue());
                continue;
            }
            if (s.equalsIgnoreCase("@class")) {
                doc.setClassName((String)this.getProperty(s));
                continue;
            }
            doc.setProperty(s, this.convertToElement(this.getProperty(s)));
        }
        return doc;
    }

    @Override
    public Optional<ORID> getIdentity() {
        if (this.element != null) {
            return Optional.of(this.element.getIdentity());
        }
        return Optional.empty();
    }

    @Override
    public boolean isProjection() {
        return this.element == null;
    }

    @Override
    public Optional<ORecord> getRecord() {
        if (this.element == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.element.getRecord());
    }

    @Override
    public boolean isBlob() {
        return this.element != null && this.element.getRecord() instanceof OBlob;
    }

    @Override
    public Optional<OBlob> getBlob() {
        if (this.isBlob()) {
            return Optional.ofNullable(this.element.getRecord());
        }
        return Optional.empty();
    }

    @Override
    public Object getMetadata(String key) {
        if (key == null) {
            return null;
        }
        return this.metadata == null ? null : this.metadata.get(key);
    }

    public void setMetadata(String key, Object value) {
        if (key == null) {
            return;
        }
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, value);
    }

    public void clearMetadata() {
        this.metadata = null;
    }

    public void removeMetadata(String key) {
        if (key == null || this.metadata == null) {
            return;
        }
        this.metadata.remove(key);
    }

    public void addMetadata(Map<String, Object> values) {
        if (values == null) {
            return;
        }
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.putAll(values);
    }

    @Override
    public Set<String> getMetadataKeys() {
        return this.metadata == null ? Collections.emptySet() : this.metadata.keySet();
    }

    private Object convertToElement(Object property) {
        if (property instanceof OResult) {
            return ((OResult)property).toElement();
        }
        if (property instanceof List) {
            return ((List)property).stream().map(x -> this.convertToElement(x)).collect(Collectors.toList());
        }
        if (property instanceof Set) {
            return ((Set)property).stream().map(x -> this.convertToElement(x)).collect(Collectors.toSet());
        }
        if (property instanceof Map) {
            HashMap result = new HashMap();
            Map prop = (Map)property;
            for (Map.Entry o : prop.entrySet()) {
                result.put(o.getKey(), this.convertToElement(o.getValue()));
            }
        }
        return property;
    }

    public void setElement(OIdentifiable element) {
        this.element = element instanceof OElement ? element : (element instanceof OIdentifiable ? element.getRecord() : element);
        if (element instanceof OContextualRecordId) {
            this.addMetadata(((OContextualRecordId)element).getContext());
        }
    }

    public String toString() {
        if (this.element != null) {
            return this.element.toString();
        }
        return "{\n" + this.content.entrySet().stream().map(x -> (String)x.getKey() + ": " + x.getValue()).reduce("", (a, b) -> a + b + "\n") + "}\n";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OResultInternal)) {
            return false;
        }
        OResultInternal resultObj = (OResultInternal)obj;
        if (this.element != null) {
            if (!resultObj.getElement().isPresent()) {
                return false;
            }
            return this.element.equals(resultObj.getElement().get());
        }
        if (resultObj.getElement().isPresent()) {
            return false;
        }
        return this.content.equals(resultObj.content);
    }

    public int hashCode() {
        if (this.element != null) {
            return this.element.hashCode();
        }
        return this.content.hashCode();
    }

    public void bindToCache(ODatabaseDocumentInternal db) {
        if (this.isRecord()) {
            Object rec = this.element.getRecord();
            ORecord cached = db.getLocalCache().findRecord(rec.getIdentity());
            if (cached != null) {
                if (!cached.isDirty()) {
                    cached.fromStream(rec.toStream());
                }
                this.element = cached;
            } else {
                db.getLocalCache().updateRecord((ORecord)rec);
            }
        }
    }
}

