/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.EdgeTraversal;
import com.orientechnologies.orient.core.sql.executor.MatchEdgeTraverser;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import java.util.ArrayList;

public class OptionalMatchEdgeTraverser
extends MatchEdgeTraverser {
    public static final OResult EMPTY_OPTIONAL = new OResultInternal();

    public OptionalMatchEdgeTraverser(OResult lastUpstreamRecord, EdgeTraversal edge) {
        super(lastUpstreamRecord, edge);
    }

    @Override
    protected void init(OCommandContext ctx) {
        if (this.downstream == null) {
            super.init(ctx);
            if (!this.downstream.hasNext()) {
                ArrayList<OResult> x = new ArrayList<OResult>();
                x.add(EMPTY_OPTIONAL);
                this.downstream = x.iterator();
            }
        }
    }

    @Override
    public OResult next(OCommandContext ctx) {
        this.init(ctx);
        if (!this.downstream.hasNext()) {
            throw new IllegalStateException();
        }
        String endPointAlias = this.getEndpointAlias();
        Object prevValue = this.sourceRecord.getProperty(endPointAlias);
        OResultInternal next = (OResultInternal)this.downstream.next();
        if (OptionalMatchEdgeTraverser.isEmptyOptional(prevValue)) {
            return this.sourceRecord;
        }
        if (!OptionalMatchEdgeTraverser.isEmptyOptional(next) && prevValue != null && !this.equals(prevValue, next.getElement().get())) {
            return null;
        }
        OResultInternal result = new OResultInternal();
        for (String prop : this.sourceRecord.getPropertyNames()) {
            result.setProperty(prop, this.sourceRecord.getProperty(prop));
        }
        result.setProperty(endPointAlias, next.getElement().map(x -> this.toResult((OIdentifiable)x)).orElse(null));
        return result;
    }

    public static boolean isEmptyOptional(Object elem) {
        if (elem == EMPTY_OPTIONAL) {
            return true;
        }
        return elem instanceof OResult && EMPTY_OPTIONAL == ((OResult)elem).getElement().orElse(null);
    }
}

