/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ParallelExecStep
extends AbstractExecutionStep {
    private final List<OInternalExecutionPlan> subExecutionPlans;
    private int current = 0;
    private OResultSet currentResultSet = null;

    public ParallelExecStep(List<OInternalExecutionPlan> subExecuitonPlans, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.subExecutionPlans = subExecuitonPlans;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){
            private int localCount = 0;

            @Override
            public boolean hasNext() {
                if (this.localCount >= nRecords) {
                    return false;
                }
                while (ParallelExecStep.this.currentResultSet == null || !ParallelExecStep.this.currentResultSet.hasNext()) {
                    ParallelExecStep.this.fetchNext(ctx, nRecords);
                    if (ParallelExecStep.this.currentResultSet != null) continue;
                    return false;
                }
                return true;
            }

            @Override
            public OResult next() {
                if (this.localCount >= nRecords) {
                    throw new IllegalStateException();
                }
                while (ParallelExecStep.this.currentResultSet == null || !ParallelExecStep.this.currentResultSet.hasNext()) {
                    ParallelExecStep.this.fetchNext(ctx, nRecords);
                    if (ParallelExecStep.this.currentResultSet != null) continue;
                    throw new IllegalStateException();
                }
                ++this.localCount;
                return ParallelExecStep.this.currentResultSet.next();
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    void fetchNext(OCommandContext ctx, int nRecords) {
        do {
            if (this.current >= this.subExecutionPlans.size()) {
                this.currentResultSet = null;
                return;
            }
            this.currentResultSet = this.subExecutionPlans.get(this.current).fetchNext(nRecords);
            if (this.currentResultSet.hasNext()) continue;
            ++this.current;
        } while (!this.currentResultSet.hasNext());
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = "";
        String ind = OExecutionStepInternal.getIndent(depth, indent);
        int[] blockSizes = new int[this.subExecutionPlans.size()];
        for (int i = 0; i < this.subExecutionPlans.size(); ++i) {
            OInternalExecutionPlan currentPlan = this.subExecutionPlans.get(this.subExecutionPlans.size() - 1 - i);
            String partial = currentPlan.prettyPrint(0, indent);
            String[] partials = partial.split("\n");
            blockSizes[this.subExecutionPlans.size() - 1 - i] = partials.length + 2;
            result = "+-------------------------\n" + result;
            for (int j = 0; j < partials.length; ++j) {
                String p = partials[partials.length - 1 - j];
                result = result.length() > 0 ? this.appendPipe(p) + "\n" + result : this.appendPipe(p);
            }
            result = "+-------------------------\n" + result;
        }
        result = this.addArrows(result, blockSizes);
        result = result + this.foot(blockSizes);
        result = ind + result;
        result = result.replaceAll("\n", "\n" + ind);
        result = this.head(depth, indent, this.subExecutionPlans.size()) + "\n" + result;
        return result;
    }

    private String addArrows(String input, int[] blockSizes) {
        StringBuilder result = new StringBuilder();
        String[] rows = input.split("\n");
        int rowNum = 0;
        for (int block = 0; block < blockSizes.length; ++block) {
            int blockSize = blockSizes[block];
            for (int subRow = 0; subRow < blockSize; ++subRow) {
                for (int col = 0; col < blockSizes.length * 3; ++col) {
                    if (this.isHorizontalRow(col, subRow, block, blockSize)) {
                        result.append("-");
                        continue;
                    }
                    if (this.isPlus(col, subRow, block, blockSize)) {
                        result.append("+");
                        continue;
                    }
                    if (this.isVerticalRow(col, subRow, block, blockSize)) {
                        result.append("|");
                        continue;
                    }
                    result.append(" ");
                }
                result.append(rows[rowNum]);
                result.append("\n");
                ++rowNum;
            }
        }
        return result.toString();
    }

    private boolean isHorizontalRow(int col, int subRow, int block, int blockSize) {
        if (col < block * 3 + 2) {
            return false;
        }
        return subRow == blockSize / 2;
    }

    private boolean isPlus(int col, int subRow, int block, int blockSize) {
        return col == block * 3 + 1 && subRow == blockSize / 2;
    }

    private boolean isVerticalRow(int col, int subRow, int block, int blockSize) {
        return col == block * 3 + 1 ? subRow > blockSize / 2 : col < block * 3 + 1 && col % 3 == 1;
    }

    private String head(int depth, int indent, int nItems) {
        String ind = OExecutionStepInternal.getIndent(depth, indent);
        return ind + "+ PARALLEL";
    }

    private String foot(int[] blockSizes) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < blockSizes.length; ++i) {
            result.append(" V ");
        }
        return result.toString();
    }

    private String spaces(int num) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            result.append(" ");
        }
        return result.toString();
    }

    private String appendPipe(String p) {
        return "| " + p;
    }

    @Override
    public List<OExecutionPlan> getSubExecutionPlans() {
        return this.subExecutionPlans;
    }

    @Override
    public boolean canBeCached() {
        for (OInternalExecutionPlan plan : this.subExecutionPlans) {
            if (plan.canBeCached()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new ParallelExecStep(this.subExecutionPlans.stream().map(x -> x.copy(ctx)).collect(Collectors.toList()), ctx, this.profilingEnabled);
    }
}

