/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdatableResult;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import java.util.Map;
import java.util.Optional;

public class SetDocumentClassStep
extends AbstractExecutionStep {
    private final String targetClass;

    public SetDocumentClassStep(OIdentifier targetClass, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.targetClass = targetClass.getStringValue();
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            @Override
            public OResult next() {
                Object element;
                OResult result = upstream.next();
                if (result.isElement() && (element = result.getElement().get().getRecord()) instanceof ODocument) {
                    ODocument doc = (ODocument)element;
                    doc.setClassName(SetDocumentClassStep.this.targetClass);
                    if (!(result instanceof OResultInternal)) {
                        result = new OUpdatableResult(doc);
                    } else {
                        ((OResultInternal)result).setElement(doc);
                    }
                }
                return result;
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ SET CLASS\n");
        result.append(spaces);
        result.append("  ");
        result.append(this.targetClass);
        return result.toString();
    }
}

