/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdatableResult;
import java.util.Map;
import java.util.Optional;

public class UnwrapPreviousValueStep
extends AbstractExecutionStep {
    private long cost = 0L;

    public UnwrapPreviousValueStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = ((OExecutionStepInternal)this.prev.get()).syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            @Override
            public OResult next() {
                long begin = UnwrapPreviousValueStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    OResult prevResult = upstream.next();
                    if (prevResult instanceof OUpdatableResult) {
                        prevResult = ((OUpdatableResult)prevResult).previousValue;
                        if (prevResult == null) {
                            throw new OCommandExecutionException("Invalid status of record: no previous value available");
                        }
                        OResult oResult = prevResult;
                        return oResult;
                    }
                    throw new OCommandExecutionException("Invalid status of record: no previous value available");
                }
                finally {
                    if (UnwrapPreviousValueStep.this.profilingEnabled) {
                        UnwrapPreviousValueStep.this.cost = UnwrapPreviousValueStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ UNWRAP PREVIOUS VALUE";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

