/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdatableResult;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.List;

public class UpsertStep
extends AbstractExecutionStep {
    private final OFromClause commandTarget;
    private final OWhereClause initialFilter;
    private boolean applied = false;

    public UpsertStep(OFromClause target, OWhereClause where, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.commandTarget = target;
        this.initialFilter = where;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        if (this.applied) {
            return this.getPrev().get().syncPull(ctx, nRecords);
        }
        this.applied = true;
        OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        if (upstream.hasNext()) {
            return upstream;
        }
        OInternalResultSet result = new OInternalResultSet();
        result.add(this.createNewRecord(this.commandTarget, this.initialFilter));
        return result;
    }

    private OResult createNewRecord(OFromClause commandTarget, OWhereClause initialFilter) {
        if (commandTarget.getItem().getIdentifier() == null) {
            throw new OCommandExecutionException("Cannot execute UPSERT on target '" + commandTarget + "'");
        }
        ODocument doc = new ODocument(commandTarget.getItem().getIdentifier().getStringValue());
        OUpdatableResult result = new OUpdatableResult(doc);
        if (initialFilter != null) {
            this.setContent(result, initialFilter);
        }
        return result;
    }

    private void setContent(OResultInternal doc, OWhereClause initialFilter) {
        List<OAndBlock> flattened = initialFilter.flatten();
        if (flattened.size() == 0) {
            return;
        }
        if (flattened.size() > 1) {
            throw new OCommandExecutionException("Cannot UPSERT on OR conditions");
        }
        OAndBlock andCond = flattened.get(0);
        for (OBooleanExpression condition : andCond.getSubBlocks()) {
            condition.transformToUpdateItem().ifPresent(x -> x.applyUpdate(doc, this.ctx));
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ INSERT (upsert, if needed)\n");
        result.append(spaces);
        result.append("  target: ");
        result.append(this.commandTarget);
        result.append("\n");
        result.append(spaces);
        result.append("  content: ");
        result.append(this.initialFilter);
        return result.toString();
    }
}

