/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.graph;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.functions.graph.HeuristicFormula;
import com.orientechnologies.orient.core.sql.functions.graph.OSQLFunctionHeuristicPathFinderAbstract;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class OSQLFunctionAstar
extends OSQLFunctionHeuristicPathFinderAbstract {
    public static final String NAME = "astar";
    private String paramWeightFieldName = "weight";
    private long currentDepth = 0L;
    protected Set<OVertex> closedSet = new HashSet<OVertex>();
    protected Map<OVertex, OVertex> cameFrom = new HashMap<OVertex, OVertex>();
    protected Map<OVertex, Double> gScore = new HashMap<OVertex, Double>();
    protected Map<OVertex, Double> fScore = new HashMap<OVertex, Double>();
    protected PriorityQueue<OVertex> open = new PriorityQueue<OVertex>(1, new Comparator<OVertex>(){

        @Override
        public int compare(OVertex nodeA, OVertex nodeB) {
            return Double.compare(OSQLFunctionAstar.this.fScore.get(nodeA), OSQLFunctionAstar.this.fScore.get(nodeB));
        }
    });

    public OSQLFunctionAstar() {
        super(NAME, 3, 4);
    }

    @Override
    public LinkedList<OVertex> execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        OElement elem;
        OElement elem2;
        this.context = iContext;
        OSQLFunctionAstar context = this;
        ORecord record = iCurrentRecord != null ? (ORecord)iCurrentRecord.getRecord() : null;
        Object source = iParams[0];
        if (OMultiValue.isMultiValue(source)) {
            if (OMultiValue.getSize(source) > 1) {
                throw new IllegalArgumentException("Only one sourceVertex is allowed");
            }
            if ((source = OMultiValue.getFirstValue(source)) instanceof OResult && ((OResult)source).isElement()) {
                source = ((OResult)source).getElement().get();
            }
        }
        if ((source = OSQLHelper.getValue(source, record, iContext)) instanceof OIdentifiable) {
            elem2 = (OElement)((OIdentifiable)source).getRecord();
            if (!elem2.isVertex()) {
                throw new IllegalArgumentException("The sourceVertex must be a vertex record");
            }
        } else {
            throw new IllegalArgumentException("The sourceVertex must be a vertex record");
        }
        this.paramSourceVertex = elem2.asVertex().get();
        Object dest = iParams[1];
        if (OMultiValue.isMultiValue(dest)) {
            if (OMultiValue.getSize(dest) > 1) {
                throw new IllegalArgumentException("Only one destinationVertex is allowed");
            }
            if ((dest = OMultiValue.getFirstValue(dest)) instanceof OResult && ((OResult)dest).isElement()) {
                dest = ((OResult)dest).getElement().get();
            }
        }
        if ((dest = OSQLHelper.getValue(dest, record, iContext)) instanceof OIdentifiable) {
            elem = (OElement)((OIdentifiable)dest).getRecord();
            if (!elem.isVertex()) {
                throw new IllegalArgumentException("The destinationVertex must be a vertex record");
            }
        } else {
            throw new IllegalArgumentException("The destinationVertex must be a vertex record");
        }
        this.paramDestinationVertex = elem.asVertex().get();
        this.paramWeightFieldName = OIOUtils.getStringContent(iParams[2]);
        if (iParams.length > 3) {
            this.bindAdditionalParams(iParams[3], context);
        }
        iContext.setVariable("getNeighbors", 0);
        if (this.paramSourceVertex == null || this.paramDestinationVertex == null) {
            return new LinkedList<OVertex>();
        }
        return this.internalExecute(iContext, iContext.getDatabase());
    }

    private LinkedList<OVertex> internalExecute(OCommandContext iContext, ODatabase graph) {
        OVertex start = this.paramSourceVertex;
        OVertex goal = this.paramDestinationVertex;
        this.open.add(start);
        this.gScore.put(start, 0.0);
        this.fScore.put(start, this.getHeuristicCost(start, null, goal, iContext));
        while (!this.open.isEmpty()) {
            OVertex current = this.open.poll();
            if (this.paramEmptyIfMaxDepth.booleanValue() && this.currentDepth >= this.paramMaxDepth) {
                this.route.clear();
                return this.getPath();
            }
            if (current.getIdentity().equals(goal.getIdentity()) || this.currentDepth >= this.paramMaxDepth) {
                while (current != null) {
                    this.route.add(0, current);
                    current = this.cameFrom.get(current);
                }
                return this.getPath();
            }
            this.closedSet.add(current);
            for (OEdge neighborEdge : this.getNeighborEdges(current)) {
                OVertex neighbor = this.getNeighbor(current, neighborEdge, graph);
                if (this.closedSet.contains(neighbor)) continue;
                double tentativeGScore = this.gScore.get(current) + this.getDistance(neighborEdge);
                boolean contains = this.open.contains(neighbor);
                if (contains && !(tentativeGScore < this.gScore.get(neighbor))) continue;
                this.gScore.put(neighbor, tentativeGScore);
                this.fScore.put(neighbor, tentativeGScore + this.getHeuristicCost(neighbor, current, goal, iContext));
                if (contains) {
                    this.open.remove(neighbor);
                }
                this.open.offer(neighbor);
                this.cameFrom.put(neighbor, current);
            }
            ++this.currentDepth;
        }
        return this.getPath();
    }

    private OVertex getNeighbor(OVertex current, OEdge neighborEdge, ODatabase graph) {
        if (neighborEdge.getFrom().equals(current)) {
            return this.toVertex(neighborEdge.getTo());
        }
        return this.toVertex(neighborEdge.getFrom());
    }

    private OVertex toVertex(OIdentifiable outVertex) {
        if (outVertex == null) {
            return null;
        }
        if (!(outVertex instanceof OElement)) {
            outVertex = outVertex.getRecord();
        }
        return ((OElement)outVertex).asVertex().orElse(null);
    }

    protected Set<OEdge> getNeighborEdges(OVertex node) {
        this.context.incrementVariable("getNeighbors");
        HashSet<OEdge> neighbors = new HashSet<OEdge>();
        if (node != null) {
            for (OEdge v : node.getEdges(this.paramDirection, this.paramEdgeTypeNames)) {
                OEdge ov = v;
                if (ov == null) continue;
                neighbors.add(ov);
            }
        }
        return neighbors;
    }

    private void bindAdditionalParams(Object additionalParams, OSQLFunctionAstar ctx) {
        if (additionalParams == null) {
            return;
        }
        Map<String, Object> mapParams = null;
        if (additionalParams instanceof Map) {
            mapParams = (Map<String, Object>)additionalParams;
        } else if (additionalParams instanceof OIdentifiable) {
            mapParams = ((ODocument)((OIdentifiable)additionalParams).getRecord()).toMap();
        }
        if (mapParams != null) {
            ctx.paramEdgeTypeNames = this.stringArray(mapParams.get("edgeTypeNames"));
            ctx.paramVertexAxisNames = this.stringArray(mapParams.get("vertexAxisNames"));
            if (mapParams.get("direction") != null) {
                ctx.paramDirection = mapParams.get("direction") instanceof String ? ODirection.valueOf(this.stringOrDefault(mapParams.get("direction"), "OUT").toUpperCase(Locale.ENGLISH)) : (ODirection)((Object)mapParams.get("direction"));
            }
            ctx.paramParallel = this.booleanOrDefault(mapParams.get("parallel"), false);
            ctx.paramMaxDepth = this.longOrDefault(mapParams.get("maxDepth"), ctx.paramMaxDepth);
            ctx.paramEmptyIfMaxDepth = this.booleanOrDefault(mapParams.get("emptyIfMaxDepth"), ctx.paramEmptyIfMaxDepth);
            ctx.paramTieBreaker = this.booleanOrDefault(mapParams.get("tieBreaker"), ctx.paramTieBreaker);
            ctx.paramDFactor = this.doubleOrDefault(mapParams.get("dFactor"), ctx.paramDFactor);
            if (mapParams.get("heuristicFormula") != null) {
                ctx.paramHeuristicFormula = mapParams.get("heuristicFormula") instanceof String ? HeuristicFormula.valueOf(this.stringOrDefault(mapParams.get("heuristicFormula"), "MANHATAN").toUpperCase(Locale.ENGLISH)) : (HeuristicFormula)((Object)mapParams.get("heuristicFormula"));
            }
            ctx.paramCustomHeuristicFormula = this.stringOrDefault(mapParams.get("customHeuristicFormula"), "");
        }
    }

    @Override
    public String getSyntax() {
        return "astar(<sourceVertex>, <destinationVertex>, <weightEdgeFieldName>, [<options>]) \n // options  : {direction:\"OUT\",edgeTypeNames:[] , vertexAxisNames:[] , parallel : false , tieBreaker:true,maxDepth:99999,dFactor:1.0,customHeuristicFormula:'custom_Function_Name_here'  }";
    }

    @Override
    public Object getResult() {
        return this.getPath();
    }

    @Override
    protected double getDistance(OVertex node, OVertex parent, OVertex target) {
        Object fieldValue;
        Iterator<OEdge> edges = node.getEdges(this.paramDirection).iterator();
        OElement e = null;
        while (edges.hasNext()) {
            OEdge next = edges.next();
            if (!next.getFrom().equals(target) && !next.getTo().equals(target)) continue;
            e = next;
            break;
        }
        if (e != null && (fieldValue = e.getProperty(this.paramWeightFieldName)) != null) {
            if (fieldValue instanceof Float) {
                return ((Float)fieldValue).floatValue();
            }
            if (fieldValue instanceof Number) {
                return ((Number)fieldValue).doubleValue();
            }
        }
        return 0.0;
    }

    protected double getDistance(OEdge edge) {
        Object fieldValue;
        if (edge != null && (fieldValue = edge.getProperty(this.paramWeightFieldName)) != null) {
            if (fieldValue instanceof Float) {
                return ((Float)fieldValue).floatValue();
            }
            if (fieldValue instanceof Number) {
                return ((Number)fieldValue).doubleValue();
            }
        }
        return 0.0;
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    protected double getHeuristicCost(OVertex node, OVertex parent, OVertex target, OCommandContext iContext) {
        double hresult = 0.0;
        if (this.paramVertexAxisNames.length == 0) {
            return hresult;
        }
        if (this.paramVertexAxisNames.length == 1) {
            double n = this.doubleOrDefault(node.getProperty(this.paramVertexAxisNames[0]), 0.0);
            double g = this.doubleOrDefault(target.getProperty(this.paramVertexAxisNames[0]), 0.0);
            hresult = this.getSimpleHeuristicCost(n, g, this.paramDFactor);
        } else if (this.paramVertexAxisNames.length == 2) {
            if (parent == null) {
                parent = node;
            }
            double sx = this.doubleOrDefault(this.paramSourceVertex.getProperty(this.paramVertexAxisNames[0]), 0.0);
            double sy = this.doubleOrDefault(this.paramSourceVertex.getProperty(this.paramVertexAxisNames[1]), 0.0);
            double nx = this.doubleOrDefault(node.getProperty(this.paramVertexAxisNames[0]), 0.0);
            double ny = this.doubleOrDefault(node.getProperty(this.paramVertexAxisNames[1]), 0.0);
            double px = this.doubleOrDefault(parent.getProperty(this.paramVertexAxisNames[0]), 0.0);
            double py = this.doubleOrDefault(parent.getProperty(this.paramVertexAxisNames[1]), 0.0);
            double gx = this.doubleOrDefault(target.getProperty(this.paramVertexAxisNames[0]), 0.0);
            double gy = this.doubleOrDefault(target.getProperty(this.paramVertexAxisNames[1]), 0.0);
            switch (this.paramHeuristicFormula) {
                case MANHATAN: {
                    hresult = this.getManhatanHeuristicCost(nx, ny, gx, gy, this.paramDFactor);
                    break;
                }
                case MAXAXIS: {
                    hresult = this.getMaxAxisHeuristicCost(nx, ny, gx, gy, this.paramDFactor);
                    break;
                }
                case DIAGONAL: {
                    hresult = this.getDiagonalHeuristicCost(nx, ny, gx, gy, this.paramDFactor);
                    break;
                }
                case EUCLIDEAN: {
                    hresult = this.getEuclideanHeuristicCost(nx, ny, gx, gy, this.paramDFactor);
                    break;
                }
                case EUCLIDEANNOSQR: {
                    hresult = this.getEuclideanNoSQRHeuristicCost(nx, ny, gx, gy, this.paramDFactor);
                    break;
                }
                case CUSTOM: {
                    hresult = this.getCustomHeuristicCost(this.paramCustomHeuristicFormula, this.paramVertexAxisNames, this.paramSourceVertex, this.paramDestinationVertex, node, parent, this.currentDepth, this.paramDFactor, iContext);
                }
            }
            if (this.paramTieBreaker.booleanValue()) {
                hresult = this.getTieBreakingHeuristicCost(px, py, sx, sy, gx, gy, hresult);
            }
        } else {
            HashMap<String, Double> sList = new HashMap<String, Double>();
            HashMap<String, Double> cList = new HashMap<String, Double>();
            HashMap<String, Double> pList = new HashMap<String, Double>();
            HashMap<String, Double> gList = new HashMap<String, Double>();
            parent = parent == null ? node : parent;
            for (int i = 0; i < this.paramVertexAxisNames.length; ++i) {
                Double s = this.doubleOrDefault(this.paramSourceVertex.getProperty(this.paramVertexAxisNames[i]), 0.0);
                Double c = this.doubleOrDefault(node.getProperty(this.paramVertexAxisNames[i]), 0.0);
                Double g = this.doubleOrDefault(target.getProperty(this.paramVertexAxisNames[i]), 0.0);
                Double p = this.doubleOrDefault(parent.getProperty(this.paramVertexAxisNames[i]), 0.0);
                if (s != null) {
                    sList.put(this.paramVertexAxisNames[i], s);
                }
                if (c != null) {
                    cList.put(this.paramVertexAxisNames[i], s);
                }
                if (g != null) {
                    gList.put(this.paramVertexAxisNames[i], g);
                }
                if (p == null) continue;
                pList.put(this.paramVertexAxisNames[i], p);
            }
            switch (this.paramHeuristicFormula) {
                case MANHATAN: {
                    hresult = this.getManhatanHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, this.paramDFactor);
                    break;
                }
                case MAXAXIS: {
                    hresult = this.getMaxAxisHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, this.paramDFactor);
                    break;
                }
                case DIAGONAL: {
                    hresult = this.getDiagonalHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, this.paramDFactor);
                    break;
                }
                case EUCLIDEAN: {
                    hresult = this.getEuclideanHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, this.paramDFactor);
                    break;
                }
                case EUCLIDEANNOSQR: {
                    hresult = this.getEuclideanNoSQRHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, this.paramDFactor);
                    break;
                }
                case CUSTOM: {
                    hresult = this.getCustomHeuristicCost(this.paramCustomHeuristicFormula, this.paramVertexAxisNames, this.paramSourceVertex, this.paramDestinationVertex, node, parent, this.currentDepth, this.paramDFactor, iContext);
                }
            }
            if (this.paramTieBreaker.booleanValue()) {
                hresult = this.getTieBreakingHeuristicCost(this.paramVertexAxisNames, sList, cList, pList, gList, this.currentDepth, hresult);
            }
        }
        return hresult;
    }

    @Override
    protected boolean isVariableEdgeWeight() {
        return true;
    }
}

