/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.method.sequence;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;

public class OSQLMethodReset
extends OAbstractSQLMethod {
    public static final String NAME = "reset";

    public OSQLMethodReset() {
        super(NAME, 0, 0);
    }

    @Override
    public String getSyntax() {
        return "reset()";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        if (iThis == null) {
            throw new OCommandSQLParsingException("Method 'reset()' can be invoked only on OSequence instances, while NULL was found");
        }
        if (!(iThis instanceof OSequence)) {
            throw new OCommandSQLParsingException("Method 'reset()' can be invoked only on OSequence instances, while '" + iThis.getClass() + "' was found");
        }
        try {
            return ((OSequence)iThis).reset();
        }
        catch (ODatabaseException exc) {
            String message = "Unable to execute command: " + exc.getMessage();
            OLogManager.instance().error(this, message, exc, new Object[]{null});
            throw new OCommandExecutionException(message);
        }
    }
}

