/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OAlterClusterStatement
extends ODDLStatement {
    protected OIdentifier name;
    protected boolean starred = false;
    protected OIdentifier attributeName;
    protected OExpression attributeValue;

    public OAlterClusterStatement(int id) {
        super(id);
    }

    public OAlterClusterStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("ALTER CLUSTER ");
        this.name.toString(params, builder);
        if (this.starred) {
            builder.append("*");
        }
        builder.append(" ");
        this.attributeName.toString(params, builder);
        builder.append(" ");
        this.attributeValue.toString(params, builder);
    }

    @Override
    public OAlterClusterStatement copy() {
        OAlterClusterStatement result = new OAlterClusterStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.attributeName = this.attributeName == null ? null : this.attributeName.copy();
        result.starred = this.starred;
        result.attributeValue = this.attributeValue == null ? null : this.attributeValue.copy();
        return result;
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        OInternalResultSet result = new OInternalResultSet();
        List<Integer> clustersToUpdate = this.getClusters(ctx);
        Object finalValue = this.attributeValue.execute((OIdentifiable)null, ctx);
        OCluster.ATTRIBUTES attribute = Arrays.stream(OCluster.ATTRIBUTES.values()).filter(e -> e.name().equalsIgnoreCase(this.notNull(this.attributeName.getStringValue()))).findAny().orElseThrow(() -> new UnsupportedOperationException("Unknown class attribute '" + this.attributeName + "'. Supported attributes are: " + this.noDeprecatedValues(OCluster.ATTRIBUTES.values())));
        OStorage storage = ((ODatabaseDocumentInternal)ctx.getDatabase()).getStorage();
        for (int clusterId : clustersToUpdate) {
            if (this.attributeName.getStringValue().equalsIgnoreCase("status") || this.attributeName.getStringValue().equalsIgnoreCase("name")) {
                OAlterClusterStatement.getDatabase().getMetadata().getCommandCache().invalidateResultsOfCluster(storage.getPhysicalClusterNameById(clusterId));
            }
            storage.setClusterAttribute(clusterId, attribute, finalValue);
            OResultInternal resultItem = new OResultInternal();
            resultItem.setProperty("cluster", storage.getClusterName(clusterId));
            result.add(resultItem);
        }
        return result;
    }

    private List<OCluster.ATTRIBUTES> noDeprecatedValues(OCluster.ATTRIBUTES[] values) {
        return Arrays.stream(values).filter(value -> {
            try {
                Field field = OCluster.ATTRIBUTES.class.getField(value.name());
                return !field.isAnnotationPresent(Deprecated.class);
            }
            catch (NoSuchFieldException | SecurityException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    private String notNull(String value) {
        return value != null ? value : "";
    }

    private OCluster.ATTRIBUTES getClusterAttribute(OIdentifier attributeName) {
        return null;
    }

    private List<Integer> getClusters(OCommandContext ctx) {
        OStorage storage = ((ODatabaseDocumentInternal)ctx.getDatabase()).getStorage();
        if (this.starred) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (String clusterName : storage.getClusterNames()) {
                if (!clusterName.startsWith(this.name.getStringValue())) continue;
                result.add(storage.getClusterIdByName(clusterName));
            }
            return result;
        }
        int clusterId = ctx.getDatabase().getClusterIdByName(this.name.getStringValue());
        if (clusterId <= 0) {
            throw new OCommandExecutionException("Cannot find cluster " + this.name);
        }
        return Collections.singletonList(clusterId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAlterClusterStatement that = (OAlterClusterStatement)o;
        if (this.starred != that.starred) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.attributeName != null ? !this.attributeName.equals(that.attributeName) : that.attributeName != null) {
            return false;
        }
        return !(this.attributeValue != null ? !this.attributeValue.equals(that.attributeValue) : that.attributeValue != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.attributeName != null ? this.attributeName.hashCode() : 0);
        result = 31 * result + (this.starred ? 1 : 0);
        result = 31 * result + (this.attributeValue != null ? this.attributeValue.hashCode() : 0);
        return result;
    }
}

