/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.SequenceOrderType;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;
import java.util.Objects;

public class OAlterSequenceStatement
extends ODDLStatement {
    OIdentifier name;
    OExpression start;
    OExpression increment;
    OExpression cache;
    Boolean positive;
    Boolean cyclic;
    OExpression limitValue;
    boolean turnLimitOff = false;

    public OAlterSequenceStatement(int id) {
        super(id);
    }

    public OAlterSequenceStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        Object val;
        String sequenceName = this.name.getStringValue();
        if (sequenceName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OAlterSequenceStatement.getDatabase();
        OSequence sequence = database.getMetadata().getSequenceLibrary().getSequence(sequenceName);
        if (sequence == null) {
            throw new OCommandExecutionException("Sequence not found: " + sequenceName);
        }
        OSequence.CreateParams params = new OSequence.CreateParams();
        params.resetNull();
        if (this.start != null) {
            val = this.start.execute((OIdentifiable)null, ctx);
            if (!(val instanceof Number)) {
                throw new OCommandExecutionException("invalid start value for a sequence: " + val);
            }
            params.setStart(((Number)val).longValue());
        }
        if (this.increment != null) {
            val = this.increment.execute((OIdentifiable)null, ctx);
            if (!(val instanceof Number)) {
                throw new OCommandExecutionException("invalid increment value for a sequence: " + val);
            }
            params.setIncrement(((Number)val).intValue());
        }
        if (this.cache != null) {
            val = this.cache.execute((OIdentifiable)null, ctx);
            if (!(val instanceof Number)) {
                throw new OCommandExecutionException("invalid cache value for a sequence: " + val);
            }
            params.setCacheSize(((Number)val).intValue());
        }
        if (this.positive != null) {
            params.setOrderType(this.positive == true ? SequenceOrderType.ORDER_POSITIVE : SequenceOrderType.ORDER_NEGATIVE);
        }
        if (this.cyclic != null) {
            params.setRecyclable(this.cyclic);
        }
        if (this.limitValue != null) {
            val = this.limitValue.execute((OIdentifiable)null, ctx);
            if (!(val instanceof Number)) {
                throw new OCommandExecutionException("invalid cache value for a sequence: " + val);
            }
            params.setLimitValue(((Number)val).longValue());
        }
        if (this.turnLimitOff) {
            params.setTurnLimitOff(true);
        }
        try {
            sequence.updateParams(params);
        }
        catch (ODatabaseException exc) {
            String message = "Unable to execute command: " + exc.getMessage();
            OLogManager.instance().error(this, message, exc, new Object[]{null});
            throw new OCommandExecutionException(message);
        }
        sequence.save(database);
        OInternalResultSet result = new OInternalResultSet();
        OResultInternal item = new OResultInternal();
        item.setProperty("operation", "alter sequence");
        item.setProperty("sequenceName", sequenceName);
        if (params.getStart() != null) {
            item.setProperty("start", params.getStart());
        }
        if (params.getIncrement() != null) {
            item.setProperty("increment", params.getIncrement());
        }
        if (params.getCacheSize() != null) {
            item.setProperty("cacheSize", params.getCacheSize());
        }
        if (params.getLimitValue() != null) {
            item.setProperty("limitValue", params.getLimitValue());
        }
        if (params.getOrderType() != null) {
            item.setProperty("orderType", params.getOrderType().toString());
        }
        if (params.getRecyclable() != null) {
            item.setProperty("recycable", params.getRecyclable());
        }
        if (params.getTurnLimitOff() != null && params.getTurnLimitOff().booleanValue()) {
            item.setProperty("turnLimitOff", params.getTurnLimitOff());
        }
        result.add(item);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("ALTER SEQUENCE ");
        this.name.toString(params, builder);
        if (this.start != null) {
            builder.append(" START ");
            this.start.toString(params, builder);
        }
        if (this.increment != null) {
            builder.append(" INCREMENT ");
            this.increment.toString(params, builder);
        }
        if (this.cache != null) {
            builder.append(" CACHE ");
            this.cache.toString(params, builder);
        }
        if (this.positive != null) {
            String appendString = this.positive == true ? " ASC" : " DESC";
            builder.append(appendString);
        }
        if (this.cyclic != null) {
            builder.append(" CYCLE ").append(this.cyclic.toString().toUpperCase());
        }
        if (this.limitValue != null) {
            builder.append(" LIMIT ");
            this.limitValue.toString(params, builder);
        }
        if (this.turnLimitOff) {
            builder.append(" NOLIMIT");
        }
    }

    @Override
    public OAlterSequenceStatement copy() {
        OAlterSequenceStatement result = new OAlterSequenceStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.start = this.start == null ? null : this.start.copy();
        result.increment = this.increment == null ? null : this.increment.copy();
        result.cache = this.cache == null ? null : this.cache.copy();
        result.positive = this.positive;
        result.cyclic = this.cyclic;
        result.limitValue = this.limitValue == null ? null : this.limitValue.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAlterSequenceStatement that = (OAlterSequenceStatement)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        if (this.increment != null ? !this.increment.equals(that.increment) : that.increment != null) {
            return false;
        }
        if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) {
            return false;
        }
        if (!Objects.equals(this.positive, that.positive)) {
            return false;
        }
        if (!Objects.equals(this.cyclic, that.cyclic)) {
            return false;
        }
        if (!Objects.equals(this.limitValue, that.limitValue)) {
            return false;
        }
        return this.turnLimitOff == that.turnLimitOff;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.increment != null ? this.increment.hashCode() : 0);
        result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
        result = 31 * result + (this.positive != null ? this.positive.hashCode() : 0);
        result = 31 * result + (this.cyclic != null ? this.cyclic.hashCode() : 0);
        result = 31 * result + (this.limitValue != null ? this.limitValue.hashCode() : 0);
        result = 31 * result + Boolean.hashCode(this.turnLimitOff);
        return result;
    }
}

