/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.executor.AggregationContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OBaseIdentifier;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OMathExpression;
import com.orientechnologies.orient.core.sql.parser.OModifier;
import com.orientechnologies.orient.core.sql.parser.ONumber;
import com.orientechnologies.orient.core.sql.parser.ORecordAttribute;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OBaseExpression
extends OMathExpression {
    protected ONumber number;
    protected OBaseIdentifier identifier;
    protected OInputParameter inputParam;
    protected String string;
    OModifier modifier;

    public OBaseExpression(int id) {
        super(id);
    }

    public OBaseExpression(OrientSql p, int id) {
        super(p, id);
    }

    public OBaseExpression(OIdentifier identifier) {
        super(-1);
        this.identifier = new OBaseIdentifier(identifier);
    }

    public OBaseExpression(String string) {
        super(-1);
        this.string = "\"" + OStringSerializerHelper.encode(string) + "\"";
    }

    public OBaseExpression(OIdentifier identifier, OModifier modifier) {
        this(identifier);
        if (modifier != null) {
            this.modifier = modifier;
        }
    }

    public OBaseExpression(ORecordAttribute attr, OModifier modifier) {
        super(-1);
        this.identifier = new OBaseIdentifier(attr);
        if (modifier != null) {
            this.modifier = modifier;
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.number != null) {
            this.number.toString(params, builder);
        } else if (this.identifier != null) {
            this.identifier.toString(params, builder);
        } else if (this.string != null) {
            builder.append(this.string);
        } else if (this.inputParam != null) {
            this.inputParam.toString(params, builder);
        }
        if (this.modifier != null) {
            this.modifier.toString(params, builder);
        }
    }

    @Override
    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        Object result = null;
        if (this.number != null) {
            result = this.number.getValue();
        } else if (this.identifier != null) {
            result = this.identifier.execute(iCurrentRecord, ctx);
        } else if (this.string != null && this.string.length() > 1) {
            result = OStringSerializerHelper.decode(this.string.substring(1, this.string.length() - 1));
        } else if (this.inputParam != null) {
            result = this.inputParam.getValue(ctx.getInputParameters());
        }
        if (this.modifier != null) {
            result = this.modifier.execute(iCurrentRecord, result, ctx);
        }
        return result;
    }

    @Override
    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        Object result = null;
        if (this.number != null) {
            result = this.number.getValue();
        } else if (this.identifier != null) {
            result = this.identifier.execute(iCurrentRecord, ctx);
        } else if (this.string != null && this.string.length() > 1) {
            result = OStringSerializerHelper.decode(this.string.substring(1, this.string.length() - 1));
        } else if (this.inputParam != null) {
            result = this.inputParam.getValue(ctx.getInputParameters());
        }
        if (this.modifier != null) {
            result = this.modifier.execute(iCurrentRecord, result, ctx);
        }
        return result;
    }

    @Override
    protected boolean supportsBasicCalculation() {
        return true;
    }

    @Override
    public boolean isFunctionAny() {
        if (this.identifier == null) {
            return false;
        }
        return this.identifier.isFunctionAny();
    }

    @Override
    public boolean isIndexedFunctionCall() {
        if (this.identifier == null) {
            return false;
        }
        return this.identifier.isIndexedFunctionCall();
    }

    @Override
    public long estimateIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.identifier == null) {
            return -1L;
        }
        return this.identifier.estimateIndexedFunction(target, context, operator, right);
    }

    @Override
    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.identifier == null) {
            return null;
        }
        return this.identifier.executeIndexedFunction(target, context, operator, right);
    }

    @Override
    public boolean canExecuteIndexedFunctionWithoutIndex(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.identifier == null) {
            return false;
        }
        return this.identifier.canExecuteIndexedFunctionWithoutIndex(target, context, operator, right);
    }

    @Override
    public boolean allowsIndexedFunctionExecutionOnTarget(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.identifier == null) {
            return false;
        }
        return this.identifier.allowsIndexedFunctionExecutionOnTarget(target, context, operator, right);
    }

    @Override
    public boolean executeIndexedFunctionAfterIndexSearch(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.identifier == null) {
            return false;
        }
        return this.identifier.executeIndexedFunctionAfterIndexSearch(target, context, operator, right);
    }

    @Override
    public boolean isBaseIdentifier() {
        return this.identifier != null && this.modifier == null && this.identifier.isBaseIdentifier();
    }

    @Override
    public OCollate getCollate(OResult currentRecord, OCommandContext ctx) {
        return this.identifier != null && this.modifier == null ? this.identifier.getCollate(currentRecord, ctx) : null;
    }

    @Override
    public boolean isEarlyCalculated(OCommandContext ctx) {
        if (this.number != null || this.inputParam != null || this.string != null) {
            return true;
        }
        return this.identifier != null && this.identifier.isEarlyCalculated(ctx);
    }

    @Override
    public boolean isExpand() {
        if (this.identifier != null) {
            return this.identifier.isExpand();
        }
        return false;
    }

    @Override
    public OExpression getExpandContent() {
        return this.identifier.getExpandContent();
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        if (this.identifier != null && this.identifier.needsAliases(aliases)) {
            return true;
        }
        return this.modifier != null && this.modifier.needsAliases(aliases);
    }

    @Override
    public boolean isAggregate() {
        return this.identifier != null && this.identifier.isAggregate();
    }

    @Override
    public boolean isCount() {
        return this.identifier != null && this.identifier.isCount();
    }

    @Override
    public SimpleNode splitForAggregation(AggregateProjectionSplit aggregateProj, OCommandContext ctx) {
        if (this.isAggregate()) {
            SimpleNode splitResult = this.identifier.splitForAggregation(aggregateProj, ctx);
            if (splitResult instanceof OBaseIdentifier) {
                OBaseExpression result = new OBaseExpression(-1);
                result.identifier = (OBaseIdentifier)splitResult;
                return result;
            }
            return splitResult;
        }
        return this;
    }

    @Override
    public AggregationContext getAggregationContext(OCommandContext ctx) {
        if (this.identifier != null) {
            return this.identifier.getAggregationContext(ctx);
        }
        throw new OCommandExecutionException("cannot aggregate on " + this.toString());
    }

    @Override
    public OBaseExpression copy() {
        OBaseExpression result = new OBaseExpression(-1);
        result.number = this.number == null ? null : this.number.copy();
        result.identifier = this.identifier == null ? null : this.identifier.copy();
        result.inputParam = this.inputParam == null ? null : this.inputParam.copy();
        result.string = this.string;
        result.modifier = this.modifier == null ? null : this.modifier.copy();
        return result;
    }

    @Override
    public boolean refersToParent() {
        if (this.identifier != null && this.identifier.refersToParent()) {
            return true;
        }
        return this.modifier != null && this.modifier.refersToParent();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBaseExpression that = (OBaseExpression)o;
        if (this.number != null ? !this.number.equals(that.number) : that.number != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (this.inputParam != null ? !this.inputParam.equals(that.inputParam) : that.inputParam != null) {
            return false;
        }
        if (this.string != null ? !this.string.equals(that.string) : that.string != null) {
            return false;
        }
        return !(this.modifier != null ? !this.modifier.equals(that.modifier) : that.modifier != null);
    }

    @Override
    public int hashCode() {
        int result = this.number != null ? this.number.hashCode() : 0;
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + (this.inputParam != null ? this.inputParam.hashCode() : 0);
        result = 31 * result + (this.string != null ? this.string.hashCode() : 0);
        result = 31 * result + (this.modifier != null ? this.modifier.hashCode() : 0);
        return result;
    }

    public void setIdentifier(OBaseIdentifier identifier) {
        this.identifier = identifier;
    }

    public OBaseIdentifier getIdentifier() {
        return this.identifier;
    }

    public OModifier getModifier() {
        return this.modifier;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        if (this.identifier != null && this.identifier.toString().equals("$matched") && this.modifier != null && this.modifier.suffix != null && this.modifier.suffix.identifier != null) {
            return Collections.singletonList(this.modifier.suffix.identifier.toString());
        }
        return Collections.emptyList();
    }

    @Override
    public void applyRemove(OResultInternal result, OCommandContext ctx) {
        if (this.identifier != null) {
            if (this.modifier == null) {
                this.identifier.applyRemove(result, ctx);
            } else {
                Object val = this.identifier.execute(result, ctx);
                this.modifier.applyRemove(val, result, ctx);
            }
        }
    }

    @Override
    public OResult serialize() {
        OResultInternal result = (OResultInternal)super.serialize();
        if (this.number != null) {
            result.setProperty("number", this.number.serialize());
        }
        if (this.identifier != null) {
            result.setProperty("identifier", this.identifier.serialize());
        }
        if (this.inputParam != null) {
            result.setProperty("inputParam", this.inputParam.serialize());
        }
        if (this.string != null) {
            result.setProperty("string", this.string);
        }
        if (this.modifier != null) {
            result.setProperty("modifier", this.modifier.serialize());
        }
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        super.deserialize(fromResult);
        if (fromResult.getProperty("number") != null) {
            this.number = new ONumber(-1);
            this.number.deserialize((OResult)fromResult.getProperty("number"));
        }
        if (fromResult.getProperty("identifier") != null) {
            this.identifier = new OBaseIdentifier(-1);
            this.identifier.deserialize((OResult)fromResult.getProperty("identifier"));
        }
        if (fromResult.getProperty("inputParam") != null) {
            this.inputParam = OInputParameter.deserializeFromOResult((OResult)fromResult.getProperty("inputParam"));
        }
        if (fromResult.getProperty("string") != null) {
            this.string = (String)fromResult.getProperty("string");
        }
        if (fromResult.getProperty("modifier") != null) {
            this.modifier = new OModifier(-1);
            this.modifier.deserialize((OResult)fromResult.getProperty("modifier"));
        }
    }

    @Override
    public boolean isDefinedFor(OResult currentRecord) {
        if (this.identifier != null && this.modifier == null) {
            return this.identifier.isDefinedFor(currentRecord);
        }
        return true;
    }

    @Override
    public boolean isDefinedFor(OElement currentRecord) {
        if (this.identifier != null && this.modifier == null) {
            return this.identifier.isDefinedFor(currentRecord);
        }
        return true;
    }

    @Override
    public void extractSubQueries(OIdentifier letAlias, SubQueryCollector collector) {
        if (this.identifier != null) {
            this.identifier.extractSubQueries(letAlias, collector);
        }
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        if (this.identifier != null) {
            this.identifier.extractSubQueries(collector);
        }
    }

    @Override
    public boolean isCacheable() {
        if (this.modifier != null && !this.modifier.isCacheable()) {
            return false;
        }
        if (this.identifier != null) {
            return this.identifier.isCacheable();
        }
        return true;
    }

    public void setInputParam(OInputParameter inputParam) {
        this.inputParam = inputParam;
    }

    @Override
    public boolean isIndexChain(OCommandContext ctx, OClass clazz) {
        OProperty prop;
        OClass linkedClass;
        if (this.modifier == null) {
            return false;
        }
        if (this.identifier.isIndexChain(ctx, clazz) && (linkedClass = (prop = clazz.getProperty(this.identifier.getSuffix().identifier.getStringValue())).getLinkedClass()) != null) {
            return this.modifier.isIndexChain(ctx, linkedClass);
        }
        return false;
    }
}

