/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.ORecordAttribute;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class OCreateLinkStatement
extends OSimpleExecStatement {
    protected OIdentifier name;
    protected OIdentifier type;
    protected OIdentifier sourceClass;
    protected OIdentifier sourceField;
    protected ORecordAttribute sourceRecordAttr;
    protected OIdentifier destClass;
    protected OIdentifier destField;
    protected ORecordAttribute destRecordAttr;
    protected boolean inverse = false;
    boolean breakExec = false;

    public OCreateLinkStatement(int id) {
        super(id);
    }

    public OCreateLinkStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        this.execute(ctx);
        OInternalResultSet rs = new OInternalResultSet();
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "create link");
        result.setProperty("name", this.name.getValue());
        result.setProperty("fromClass", this.sourceClass.getStringValue());
        result.setProperty("toClass", this.destClass.getStringValue());
        rs.add(result);
        return rs;
    }

    private Object execute(OCommandContext ctx) {
        if (this.destField == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCreateLinkStatement.getDatabase();
        if (!(database.getDatabaseOwner() instanceof ODatabaseDocument)) {
            throw new OCommandSQLParsingException("This command supports only the database type ODatabaseDocumentTx and type '" + database.getClass() + "' was found");
        }
        ODatabaseDocument db = (ODatabaseDocument)((Object)database.getDatabaseOwner());
        OClass sourceClass = database.getMetadata().getSchema().getClass(this.getSourceClass().getStringValue());
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.getSourceClass().getStringValue() + "' not found");
        }
        OClass destClass = database.getMetadata().getSchema().getClass(this.getDestClass().getStringValue());
        if (destClass == null) {
            throw new OCommandExecutionException("Destination class '" + this.getDestClass().getStringValue() + "' not found");
        }
        String cmd = "select from ";
        if (!"@rid".equals(this.destField)) {
            cmd = "select from " + this.getDestClass() + " where " + this.destField + " = ";
        }
        long total = 0L;
        String linkName = this.name == null ? this.sourceField.getStringValue() : this.name.getStringValue();
        OType linkType = OType.valueOf(this.type.getStringValue().toUpperCase(Locale.ENGLISH));
        boolean multipleRelationship = linkType != null ? linkType == OType.LINKSET || linkType == OType.LINKLIST : false;
        database.declareIntent(new OIntentMassiveInsert());
        try {
            for (ODocument doc : db.browseClass(sourceClass.getName())) {
                if (this.breakExec) break;
                Object value = doc.getProperty(this.sourceField.getStringValue());
                if (value == null || value instanceof ODocument || value instanceof ORID || value instanceof Collection) continue;
                ODocument target = null;
                if (!"@rid".equals(this.destField) && value instanceof String) {
                    value = ((String)value).length() == 0 ? null : "'" + value + "'";
                }
                OResultSet rs = database.query(cmd + value, new Object[0]);
                List<ODocument> result = this.toList(rs);
                rs.close();
                if (result == null || result.size() == 0) {
                    value = null;
                } else {
                    if (result.size() > 1) {
                        throw new OCommandExecutionException("Cannot create link because multiple records was found in class '" + destClass.getName() + "' with value " + value + " in field '" + this.destField + "'");
                    }
                    target = result.get(0);
                    value = target;
                }
                if (target != null && this.inverse) {
                    Object oldValue = target.getProperty(linkName);
                    if (oldValue != null) {
                        ArrayList<ODocument> coll;
                        if (!multipleRelationship) {
                            multipleRelationship = true;
                        }
                        if (oldValue instanceof Collection) {
                            coll = (ArrayList<ODocument>)oldValue;
                            target.setDirty();
                        } else {
                            coll = new ArrayList<ODocument>(2);
                            target.setProperty(linkName, coll);
                            coll.add((ODocument)oldValue);
                        }
                        coll.add(doc);
                    } else {
                        if (linkType != null) {
                            if (linkType == OType.LINKSET) {
                                value = new ORecordLazySet(target);
                                ((Set)value).add(doc);
                            } else if (linkType == OType.LINKLIST) {
                                value = new ORecordLazyList(target);
                                ((ORecordLazyList)value).add(doc);
                            } else {
                                value = doc;
                            }
                        } else {
                            value = doc;
                        }
                        target.setProperty(linkName, value);
                    }
                    target.save();
                } else {
                    doc.setProperty(linkName, value);
                    doc.save();
                }
                ++total;
            }
            if (total > 0L) {
                OProperty prop;
                if (this.inverse) {
                    prop = destClass.getProperty(linkName);
                    if (prop != null) {
                        destClass.dropProperty(linkName);
                    }
                    if (linkType == null) {
                        linkType = multipleRelationship ? OType.LINKSET : OType.LINK;
                    }
                    destClass.createProperty(linkName, linkType, sourceClass);
                } else {
                    prop = sourceClass.getProperty(linkName);
                    if (prop != null) {
                        sourceClass.dropProperty(linkName);
                    }
                    sourceClass.createProperty(linkName, OType.LINK, destClass);
                }
            }
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Error on creation of links"), e);
        }
        finally {
            database.declareIntent(null);
        }
        return total;
    }

    private List<ODocument> toList(OResultSet rs) {
        if (!rs.hasNext()) {
            return null;
        }
        ArrayList<ODocument> result = new ArrayList<ODocument>();
        while (rs.hasNext()) {
            result.add(rs.next().getElement().orElse(null));
        }
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CREATE LINK ");
        this.name.toString(params, builder);
        builder.append(" TYPE ");
        this.type.toString(params, builder);
        builder.append(" FROM ");
        this.sourceClass.toString(params, builder);
        builder.append(".");
        if (this.sourceField != null) {
            this.sourceField.toString(params, builder);
        } else {
            this.sourceRecordAttr.toString(params, builder);
        }
        builder.append(" TO ");
        this.destClass.toString(params, builder);
        builder.append(".");
        if (this.destField != null) {
            this.destField.toString(params, builder);
        } else {
            this.destRecordAttr.toString(params, builder);
        }
        if (this.inverse) {
            builder.append(" INVERSE");
        }
    }

    @Override
    public OCreateLinkStatement copy() {
        OCreateLinkStatement result = new OCreateLinkStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.type = this.type == null ? null : this.type.copy();
        result.sourceClass = this.sourceClass == null ? null : this.sourceClass.copy();
        result.sourceField = this.sourceField == null ? null : this.sourceField.copy();
        result.sourceRecordAttr = this.sourceRecordAttr == null ? null : this.sourceRecordAttr.copy();
        result.destClass = this.destClass == null ? null : this.destClass.copy();
        result.destField = this.destField == null ? null : this.destField.copy();
        result.destRecordAttr = this.destRecordAttr == null ? null : this.destRecordAttr.copy();
        result.inverse = this.inverse;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateLinkStatement that = (OCreateLinkStatement)o;
        if (this.inverse != that.inverse) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.sourceClass != null ? !this.sourceClass.equals(that.sourceClass) : that.sourceClass != null) {
            return false;
        }
        if (this.sourceField != null ? !this.sourceField.equals(that.sourceField) : that.sourceField != null) {
            return false;
        }
        if (this.sourceRecordAttr != null ? !this.sourceRecordAttr.equals(that.sourceRecordAttr) : that.sourceRecordAttr != null) {
            return false;
        }
        if (this.destClass != null ? !this.destClass.equals(that.destClass) : that.destClass != null) {
            return false;
        }
        if (this.destField != null ? !this.destField.equals(that.destField) : that.destField != null) {
            return false;
        }
        return !(this.destRecordAttr != null ? !this.destRecordAttr.equals(that.destRecordAttr) : that.destRecordAttr != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.sourceClass != null ? this.sourceClass.hashCode() : 0);
        result = 31 * result + (this.sourceField != null ? this.sourceField.hashCode() : 0);
        result = 31 * result + (this.sourceRecordAttr != null ? this.sourceRecordAttr.hashCode() : 0);
        result = 31 * result + (this.destClass != null ? this.destClass.hashCode() : 0);
        result = 31 * result + (this.destField != null ? this.destField.hashCode() : 0);
        result = 31 * result + (this.destRecordAttr != null ? this.destRecordAttr.hashCode() : 0);
        result = 31 * result + (this.inverse ? 1 : 0);
        return result;
    }

    public OIdentifier getName() {
        return this.name;
    }

    public OIdentifier getType() {
        return this.type;
    }

    public OIdentifier getSourceClass() {
        return this.sourceClass;
    }

    public OIdentifier getSourceField() {
        return this.sourceField;
    }

    public ORecordAttribute getSourceRecordAttr() {
        return this.sourceRecordAttr;
    }

    public OIdentifier getDestClass() {
        return this.destClass;
    }

    public OIdentifier getDestField() {
        return this.destField;
    }

    public ORecordAttribute getDestRecordAttr() {
        return this.destRecordAttr;
    }

    public boolean isInverse() {
        return this.inverse;
    }
}

