/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class ODropSequenceStatement
extends ODDLStatement {
    OIdentifier name;
    boolean ifExists = false;

    public ODropSequenceStatement(int id) {
        super(id);
    }

    public ODropSequenceStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        ODatabase database = ctx.getDatabase();
        OSequence sequence = database.getMetadata().getSequenceLibrary().getSequence(this.name.getStringValue());
        if (sequence == null) {
            if (this.ifExists) {
                return new OInternalResultSet();
            }
            throw new OCommandExecutionException("Sequence not found: " + this.name);
        }
        try {
            database.getMetadata().getSequenceLibrary().dropSequence(this.name.getStringValue());
        }
        catch (ODatabaseException exc) {
            String message = "Unable to execute command: " + exc.getMessage();
            OLogManager.instance().error(this, message, exc, new Object[]{null});
            throw new OCommandExecutionException(message);
        }
        OInternalResultSet rs = new OInternalResultSet();
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "drop sequence");
        result.setProperty("sequenceName", this.name.getStringValue());
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("DROP SEQUENCE ");
        this.name.toString(params, builder);
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        }
    }

    @Override
    public ODropSequenceStatement copy() {
        ODropSequenceStatement result = new ODropSequenceStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.ifExists = this.ifExists;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODropSequenceStatement that = (ODropSequenceStatement)o;
        if (this.ifExists != that.ifExists) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

