/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.ONumber;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OFloatingPoint
extends ONumber {
    protected int sign = 1;
    protected String stringValue = null;
    Number finalValue = null;

    public OFloatingPoint(int id) {
        super(id);
    }

    public OFloatingPoint(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Number getValue() {
        if (this.finalValue != null) {
            return this.finalValue;
        }
        if (this.stringValue.endsWith("F") || this.stringValue.endsWith("f")) {
            try {
                this.finalValue = Float.valueOf(Float.parseFloat(this.stringValue.substring(0, this.stringValue.length() - 1)) * (float)this.sign);
            }
            catch (Exception ignore) {
                return null;
            }
        }
        if (this.stringValue.endsWith("D") || this.stringValue.endsWith("d")) {
            try {
                this.finalValue = Double.parseDouble(this.stringValue.substring(0, this.stringValue.length() - 1)) * (double)this.sign;
            }
            catch (Exception ignore) {
                return null;
            }
        }
        try {
            double returnValue = Double.parseDouble(this.stringValue) * (double)this.sign;
            this.finalValue = Math.abs(returnValue) < 3.4028234663852886E38 ? (Number)Float.valueOf((float)returnValue) : (Number)returnValue;
        }
        catch (Exception ignore) {
            return null;
        }
        return this.finalValue;
    }

    public int getSign() {
        return this.sign;
    }

    public void setSign(int sign) {
        this.sign = sign;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.sign == -1) {
            builder.append("-");
        }
        builder.append(this.stringValue);
    }

    @Override
    public OFloatingPoint copy() {
        OFloatingPoint result = new OFloatingPoint(-1);
        result.sign = this.sign;
        result.stringValue = this.stringValue;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OFloatingPoint that = (OFloatingPoint)o;
        if (this.sign != that.sign) {
            return false;
        }
        return !(this.stringValue != null ? !this.stringValue.equals(that.stringValue) : that.stringValue != null);
    }

    public int hashCode() {
        int result = this.sign;
        result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
        return result;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("sign", this.sign);
        result.setProperty("stringValue", this.stringValue);
        result.setProperty("finalValue", this.finalValue);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        this.sign = (Integer)fromResult.getProperty("sign");
        this.stringValue = (String)fromResult.getProperty("stringValue");
        this.finalValue = (Number)fromResult.getProperty("finalValue");
    }
}

