/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicy;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OPermission;
import com.orientechnologies.orient.core.sql.parser.OSecurityResourceSegment;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;
import java.util.Objects;

public class OGrantStatement
extends OSimpleExecStatement {
    protected OPermission permission;
    protected OIdentifier policyName;
    protected OSecurityResourceSegment securityResource;
    protected OIdentifier actor;

    public OGrantStatement(int id) {
        super(id);
    }

    public OGrantStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ODatabaseDocumentInternal db = OGrantStatement.getDatabase();
        ORole role = db.getMetadata().getSecurity().getRole(this.actor.getStringValue());
        if (role == null) {
            throw new OCommandExecutionException("Invalid role: " + this.actor.getStringValue());
        }
        String resourcePath = this.securityResource.toString();
        if (this.permission != null) {
            role.grant(resourcePath, this.toPrivilege(this.permission.permission));
            role.save();
        } else {
            OSecurityInternal security = db.getSharedContext().getSecurity();
            OSecurityPolicy policy = security.getSecurityPolicy(db, this.policyName.getStringValue());
            security.setSecurityPolicy(db, role, this.securityResource.toString(), policy);
        }
        OInternalResultSet rs = new OInternalResultSet();
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "grant");
        result.setProperty("role", this.actor.getStringValue());
        if (this.permission != null) {
            result.setProperty("permission", this.permission.toString());
        } else {
            result.setProperty("policy", this.policyName.getStringValue());
        }
        result.setProperty("resource", resourcePath);
        rs.add(result);
        return rs;
    }

    protected int toPrivilege(String privilegeName) {
        int privilege;
        if ("CREATE".equals(privilegeName)) {
            privilege = ORole.PERMISSION_CREATE;
        } else if ("READ".equals(privilegeName)) {
            privilege = ORole.PERMISSION_READ;
        } else if ("UPDATE".equals(privilegeName)) {
            privilege = ORole.PERMISSION_UPDATE;
        } else if ("DELETE".equals(privilegeName)) {
            privilege = ORole.PERMISSION_DELETE;
        } else if ("EXECUTE".equals(privilegeName)) {
            privilege = ORole.PERMISSION_EXECUTE;
        } else if ("ALL".equals(privilegeName)) {
            privilege = ORole.PERMISSION_ALL;
        } else if ("NONE".equals(privilegeName)) {
            privilege = 0;
        } else {
            throw new OCommandExecutionException("Unrecognized privilege '" + privilegeName + "'");
        }
        return privilege;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("GRANT ");
        if (this.permission != null) {
            this.permission.toString(params, builder);
        } else {
            builder.append("POLICY ");
            this.policyName.toString(params, builder);
        }
        builder.append(" ON ");
        this.securityResource.toString(params, builder);
        builder.append(" TO ");
        this.actor.toString(params, builder);
    }

    @Override
    public OGrantStatement copy() {
        OGrantStatement result = new OGrantStatement(-1);
        result.permission = this.permission == null ? null : this.permission.copy();
        result.securityResource = this.securityResource == null ? null : this.securityResource.copy();
        result.policyName = this.policyName == null ? null : this.policyName.copy();
        result.actor = this.actor == null ? null : this.actor.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OGrantStatement that = (OGrantStatement)o;
        return Objects.equals(this.permission, that.permission) && Objects.equals(this.policyName, that.policyName) && Objects.equals(this.securityResource, that.securityResource) && Objects.equals(this.actor, that.actor);
    }

    public int hashCode() {
        return Objects.hash(this.permission, this.policyName, this.securityResource, this.actor);
    }
}

