/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OHaSyncDatabaseStatement
extends OSimpleExecStatement {
    public boolean force = false;
    public boolean full = false;

    public OHaSyncDatabaseStatement(int id) {
        super(id);
    }

    public OHaSyncDatabaseStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ODatabaseDocumentInternal database = (ODatabaseDocumentInternal)ctx.getDatabase();
        try {
            boolean result = database.sync(this.force, !this.full);
            OResultInternal r = new OResultInternal();
            r.setProperty("result", result);
            OInternalResultSet rs = new OInternalResultSet();
            rs.add(r);
            return rs;
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Cannot execute HA SYNC DATABASE"), e);
        }
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("HA SYNC DATABASE");
        if (this.force) {
            builder.append(" -force");
        }
        if (this.full) {
            builder.append(" -full");
        }
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isFull() {
        return this.full;
    }
}

