/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OIsNullCondition
extends OBooleanExpression {
    protected OExpression expression;

    public OIsNullCondition(int id) {
        super(id);
    }

    public OIsNullCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        return this.expression.execute(currentRecord, ctx) == null;
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        return this.expression.execute(currentRecord, ctx) == null;
    }

    public OExpression getExpression() {
        return this.expression;
    }

    public void setExpression(OExpression expression) {
        this.expression = expression;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.expression.toString(params, builder);
        builder.append(" is null");
    }

    @Override
    public boolean supportsBasicCalculation() {
        return this.expression.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        if (this.expression.supportsBasicCalculation()) {
            return 0;
        }
        return 1;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        if (this.expression.supportsBasicCalculation()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(this.expression);
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        return this.expression.needsAliases(aliases);
    }

    @Override
    public OIsNullCondition copy() {
        OIsNullCondition result = new OIsNullCondition(-1);
        result.expression = this.expression.copy();
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        this.expression.extractSubQueries(collector);
    }

    @Override
    public boolean refersToParent() {
        return this.expression != null && this.expression.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIsNullCondition that = (OIsNullCondition)o;
        return !(this.expression != null ? !this.expression.equals(that.expression) : that.expression != null);
    }

    public int hashCode() {
        return this.expression != null ? this.expression.hashCode() : 0;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        return this.expression.getMatchPatternInvolvedAliases();
    }

    @Override
    public boolean isCacheable() {
        return this.expression.isCacheable();
    }
}

