/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OJsonItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OJson
extends SimpleNode {
    protected List<OJsonItem> items = new ArrayList<OJsonItem>();

    public OJson(int id) {
        super(id);
    }

    public OJson(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("{");
        boolean first = true;
        for (OJsonItem item : this.items) {
            if (!first) {
                builder.append(", ");
            }
            item.toString(params, builder);
            first = false;
        }
        builder.append("}");
    }

    public ODocument toDocument(OIdentifiable source, OCommandContext ctx) {
        String className = this.getClassNameForDocument(ctx);
        ODocument doc = className != null ? new ODocument(className) : new ODocument();
        for (OJsonItem item : this.items) {
            String name = item.getLeftValue();
            if (name == null) continue;
            Object value = item.right.value instanceof OJson ? ((OJson)item.right.value).toDocument(source, ctx) : item.right.execute(source, ctx);
            doc.field(name, value);
        }
        return doc;
    }

    private ODocument toDocument(OResult source, OCommandContext ctx, String className) {
        ODocument retDoc = new ODocument(className);
        for (OJsonItem item : this.items) {
            String name = item.getLeftValue();
            if (name == null || ODocumentHelper.getReservedAttributes().contains(name.toLowerCase(Locale.ENGLISH))) continue;
            Object value = item.right.execute(source, ctx);
            retDoc.field(name, value);
        }
        return retDoc;
    }

    public Object toObjectDetermineType(OResult source, OCommandContext ctx) {
        String className = this.getClassNameForDocument(ctx);
        String type = this.getTypeForDocument(ctx);
        if (className != null || type != null && "d".equalsIgnoreCase(type)) {
            return this.toDocument(source, ctx, className);
        }
        return this.toMap(source, ctx);
    }

    public Map<String, Object> toMap(OIdentifiable source, OCommandContext ctx) {
        LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
        for (OJsonItem item : this.items) {
            String name = item.getLeftValue();
            if (name == null) continue;
            Object value = item.right.execute(source, ctx);
            doc.put(name, value);
        }
        return doc;
    }

    public Map<String, Object> toMap(OResult source, OCommandContext ctx) {
        LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
        for (OJsonItem item : this.items) {
            String name = item.getLeftValue();
            if (name == null) continue;
            Object value = item.right.execute(source, ctx);
            doc.put(name, value);
        }
        return doc;
    }

    private String getClassNameForDocument(OCommandContext ctx) {
        for (OJsonItem item : this.items) {
            String left = item.getLeftValue();
            if (left == null || !left.toLowerCase(Locale.ENGLISH).equals("@class")) continue;
            return "" + item.right.execute((OResult)null, ctx);
        }
        return null;
    }

    private String getTypeForDocument(OCommandContext ctx) {
        for (OJsonItem item : this.items) {
            String left = item.getLeftValue();
            if (left == null || !left.toLowerCase(Locale.ENGLISH).equals("@type")) continue;
            return "" + item.right.execute((OResult)null, ctx);
        }
        return null;
    }

    public boolean needsAliases(Set<String> aliases) {
        for (OJsonItem item : this.items) {
            if (!item.needsAliases(aliases)) continue;
            return true;
        }
        return false;
    }

    public boolean isAggregate() {
        for (OJsonItem item : this.items) {
            if (!item.isAggregate()) continue;
            return true;
        }
        return false;
    }

    public OJson splitForAggregation(AggregateProjectionSplit aggregateSplit, OCommandContext ctx) {
        if (this.isAggregate()) {
            OJson result = new OJson(-1);
            for (OJsonItem item : this.items) {
                result.items.add(item.splitForAggregation(aggregateSplit, ctx));
            }
            return result;
        }
        return this;
    }

    @Override
    public OJson copy() {
        OJson result = new OJson(-1);
        result.items = this.items.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OJson oJson = (OJson)o;
        return !(this.items != null ? !this.items.equals(oJson.items) : oJson.items != null);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        for (OJsonItem item : this.items) {
            item.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        for (OJsonItem item : this.items) {
            if (!item.refersToParent()) continue;
            return true;
        }
        return false;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.items != null) {
            result.setProperty("items", this.items.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("items") != null) {
            List ser = (List)fromResult.getProperty("items");
            this.items = new ArrayList<OJsonItem>();
            for (OResult r : ser) {
                OJsonItem exp = new OJsonItem();
                exp.deserialize(r);
                this.items.add(exp);
            }
        }
    }

    public boolean isCacheable() {
        return false;
    }
}

