/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OLimit
extends SimpleNode {
    protected OInteger num;
    protected OInputParameter inputParam;

    public OLimit(int id) {
        super(id);
    }

    public OLimit(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.num == null && this.inputParam == null) {
            return;
        }
        builder.append(" LIMIT ");
        if (this.num != null) {
            this.num.toString(params, builder);
        } else {
            this.inputParam.toString(params, builder);
        }
    }

    public int getValue(OCommandContext ctx) {
        if (this.num != null) {
            return this.num.getValue().intValue();
        }
        if (this.inputParam != null) {
            Object paramValue = this.inputParam.getValue(ctx.getInputParameters());
            if (paramValue instanceof Number) {
                return ((Number)paramValue).intValue();
            }
            throw new OCommandExecutionException("Invalid value for LIMIT: " + paramValue);
        }
        throw new OCommandExecutionException("No value for LIMIT");
    }

    @Override
    public OLimit copy() {
        OLimit result = new OLimit(-1);
        result.num = this.num == null ? null : this.num.copy();
        result.inputParam = this.inputParam == null ? null : this.inputParam.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OLimit oLimit = (OLimit)o;
        if (this.num != null ? !this.num.equals(oLimit.num) : oLimit.num != null) {
            return false;
        }
        return !(this.inputParam != null ? !this.inputParam.equals(oLimit.inputParam) : oLimit.inputParam != null);
    }

    public int hashCode() {
        int result = this.num != null ? this.num.hashCode() : 0;
        result = 31 * result + (this.inputParam != null ? this.inputParam.hashCode() : 0);
        return result;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.num != null) {
            result.setProperty("num", this.num.serialize());
        }
        if (this.inputParam != null) {
            result.setProperty("inputParam", this.inputParam.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("num") != null) {
            this.num = new OInteger(-1);
            this.num.deserialize((OResult)fromResult.getProperty("num"));
        }
        if (fromResult.getProperty("inputParam") != null) {
            this.inputParam = OInputParameter.deserializeFromOResult((OResult)fromResult.getProperty("inputParam"));
        }
    }
}

