/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.ONestedProjection;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class ONestedProjectionItem
extends SimpleNode {
    protected boolean exclude = false;
    protected boolean star = false;
    protected OExpression expression;
    protected boolean rightWildcard = false;
    protected ONestedProjection expansion;
    protected OIdentifier alias;

    public ONestedProjectionItem(int id) {
        super(id);
    }

    public ONestedProjectionItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public ONestedProjectionItem copy() {
        ONestedProjectionItem result = new ONestedProjectionItem(-1);
        result.exclude = this.exclude;
        result.star = this.star;
        result.expression = this.expression == null ? null : this.expression.copy();
        result.rightWildcard = this.rightWildcard;
        result.expansion = this.expansion == null ? null : this.expansion.copy();
        result.alias = this.alias == null ? null : this.alias.copy();
        return result;
    }

    public boolean matches(String propertyName) {
        if (this.star) {
            return true;
        }
        if (this.expression != null) {
            String fieldString = this.expression.getDefaultAlias().getStringValue();
            if (fieldString.equals(propertyName)) {
                return true;
            }
            if (this.rightWildcard && propertyName.startsWith(fieldString)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.exclude) {
            builder.append("!");
        }
        if (this.star) {
            builder.append("*");
        }
        if (this.expression != null) {
            this.expression.toString(params, builder);
            if (this.rightWildcard) {
                builder.append("*");
            }
        }
        if (this.expansion != null) {
            this.expansion.toString(params, builder);
        }
        if (this.alias != null) {
            builder.append(" AS ");
            this.alias.toString(params, builder);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ONestedProjectionItem that = (ONestedProjectionItem)o;
        if (this.exclude != that.exclude) {
            return false;
        }
        if (this.star != that.star) {
            return false;
        }
        if (this.rightWildcard != that.rightWildcard) {
            return false;
        }
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        if (this.expansion != null ? !this.expansion.equals(that.expansion) : that.expansion != null) {
            return false;
        }
        return this.alias != null ? this.alias.equals(that.alias) : that.alias == null;
    }

    public int hashCode() {
        int result = this.exclude ? 1 : 0;
        result = 31 * result + (this.star ? 1 : 0);
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + (this.rightWildcard ? 1 : 0);
        result = 31 * result + (this.expansion != null ? this.expansion.hashCode() : 0);
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        return result;
    }

    public Object expand(OExpression expression, String name, Object value, OCommandContext ctx, int recursion) {
        return this.expansion.apply(expression, value, ctx);
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("exclude", this.exclude);
        result.setProperty("star", this.star);
        if (this.expression != null) {
            result.setProperty("expression", this.expression.serialize());
        }
        result.setProperty("rightWildcard", this.rightWildcard);
        if (this.expansion != null) {
            result.setProperty("expansion", this.expansion.serialize());
        }
        if (this.alias != null) {
            result.setProperty("alias", this.alias.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.exclude = (Boolean)fromResult.getProperty("exclude");
        this.star = (Boolean)fromResult.getProperty("star");
        if (fromResult.getProperty("field") != null) {
            this.expression = new OExpression(-1);
            this.expression.deserialize((OResult)fromResult.getProperty("expression"));
        }
        this.rightWildcard = (Boolean)fromResult.getProperty("rightWildcard");
        if (fromResult.getProperty("expansion") != null) {
            this.expansion = new ONestedProjection(-1);
            this.expansion.deserialize((OResult)fromResult.getProperty("expansion"));
        }
        if (fromResult.getProperty("alias") != null) {
            this.alias = OIdentifier.deserialize((OResult)fromResult.getProperty("alias"));
        }
    }
}

