/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OTruncateClusterStatement
extends ODDLStatement {
    public OIdentifier clusterName;
    public OInteger clusterNumber;
    public boolean unsafe = false;

    public OTruncateClusterStatement(int id) {
        super(id);
    }

    public OTruncateClusterStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        ODatabaseDocumentAbstract database = (ODatabaseDocumentAbstract)ctx.getDatabase();
        OInternalResultSet rs = new OInternalResultSet();
        Integer clusterId = null;
        clusterId = this.clusterNumber != null ? Integer.valueOf(this.clusterNumber.getValue().intValue()) : Integer.valueOf(database.getClusterIdByName(this.clusterName.getStringValue()));
        if (clusterId < 0) {
            throw new ODatabaseException("Cluster with name " + this.clusterName + " does not exist");
        }
        OSchemaProxy schema = database.getMetadata().getSchema();
        OClass clazz = schema.getClassByClusterId(clusterId);
        if (clazz == null) {
            String clusterName = database.getClusterNameById(clusterId);
            database.checkForClusterPermissions(clusterName);
            ORecordIteratorCluster<ODocument> iteratorCluster = database.browseCluster(clusterName);
            if (iteratorCluster == null) {
                throw new ODatabaseException("Cluster with name " + clusterName + " does not exist");
            }
            while (iteratorCluster.hasNext()) {
                Object record = iteratorCluster.next();
                record.delete();
            }
        } else {
            String name = database.getClusterNameById(clusterId);
            clazz.truncateCluster(name);
        }
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "truncate cluster");
        if (this.clusterName != null) {
            result.setProperty("clusterName", this.clusterName.getStringValue());
        }
        result.setProperty("clusterId", clusterId);
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("TRUNCATE CLUSTER ");
        if (this.clusterName != null) {
            this.clusterName.toString(params, builder);
        } else if (this.clusterNumber != null) {
            this.clusterNumber.toString(params, builder);
        }
        if (this.unsafe) {
            builder.append(" UNSAFE");
        }
    }

    @Override
    public OTruncateClusterStatement copy() {
        OTruncateClusterStatement result = new OTruncateClusterStatement(-1);
        result.clusterName = this.clusterName == null ? null : this.clusterName.copy();
        result.clusterNumber = this.clusterNumber == null ? null : this.clusterNumber.copy();
        result.unsafe = this.unsafe;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OTruncateClusterStatement that = (OTruncateClusterStatement)o;
        if (this.unsafe != that.unsafe) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        return !(this.clusterNumber != null ? !this.clusterNumber.equals(that.clusterNumber) : that.clusterNumber != null);
    }

    public int hashCode() {
        int result = this.clusterName != null ? this.clusterName.hashCode() : 0;
        result = 31 * result + (this.clusterNumber != null ? this.clusterNumber.hashCode() : 0);
        result = 31 * result + (this.unsafe ? 1 : 0);
        return result;
    }
}

