/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OTruncateRecordStatement
extends OSimpleExecStatement {
    protected ORid record;
    protected List<ORid> records;

    public OTruncateRecordStatement(int id) {
        super(id);
    }

    public OTruncateRecordStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ArrayList<ORid> recs = new ArrayList<ORid>();
        if (this.record != null) {
            recs.add(this.record);
        } else {
            recs.addAll(this.records);
        }
        OInternalResultSet rs = new OInternalResultSet();
        ODatabaseDocumentInternal database = (ODatabaseDocumentInternal)ctx.getDatabase();
        for (ORid rec : recs) {
            try {
                ORecordId rid = rec.toRecordId((OResult)null, ctx);
                OStorageOperationResult<Boolean> result = database.getStorage().deleteRecord(rid, -1, 0, null);
                database.getLocalCache().deleteRecord(rid);
                if (!result.getResult().booleanValue()) continue;
                OResultInternal recordRes = new OResultInternal();
                recordRes.setProperty("operation", "truncate record");
                recordRes.setProperty("record", rec.toString());
                rs.add(recordRes);
            }
            catch (Exception e) {
                throw OException.wrapException(new OCommandExecutionException("Error on executing command"), e);
            }
        }
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("TRUNCATE RECORD ");
        if (this.record != null) {
            this.record.toString(params, builder);
        } else {
            builder.append("[");
            boolean first = true;
            for (ORid r : this.records) {
                if (!first) {
                    builder.append(",");
                }
                r.toString(params, builder);
                first = false;
            }
            builder.append("]");
        }
    }

    @Override
    public OTruncateRecordStatement copy() {
        OTruncateRecordStatement result = new OTruncateRecordStatement(-1);
        result.record = this.record == null ? null : this.record.copy();
        result.records = this.records == null ? null : this.records.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OTruncateRecordStatement that = (OTruncateRecordStatement)o;
        if (this.record != null ? !this.record.equals(that.record) : that.record != null) {
            return false;
        }
        return !(this.records != null ? !this.records.equals(that.records) : that.records != null);
    }

    public int hashCode() {
        int result = this.record != null ? this.record.hashCode() : 0;
        result = 31 * result + (this.records != null ? this.records.hashCode() : 0);
        return result;
    }
}

