/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.OUpdateIncrementItem;
import com.orientechnologies.orient.core.sql.parser.OUpdateItem;
import com.orientechnologies.orient.core.sql.parser.OUpdatePutItem;
import com.orientechnologies.orient.core.sql.parser.OUpdateRemoveItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OUpdateOperations
extends SimpleNode {
    public static final int TYPE_SET = 0;
    public static final int TYPE_PUT = 1;
    public static final int TYPE_MERGE = 2;
    public static final int TYPE_CONTENT = 3;
    public static final int TYPE_INCREMENT = 4;
    public static final int TYPE_ADD = 5;
    public static final int TYPE_REMOVE = 6;
    protected int type;
    protected List<OUpdateItem> updateItems = new ArrayList<OUpdateItem>();
    protected List<OUpdatePutItem> updatePutItems = new ArrayList<OUpdatePutItem>();
    protected OJson json;
    protected List<OUpdateIncrementItem> updateIncrementItems = new ArrayList<OUpdateIncrementItem>();
    protected List<OUpdateRemoveItem> updateRemoveItems = new ArrayList<OUpdateRemoveItem>();

    public OUpdateOperations(int id) {
        super(id);
    }

    public OUpdateOperations(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        boolean first = true;
        switch (this.type) {
            case 0: {
                builder.append("SET ");
                for (OUpdateItem item : this.updateItems) {
                    if (!first) {
                        builder.append(", ");
                    }
                    item.toString(params, builder);
                    first = false;
                }
                break;
            }
            case 1: {
                builder.append("PUT ");
                for (OUpdatePutItem item : this.updatePutItems) {
                    if (!first) {
                        builder.append(", ");
                    }
                    item.toString(params, builder);
                    first = false;
                }
                break;
            }
            case 2: {
                builder.append("MERGE ");
                this.json.toString(params, builder);
                break;
            }
            case 3: {
                builder.append("CONTENT ");
                this.json.toString(params, builder);
                break;
            }
            case 4: {
                builder.append("INCREMENT ");
                for (OUpdateIncrementItem item : this.updateIncrementItems) {
                    if (!first) {
                        builder.append(", ");
                    }
                    item.toString(params, builder);
                    first = false;
                }
                break;
            }
            case 5: {
                builder.append("ADD ");
                for (OUpdateIncrementItem item : this.updateIncrementItems) {
                    if (!first) {
                        builder.append(", ");
                    }
                    item.toString(params, builder);
                    first = false;
                }
                break;
            }
            case 6: {
                builder.append("REMOVE ");
                for (OUpdateRemoveItem item : this.updateRemoveItems) {
                    if (!first) {
                        builder.append(", ");
                    }
                    item.toString(params, builder);
                    first = false;
                }
                break;
            }
        }
    }

    @Override
    public OUpdateOperations copy() {
        OUpdateOperations result = new OUpdateOperations(-1);
        result.type = this.type;
        result.updateItems = this.updateItems == null ? null : this.updateItems.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.updatePutItems = this.updatePutItems == null ? null : this.updatePutItems.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.json = this.json == null ? null : this.json.copy();
        result.updateIncrementItems = this.updateIncrementItems == null ? null : this.updateIncrementItems.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.updateRemoveItems = this.updateRemoveItems == null ? null : this.updateRemoveItems.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OUpdateOperations that = (OUpdateOperations)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.updateItems != null ? !this.updateItems.equals(that.updateItems) : that.updateItems != null) {
            return false;
        }
        if (this.updatePutItems != null ? !this.updatePutItems.equals(that.updatePutItems) : that.updatePutItems != null) {
            return false;
        }
        if (this.json != null ? !this.json.equals(that.json) : that.json != null) {
            return false;
        }
        if (this.updateIncrementItems != null ? !this.updateIncrementItems.equals(that.updateIncrementItems) : that.updateIncrementItems != null) {
            return false;
        }
        return !(this.updateRemoveItems != null ? !this.updateRemoveItems.equals(that.updateRemoveItems) : that.updateRemoveItems != null);
    }

    public int hashCode() {
        int result = this.type;
        result = 31 * result + (this.updateItems != null ? this.updateItems.hashCode() : 0);
        result = 31 * result + (this.updatePutItems != null ? this.updatePutItems.hashCode() : 0);
        result = 31 * result + (this.json != null ? this.json.hashCode() : 0);
        result = 31 * result + (this.updateIncrementItems != null ? this.updateIncrementItems.hashCode() : 0);
        result = 31 * result + (this.updateRemoveItems != null ? this.updateRemoveItems.hashCode() : 0);
        return result;
    }

    public int getType() {
        return this.type;
    }

    public List<OUpdateItem> getUpdateItems() {
        return this.updateItems;
    }

    public List<OUpdatePutItem> getUpdatePutItems() {
        return this.updatePutItems;
    }

    public OJson getJson() {
        return this.json;
    }

    public List<OUpdateIncrementItem> getUpdateIncrementItems() {
        return this.updateIncrementItems;
    }

    public List<OUpdateRemoveItem> getUpdateRemoveItems() {
        return this.updateRemoveItems;
    }
}

