/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.query;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.sql.query.OConcurrentLegacyResultSet;
import com.orientechnologies.orient.core.sql.query.OLegacyResultSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class OLiveLegacyResultSet<T>
extends OConcurrentLegacyResultSet<T> {
    private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OConcurrentLegacyResultSet<T> setCompleted() {
        Object object = this.waitForNextItem;
        synchronized (object) {
            this.waitForNextItem.notifyAll();
        }
        object = this.waitForCompletion;
        synchronized (object) {
            this.waitForCompletion.notifyAll();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        this.completed = true;
        Object object = this.waitForNextItem;
        synchronized (object) {
            this.waitForNextItem.notifyAll();
        }
        object = this.waitForCompletion;
        synchronized (object) {
            this.waitForCompletion.notifyAll();
        }
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                try {
                    Object result = OLiveLegacyResultSet.this.queue.take();
                    return result;
                }
                catch (InterruptedException e) {
                    OLiveLegacyResultSet.this.setCompleted();
                    Thread.currentThread().interrupt();
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("OLegacyResultSet.iterator.remove()");
            }
        };
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T t) {
        this.queue.offer(t);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T t : c) {
            this.add(t);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        for (T t : c) {
            this.add(t);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        this.add(element);
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("indexOf");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("lastIndexOf");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLimit() {
        return this.wrapped.getLimit();
    }

    @Override
    public OLegacyResultSet<T> setLimit(int limit) {
        this.wrapped.setLimit(limit);
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void waitForCompletion() {
        Object object = this.waitForCompletion;
        synchronized (object) {
            if (!this.completed) {
                try {
                    this.waitForCompletion.wait();
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error(this, "Thread was interrupted", e, new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void waitForNewItemOrCompleted() {
        Object object = this.waitForNextItem;
        synchronized (object) {
            try {
                this.waitForNextItem.wait();
            }
            catch (InterruptedException e) {
                OLogManager.instance().error(this, "Thread was interrupted", e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyNewItem() {
        Object object = this.waitForNextItem;
        synchronized (object) {
            this.waitForNextItem.notifyAll();
        }
    }

    @Override
    public OLiveLegacyResultSet<T> copy() {
        OLiveLegacyResultSet<T> newValue = new OLiveLegacyResultSet<T>();
        return newValue;
    }
}

