/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OClusterBrowsePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.io.IOException;

public interface OCluster {
    public void configure(int var1, String var2) throws IOException;

    public void configure(OStorage var1, OStorageClusterConfiguration var2) throws IOException;

    public void create(OAtomicOperation var1) throws IOException;

    public void open() throws IOException;

    public void close() throws IOException;

    public void close(boolean var1) throws IOException;

    public void delete(OAtomicOperation var1) throws IOException;

    public void setClusterName(String var1);

    public void setRecordConflictStrategy(String var1);

    public void setEncryption(String var1, String var2);

    public String encryption();

    public long getTombstonesCount();

    public OPhysicalPosition allocatePosition(byte var1, OAtomicOperation var2) throws IOException;

    public OPhysicalPosition createRecord(byte[] var1, int var2, byte var3, OPhysicalPosition var4, OAtomicOperation var5);

    public boolean deleteRecord(OAtomicOperation var1, long var2);

    public void updateRecord(long var1, byte[] var3, int var4, byte var5, OAtomicOperation var6);

    public ORawBuffer readRecord(long var1, boolean var3) throws IOException;

    public ORawBuffer readRecordIfVersionIsNotLatest(long var1, int var3) throws IOException, ORecordNotFoundException;

    public boolean exists();

    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition var1) throws IOException;

    public boolean isDeleted(OPhysicalPosition var1) throws IOException;

    public long getEntries();

    public long getFirstPosition() throws IOException;

    public long getLastPosition() throws IOException;

    public long getNextPosition() throws IOException;

    public String getFileName();

    public int getId();

    public void synch() throws IOException;

    public String getName();

    public long getRecordsSize() throws IOException;

    public String compression();

    public boolean isSystemCluster();

    public OPhysicalPosition[] higherPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] ceilingPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] lowerPositions(OPhysicalPosition var1) throws IOException;

    public OPhysicalPosition[] floorPositions(OPhysicalPosition var1) throws IOException;

    public ORecordConflictStrategy getRecordConflictStrategy();

    public void acquireAtomicExclusiveLock();

    public OClusterBrowsePage nextPage(long var1) throws IOException;

    public int getBinaryVersion();

    public static enum ATTRIBUTES {
        NAME,
        CONFLICTSTRATEGY,
        STATUS,
        ENCRYPTION;

    }
}

